/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.support.api;

import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.tests.support.api.ICondition;

public class OpenedSessionsCondition
implements ICondition {
    private final int expectedNumber;

    public OpenedSessionsCondition(int expectedNumber) {
        this.expectedNumber = expectedNumber;
    }

    @Override
    public boolean test() throws Exception {
        return SessionManager.INSTANCE.getSessions().stream().filter(Session::isOpen).count() == (long)this.expectedNumber;
    }

    @Override
    public String getFailureMessage() {
        return "The expected number of sessions (" + this.expectedNumber + ") was not reached.";
    }
}

