/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.wizards.pages;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.common.ui.tools.api.resource.WorkspaceResourceDialog;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SelectMetamodelWizardPage
extends WizardPage {
    private Text metamodelURI;
    private String[] extensions;
    private Combo metamodelType;
    private String[] types;
    private boolean chooseMetamodelType;

    public SelectMetamodelWizardPage(String pageName, String[] extensions) {
        this(pageName, extensions, false);
    }

    public SelectMetamodelWizardPage(String pageName, String[] extensions, boolean chooseMetamodelType) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription(Messages.SelectMetamodelWizardPage_description);
        this.extensions = extensions;
        this.chooseMetamodelType = chooseMetamodelType;
    }

    public void createControl(Composite parent) {
        Composite rootContainer = new Composite(parent, 0);
        GridLayout rootContainerLayout = new GridLayout();
        rootContainerLayout.numColumns = 1;
        rootContainerLayout.marginTop = 14;
        rootContainerLayout.verticalSpacing = 3;
        rootContainerLayout.marginLeft = 5;
        rootContainerLayout.marginRight = 5;
        rootContainer.setLayout((Layout)rootContainerLayout);
        Composite registryContainer = new Composite(rootContainer, 0);
        GridLayout registryContainerLayout = new GridLayout();
        registryContainerLayout.numColumns = 3;
        registryContainerLayout.verticalSpacing = 3;
        registryContainer.setLayout((Layout)registryContainerLayout);
        Label registryLabel = new Label(registryContainer, 0);
        registryLabel.setText(Messages.SelectMetamodelWizardPage_registryLabel);
        TreeSet registryValues = new TreeSet(EPackage.Registry.INSTANCE.keySet());
        final String[] valueLabels = registryValues.toArray(new String[registryValues.size()]);
        Combo comboBox = new Combo(registryContainer, 8);
        comboBox.setItems(valueLabels);
        comboBox.setVisibleItemCount(Math.min(valueLabels.length, 15));
        comboBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SelectMetamodelWizardPage.this.metamodelURI.setText(valueLabels[((Combo)e.widget).getSelectionIndex()]);
            }
        });
        Button button = new Button(registryContainer, 8);
        button.setText(Messages.SelectMetamodelWizardPage_browseButton);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectMetamodelWizardPage.this.handleBrowse();
            }
        });
        Composite uriContainer = new Composite(rootContainer, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        uriContainer.setLayoutData((Object)gridData);
        GridLayout uriContainerLayout = new GridLayout();
        uriContainerLayout.numColumns = 1;
        uriContainer.setLayout((Layout)uriContainerLayout);
        Label uriLabel = new Label(uriContainer, 0);
        uriLabel.setText(Messages.SelectMetamodelWizardPage_uriLabel);
        this.metamodelURI = new Text(uriContainer, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.metamodelURI.setLayoutData((Object)gridData);
        this.metamodelURI.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectMetamodelWizardPage.this.updateTypes();
                SelectMetamodelWizardPage.this.dialogChanged();
                SelectMetamodelWizardPage.this.metamodelURI.getText();
            }
        });
        if (this.chooseMetamodelType) {
            Composite typeContainer = new Composite(rootContainer, 0);
            GridData typeContainerGridData = new GridData(768);
            typeContainerGridData.horizontalSpan = 4;
            typeContainer.setLayoutData((Object)typeContainerGridData);
            GridLayout typeContainerLayout = new GridLayout();
            typeContainerLayout.numColumns = 1;
            typeContainer.setLayout((Layout)typeContainerLayout);
            Label typeLabel = new Label(typeContainer, 0);
            typeLabel.setText(Messages.SelectMetamodelWizardPage_typeValues);
            this.metamodelType = new Combo(typeContainer, 8);
            gridData = new GridData(768);
            gridData.horizontalSpan = 4;
            this.metamodelType.setLayoutData((Object)gridData);
            this.metamodelType.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    SelectMetamodelWizardPage.this.dialogChanged();
                }
            });
        }
        this.updateTypes();
        this.dialogChanged();
        this.setControl((Control)rootContainer);
    }

    private void handleBrowse() {
        WorkspaceResourceDialog dialog = new WorkspaceResourceDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 4, Messages.SelectMetamodelWizardPage_workspaceDialogTitle, Arrays.asList(this.extensions));
        dialog.open();
        if (dialog.getSelectedResources() != null && !dialog.getSelectedResources().isEmpty()) {
            this.metamodelURI.setText(((IResource)dialog.getSelectedResources().get(0)).getFullPath().toString());
        }
    }

    private void updateTypes() {
        if (this.metamodelType != null) {
            EClassifier[] classifiers;
            TreeSet<String> typeValues = new TreeSet<String>();
            String mmURI = this.getMetamodelURI();
            EPackage ePackage = SelectMetamodelWizardPage.getEPackage(mmURI);
            EClassifier[] eClassifierArray = classifiers = SelectMetamodelWizardPage.computeAllClassifiers(ePackage).toArray(new EClassifier[0]);
            int n = classifiers.length;
            int n2 = 0;
            while (n2 < n) {
                EClassifier classifier = eClassifierArray[n2];
                typeValues.add(SelectMetamodelWizardPage.getEClassifierShortPath(classifier));
                ++n2;
            }
            this.types = typeValues.toArray(new String[typeValues.size()]);
            this.metamodelType.setItems(this.types);
            if (this.types.length < 15) {
                this.metamodelType.setVisibleItemCount(this.types.length);
            } else {
                this.metamodelType.setVisibleItemCount(15);
            }
            int index = this.bestType(-1, "class", 0);
            index = this.bestType(index, "class", 1);
            index = this.bestType(index, "class", 2);
            index = this.bestType(index, "model", 0);
            index = this.bestType(index, "model", 1);
            index = this.bestType(index, "model", 2);
            index = this.bestType(index, "root", 0);
            index = this.bestType(index, "root", 1);
            index = this.bestType(index, "root", 2);
            index = this.bestType(index, "package", 0);
            index = this.bestType(index, "package", 1);
            index = this.bestType(index, "package", 2);
            if (index > -1) {
                this.metamodelType.select(index);
            }
        }
    }

    private static String getEClassifierShortPath(EClassifier eClassifier) {
        Object name = eClassifier.getName();
        if (eClassifier.getEPackage() != null) {
            name = eClassifier.getEPackage().getName() + "." + (String)name;
        }
        return name;
    }

    private static EPackage getEPackage(String uri) {
        return EPackage.Registry.INSTANCE.getEPackage(uri);
    }

    private static List<EClassifier> computeAllClassifiers(EPackage ePackage) {
        return SelectMetamodelWizardPage.computeAllClassifiersList(ePackage, false);
    }

    private static List<EClassifier> computeAllClassifiersList(EPackage ePackage, boolean classOnly) {
        BasicEList classifiers = new BasicEList();
        if (ePackage != null) {
            SelectMetamodelWizardPage.computeAllClassifiersList(ePackage, (List<EClassifier>)classifiers, classOnly);
        }
        return classifiers;
    }

    private static void computeAllClassifiersList(EPackage ePackage, List<EClassifier> all, boolean classOnly) {
        for (EClassifier classifier : ePackage.getEClassifiers()) {
            if (!classOnly) {
                all.add(classifier);
                continue;
            }
            if (!(classifier instanceof EClass) || ((EClass)classifier).isAbstract() || ((EClass)classifier).isInterface()) continue;
            all.add(classifier);
        }
        Iterator packages = ePackage.getESubpackages().iterator();
        while (packages.hasNext()) {
            SelectMetamodelWizardPage.computeAllClassifiersList((EPackage)packages.next(), all, classOnly);
        }
    }

    private int bestType(int index, String name, int level) {
        if (index == -1) {
            String nameLower = name.toLowerCase();
            int i = 0;
            while (i < this.types.length) {
                String type = this.types[i];
                int iDot = type.lastIndexOf(".");
                if (iDot > -1) {
                    type = type.substring(iDot + 1);
                }
                type = type.toLowerCase();
                if (level == 0 && type.equals(nameLower)) {
                    return i;
                }
                if (level == 1 && type.startsWith(nameLower)) {
                    return i;
                }
                if (level == 2 && type.endsWith(nameLower)) {
                    return i;
                }
                ++i;
            }
        }
        return index;
    }

    private void dialogChanged() {
        String mmURI = this.getMetamodelURI();
        if (mmURI.length() == 0) {
            this.updateStatus(Messages.SelectMetamodelWizardPage_statusNoURI);
        } else if (SelectMetamodelWizardPage.getEPackage(mmURI) == null) {
            this.updateStatus(Messages.SelectMetamodelWizardPage_statusUnknownURI);
        } else if (this.chooseMetamodelType && this.getMetamodelType().length() == 0) {
            this.updateStatus(Messages.SelectMetamodelWizardPage_noMetamodelType);
        } else {
            this.updateStatus(null);
        }
    }

    private void updateStatus(String message) {
        this.setMessage(message);
        this.setPageComplete(message == null);
    }

    public String getMetamodelURI() {
        return this.metamodelURI.getText();
    }

    public EPackage getEPackage() {
        return SelectMetamodelWizardPage.getEPackage(this.metamodelURI.getText());
    }

    public String getMetamodelType() {
        if (this.metamodelType != null && this.types != null && this.metamodelType.getSelectionIndex() > -1 && this.metamodelType.getSelectionIndex() < this.types.length) {
            return this.types[this.metamodelType.getSelectionIndex()];
        }
        return "";
    }
}

