/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.operation;

import com.google.common.base.Preconditions;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.layout.SequenceLayout;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.ext.base.Option;

public class SynchronizeGraphicalOrderingOperation
extends AbstractModelChangeOperation<Void> {
    private final Diagram sequenceDiagram;
    private final boolean pack;

    public SynchronizeGraphicalOrderingOperation(Diagram sequenceDiagram, boolean pack) {
        super("Synchronize graphical ordering");
        this.sequenceDiagram = (Diagram)Preconditions.checkNotNull((Object)sequenceDiagram);
        this.pack = pack;
    }

    public Void execute() {
        SequenceDDiagram diagram;
        Preconditions.checkNotNull((Object)this.sequenceDiagram);
        SequenceLayout sequenceLayout = new SequenceLayout(this.sequenceDiagram);
        Option<SequenceDiagram> sd = sequenceLayout.getSequenceDiagram();
        if (sd.some() && (diagram = (SequenceDDiagram)((SequenceDiagram)sd.get()).getNotationDiagram().getElement()) != null && diagram.getGraphicalOrdering().getEventEnds().size() == diagram.getSemanticOrdering().getEventEnds().size()) {
            boolean verticalLayout = sequenceLayout.verticalLayout(this.pack);
            boolean horizontalLayout = sequenceLayout.horizontalLayout(this.pack);
            boolean observationLayout = sequenceLayout.observationLayout(this.pack);
            if (verticalLayout || horizontalLayout || observationLayout) {
                sequenceLayout.flagSequenceEvents();
            }
        }
        return null;
    }
}

