/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.dialect.identifier;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.dialect.identifier.AbstractRepresentationElementIdentifier;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.ui.business.internal.dialect.identifier.NodeContainerIdentifier;

public class DiagramIdentifier
extends AbstractRepresentationElementIdentifier
implements NodeContainerIdentifier {
    private EObject semantic;
    private String descriptionName;
    private int index;

    public DiagramIdentifier(EObject semantic, String descriptionName, int index) {
        if (semantic == null || descriptionName == null) {
            throw new IllegalArgumentException("semantic & descriptionName are mandatories");
        }
        this.semantic = semantic;
        this.descriptionName = descriptionName;
        this.index = index;
    }

    public DiagramIdentifier(DSemanticDiagram diagram) {
        this(diagram.getTarget(), diagram.getDescription().getName(), DiagramIdentifier.getId((DDiagram)diagram));
    }

    public void setIndex(int index) {
        this.index = index;
    }

    private static int getId(DDiagram diagram) {
        return diagram.getName() == null ? -1 : diagram.getName().hashCode();
    }

    public int uniqueID() {
        int result = 1;
        result = 31 * result + this.semantic.hashCode();
        result = 31 * result + this.descriptionName.hashCode();
        result = 31 * result + this.index;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiagramIdentifier other = (DiagramIdentifier)obj;
        if (this.descriptionName == null ? other.descriptionName != null : !this.descriptionName.equals(other.descriptionName)) {
            return false;
        }
        if (this.semantic == null ? other.semantic != null : !EqualityHelper.areEquals((EObject)this.semantic, (EObject)other.semantic)) {
            return false;
        }
        return this.index == other.index;
    }
}

