/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.part;

import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ITraversalStrategy;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.common.ui.util.IWorkbenchPartDescriptor;
import org.eclipse.gmf.runtime.diagram.ui.OffscreenEditPartFactory;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDDiagramEditPart;
import org.eclipse.sirius.diagram.ui.internal.providers.SiriusMarkerNavigationProvider;
import org.eclipse.sirius.diagram.ui.internal.providers.SiriusValidationProvider;
import org.eclipse.sirius.diagram.ui.part.Messages;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorUtil;
import org.eclipse.sirius.diagram.ui.tools.internal.marker.SiriusMarkerNavigationProviderSpec;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.emf.AllContents;
import org.eclipse.sirius.tools.api.validation.constraint.RuleWrappingStatus;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class ValidateAction
extends Action {
    public static final String VALIDATE_ACTION_KEY = "validateAction";
    private IWorkbenchPartDescriptor workbenchPartDescriptor;

    public ValidateAction(IWorkbenchPartDescriptor workbenchPartDescriptor) {
        this.setId(VALIDATE_ACTION_KEY);
        this.setText(Messages.ValidateActionMessage);
        this.workbenchPartDescriptor = workbenchPartDescriptor;
    }

    public void run() {
        IWorkbenchPart workbenchPart = this.workbenchPartDescriptor.getPartPage().getActivePart();
        if (workbenchPart instanceof IDiagramWorkbenchPart) {
            final IDiagramWorkbenchPart part = (IDiagramWorkbenchPart)workbenchPart;
            try {
                new WorkspaceModifyDelegatingOperation(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                        ValidateAction.runValidation(part.getDiagramEditPart(), (View)part.getDiagram());
                    }
                }).run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                DiagramPlugin.getDefault().logError("Validation action failed", (Throwable)e);
            }
        }
    }

    public static void runValidation(View view) {
        try {
            if (SiriusDiagramEditorUtil.openDiagram(view.eResource())) {
                IEditorPart editorPart = EclipseUIUtil.getActiveEditor();
                if (editorPart instanceof IDiagramWorkbenchPart) {
                    ValidateAction.runValidation(((IDiagramWorkbenchPart)editorPart).getDiagramEditPart(), view);
                } else {
                    ValidateAction.runNonUIValidation(view);
                }
            }
        }
        catch (Exception e) {
            DiagramPlugin.getDefault().logError("Validation action failed", (Throwable)e);
        }
    }

    public static void runNonUIValidation(View view) {
        DiagramEditPart diagramEditPart = OffscreenEditPartFactory.getInstance().createDiagramEditPart(view.getDiagram());
        ValidateAction.runValidation(diagramEditPart, view);
    }

    public static void runValidation(DiagramEditPart diagramEditPart, View view) {
        final DiagramEditPart fpart = diagramEditPart;
        final View fview = view;
        SiriusValidationProvider.runWithConstraints(view, new Runnable(){

            @Override
            public void run() {
                ValidateAction.validate(fpart, fview);
            }
        });
    }

    private static Diagnostic runEMFValidator(EObject eObject) {
        return new Diagnostician(){

            public String getObjectLabel(EObject eObject) {
                return EMFCoreUtil.getQualifiedName((EObject)eObject, (boolean)true);
            }
        }.validate(eObject);
    }

    private static void validate(DiagramEditPart diagramEditPart, View view) {
        EObject element;
        IFile target = ValidateAction.getFileToMark(diagramEditPart, view);
        if (target != null) {
            SiriusMarkerNavigationProvider.deleteMarkers((IResource)target);
        }
        if (view.isSetElement() && (element = view.getElement()) != null) {
            IBatchValidator validator = ValidateAction.createBatchValidator();
            IStatus status = validator.validate(element);
            ValidateAction.createMarkers(target, status, diagramEditPart);
            if (element instanceof DSemanticDecorator) {
                ArrayList elementsToValidate = Lists.newArrayList();
                EObject semanticElement = ((DSemanticDecorator)element).getTarget();
                elementsToValidate.add(semanticElement);
                ValidateAction.createMarkers(target, ValidateAction.runEMFValidator(semanticElement), diagramEditPart);
                for (EObject representationElement : AllContents.of((EObject)view.getElement(), (EClass)ViewpointPackage.eINSTANCE.getDRepresentationElement())) {
                    elementsToValidate.addAll(((DRepresentationElement)representationElement).getSemanticElements());
                }
                validator.setTraversalStrategy((ITraversalStrategy)new ITraversalStrategy.Flat());
                IStatus status2 = validator.validate((Collection)elementsToValidate);
                ValidateAction.createMarkers(target, status2, diagramEditPart);
            }
        }
    }

    private static IFile getFileToMark(DiagramEditPart diagramEditPart, View view) {
        Resource targetResource = view.eResource();
        if (diagramEditPart instanceof IDDiagramEditPart) {
            Session session;
            Option<DDiagram> ddiagram = ((IDDiagramEditPart)diagramEditPart).resolveDDiagram();
            Session session2 = session = ddiagram.some() && ddiagram.get() instanceof DSemanticDiagram ? SessionManager.INSTANCE.getSession(((DSemanticDiagram)ddiagram.get()).getTarget()) : null;
            if (session != null) {
                targetResource = session.getSessionResource();
            }
        }
        IFile target = targetResource != null ? WorkspaceSynchronizer.getFile((Resource)targetResource) : null;
        return target;
    }

    private static IBatchValidator createBatchValidator() {
        IBatchValidator validator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
        validator.setIncludeLiveConstraints(true);
        return validator;
    }

    private static void createMarkers(IFile target, IStatus validationStatus, DiagramEditPart diagramEditPart) {
        if (validationStatus.isOK()) {
            return;
        }
        IStatus rootStatus = validationStatus;
        ArrayList allStatuses = new ArrayList();
        SiriusDiagramEditorUtil.LazyElement2ViewMap element2ViewMap = new SiriusDiagramEditorUtil.LazyElement2ViewMap((View)diagramEditPart.getDiagramView(), ValidateAction.collectTargetElements(rootStatus, new HashSet(), allStatuses));
        for (IConstraintStatus nextStatus : allStatuses) {
            View view = SiriusDiagramEditorUtil.findView(diagramEditPart, nextStatus.getTarget(), element2ViewMap);
            String qualifiedName = EMFCoreUtil.getQualifiedName((EObject)nextStatus.getTarget(), (boolean)true);
            if (nextStatus instanceof RuleWrappingStatus) {
                ValidateAction.createValidationRuleMarker((RuleWrappingStatus)nextStatus, diagramEditPart.getViewer(), target, view, qualifiedName, nextStatus.getMessage(), nextStatus.getSeverity());
                continue;
            }
            ValidateAction.addMarker(diagramEditPart.getViewer(), target, view, qualifiedName, nextStatus.getMessage(), nextStatus.getSeverity());
        }
    }

    private static void createValidationRuleMarker(RuleWrappingStatus nextStatus, EditPartViewer viewer, IFile target, View view, String location, String message, int statusSeverity) {
        if (target == null) {
            return;
        }
        String elementId = view.eResource().getURIFragment((EObject)view);
        String semanticURI = null;
        EObject ddiagramElement = view.getElement();
        if (ddiagramElement instanceof DSemanticDecorator) {
            EObject semanticElement = ((DSemanticDecorator)ddiagramElement).getTarget();
            semanticURI = EcoreUtil.getURI((EObject)semanticElement).toString();
        }
        Object object = viewer.getFocusEditPart().getModel();
        String diagramUri = null;
        if (object instanceof Diagram) {
            URI uri = EcoreUtil.getURI((EObject)((Diagram)object));
            diagramUri = uri.toString();
        }
        SiriusMarkerNavigationProviderSpec.addValidationRuleMarker(nextStatus.getOriginRule(), target, elementId, diagramUri, semanticURI, location, message, statusSeverity);
    }

    private static void createMarkers(IFile target, Diagnostic emfValidationStatus, DiagramEditPart diagramEditPart) {
        if (emfValidationStatus.getSeverity() == 0) {
            return;
        }
        Diagnostic rootStatus = emfValidationStatus;
        ArrayList allDiagnostics = new ArrayList();
        SiriusDiagramEditorUtil.LazyElement2ViewMap element2ViewMap = new SiriusDiagramEditorUtil.LazyElement2ViewMap((View)diagramEditPart.getDiagramView(), ValidateAction.collectTargetElements(rootStatus, new HashSet(), allDiagnostics));
        for (Diagnostic nextDiagnostic : emfValidationStatus.getChildren()) {
            List data = nextDiagnostic.getData();
            if (data == null || data.isEmpty() || !(data.get(0) instanceof EObject)) continue;
            EObject element = (EObject)data.get(0);
            View view = SiriusDiagramEditorUtil.findView(diagramEditPart, element, element2ViewMap);
            ValidateAction.addMarker(diagramEditPart.getViewer(), target, view, EMFCoreUtil.getQualifiedName((EObject)element, (boolean)true), nextDiagnostic.getMessage(), ValidateAction.diagnosticToStatusSeverity(nextDiagnostic.getSeverity()));
        }
    }

    private static void addMarker(EditPartViewer viewer, IFile target, View view, String location, String message, int statusSeverity) {
        if (target == null) {
            return;
        }
        String elementId = view.eResource().getURIFragment((EObject)view);
        String semanticURI = null;
        EObject ddiagramElement = view.getElement();
        if (ddiagramElement instanceof DSemanticDecorator) {
            EObject semanticElement = ((DSemanticDecorator)ddiagramElement).getTarget();
            semanticURI = EcoreUtil.getURI((EObject)semanticElement).toString();
        }
        Object object = viewer.getFocusEditPart().getModel();
        String diagramUri = null;
        if (object instanceof Diagram) {
            URI uri = EcoreUtil.getURI((EObject)((Diagram)object));
            diagramUri = uri.toString();
        }
        SiriusMarkerNavigationProviderSpec.addMarker(target, elementId, diagramUri, semanticURI, location, message, statusSeverity);
    }

    private static int diagnosticToStatusSeverity(int diagnosticSeverity) {
        if (diagnosticSeverity == 0) {
            return 0;
        }
        if (diagnosticSeverity == 1) {
            return 1;
        }
        if (diagnosticSeverity == 2) {
            return 2;
        }
        if (diagnosticSeverity == 4 || diagnosticSeverity == 8) {
            return 4;
        }
        return 1;
    }

    private static Set collectTargetElements(IStatus status, Set targetElementCollector, List allConstraintStatuses) {
        if (status instanceof IConstraintStatus) {
            targetElementCollector.add(((IConstraintStatus)status).getTarget());
            allConstraintStatuses.add(status);
        }
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                ValidateAction.collectTargetElements(children[i], targetElementCollector, allConstraintStatuses);
                ++i;
            }
        }
        return targetElementCollector;
    }

    private static Set collectTargetElements(Diagnostic diagnostic, Set targetElementCollector, List allDiagnostics) {
        List data = diagnostic.getData();
        EObject target = null;
        if (data != null && !data.isEmpty() && data.get(0) instanceof EObject) {
            target = (EObject)data.get(0);
            targetElementCollector.add(target);
            allDiagnostics.add(diagnostic);
        }
        if (diagnostic.getChildren() != null && !diagnostic.getChildren().isEmpty()) {
            Iterator it = diagnostic.getChildren().iterator();
            while (it.hasNext()) {
                ValidateAction.collectTargetElements((Diagnostic)it.next(), targetElementCollector, allDiagnostics);
            }
        }
        return targetElementCollector;
    }
}

