/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.style;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.ui.business.api.image.ImageSelector;
import org.eclipse.sirius.diagram.ui.business.api.image.ImageSelectorService;
import org.eclipse.sirius.diagram.ui.edit.api.part.IAbstractDiagramNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class SetStyleToWorkspaceImageAction
extends Action
implements ISelectionListener {
    public static final String SET_STYLE_TO_WORKSPACE_IMAGE_ACTION_ID = "org.eclipse.sirius.diagram.tools.internal.actions.style";
    public static final String SET_STYLE_TO_WORKSPACE_IMAGE_ACTION_NAME = "Set style to workspace image";

    public SetStyleToWorkspaceImageAction() {
        super(SET_STYLE_TO_WORKSPACE_IMAGE_ACTION_NAME);
        this.setId(SET_STYLE_TO_WORKSPACE_IMAGE_ACTION_ID);
        ImageDescriptor enabledImage = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/image_obj.gif");
        ImageDescriptor disabledImage = ImageDescriptor.createWithFlags((ImageDescriptor)enabledImage, (int)1);
        this.setImageDescriptor(enabledImage);
        this.setDisabledImageDescriptor(disabledImage);
    }

    public void run() {
        ImageSelector imageSelector = ImageSelectorService.INSTANCE.getImageSelector();
        List<BasicLabelStyle> styles = this.getStyles();
        for (BasicLabelStyle basicLabelStyle : styles) {
            String imagePath = imageSelector.selectImage(basicLabelStyle);
            if (imagePath == null) continue;
            ImageSelectorService.INSTANCE.updateStyle(basicLabelStyle, imagePath);
        }
    }

    private List<BasicLabelStyle> getStyles() {
        ArrayList<BasicLabelStyle> styles = new ArrayList<BasicLabelStyle>();
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object[] objectArray = structuredSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDiagramElementEditPart diagramElementEditPart;
                DDiagramElement dde;
                DDiagramElementQuery ddeQuery;
                Option oldStyle;
                Object selectedEditPart = objectArray[n2];
                if (selectedEditPart instanceof IDiagramElementEditPart && (oldStyle = (ddeQuery = new DDiagramElementQuery(dde = (diagramElementEditPart = (IDiagramElementEditPart)selectedEditPart).resolveDiagramElement())).getLabelStyle()).some()) {
                    BasicLabelStyle basicLabelStyle = (BasicLabelStyle)oldStyle.get();
                    styles.add(basicLabelStyle);
                }
                ++n2;
            }
        }
        return styles;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.setEnabled(this.shouldBeEnabled(selection));
    }

    private boolean shouldBeEnabled(ISelection selection) {
        boolean result = false;
        if (selection instanceof IStructuredSelection) {
            result = true;
            Iterator it = ((IStructuredSelection)selection).iterator();
            while (it.hasNext() && result) {
                if (it.next() instanceof IAbstractDiagramNodeEditPart) continue;
                result = false;
            }
        }
        return result;
    }
}

