/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.policies;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.RelativeBendpoint;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.sirius.diagram.ui.business.api.query.ConnectionQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramEdgeEditPart;
import org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.handles.SiriusConnectionEndPointHandle;
import org.eclipse.sirius.ext.base.Option;

public class SiriusConnectionEndPointEditPolicy
extends ConnectionEndpointEditPolicy {
    private ConnectionAnchor originalAnchor;
    private Object originalConstraint;
    private List<Point> originalPoints;

    protected List createSelectionHandles() {
        ArrayList<SiriusConnectionEndPointHandle> list = new ArrayList<SiriusConnectionEndPointHandle>();
        list.add(new SiriusConnectionEndPointHandle((AbstractDiagramEdgeEditPart)this.getHost(), 2));
        list.add(new SiriusConnectionEndPointHandle((AbstractDiagramEdgeEditPart)this.getHost(), 3));
        return list;
    }

    protected void showConnectionMoveFeedback(ReconnectRequest request) {
        Option<List<RelativeBendpoint>> optionalRelativeBendpointsContraint;
        boolean isOrthogonalTreeBranch = new ConnectionQuery(this.getConnection()).isOrthogonalTreeBranch(this.getConnection().getPoints());
        ConnectionQuery connectionQuery = new ConnectionQuery(this.getConnection());
        if (isOrthogonalTreeBranch) {
            if (this.originalAnchor == null) {
                this.originalAnchor = request.isMovingStartAnchor() ? this.getConnection().getSourceAnchor() : this.getConnection().getTargetAnchor();
                this.originalPoints = Lists.newLinkedList();
                this.originalConstraint = this.getConnection().getRoutingConstraint();
                optionalRelativeBendpointsContraint = connectionQuery.getTreeRelativeBendpointsConstraint();
                if (optionalRelativeBendpointsContraint.some()) {
                    for (RelativeBendpoint relativeBendpoint : (List)optionalRelativeBendpointsContraint.get()) {
                        this.originalPoints.add(relativeBendpoint.getLocation());
                    }
                } else {
                    Option<List<AbsoluteBendpoint>> optionalAsboluteBendpointsContraint = connectionQuery.getTreeAbsoluteBendpointsConstraint();
                    if (optionalAsboluteBendpointsContraint.some()) {
                        for (AbsoluteBendpoint absoluteBendpoint : (List)optionalAsboluteBendpointsContraint.get()) {
                            this.originalPoints.add(absoluteBendpoint.getLocation().getCopy());
                        }
                    }
                }
                if (this.originalPoints.isEmpty()) {
                    int i = 0;
                    while (i < this.getConnection().getPoints().size()) {
                        this.originalPoints.add(this.getConnection().getPoints().getPoint(i).getCopy());
                        ++i;
                    }
                }
            }
        } else if (this.originalAnchor != null) {
            this.getConnection().setRoutingConstraint(this.originalConstraint);
        }
        super.showConnectionMoveFeedback(request);
        if (isOrthogonalTreeBranch) {
            int deltaX;
            optionalRelativeBendpointsContraint = connectionQuery.getTreeRelativeBendpointsConstraint();
            Option<List<AbsoluteBendpoint>> optionalAsboluteBendpointsContraint = connectionQuery.getTreeAbsoluteBendpointsConstraint();
            ArrayList points = Lists.newArrayList();
            for (Point point : this.originalPoints) {
                points.add(point.getCopy());
            }
            Point newSourceRefPoint = this.getConnection().getSourceAnchor().getReferencePoint();
            this.getConnection().translateToRelative((Translatable)newSourceRefPoint);
            Point newTargetRefPoint = this.getConnection().getTargetAnchor().getReferencePoint();
            this.getConnection().translateToRelative((Translatable)newTargetRefPoint);
            if (request.isMovingStartAnchor()) {
                deltaX = ((Point)points.get((int)0)).x - newSourceRefPoint.x;
                ((Point)points.get(0)).translate(deltaX, 0);
                ((Point)points.get(1)).translate(deltaX, 0);
            } else {
                deltaX = newTargetRefPoint.x - ((Point)points.get((int)3)).x;
                ((Point)points.get(2)).translate(deltaX, 0);
                ((Point)points.get(3)).translate(deltaX, 0);
            }
            if (optionalRelativeBendpointsContraint.some() || optionalAsboluteBendpointsContraint.some()) {
                int i;
                if (optionalRelativeBendpointsContraint.some()) {
                    i = 0;
                    while (i < points.size()) {
                        Dimension s = ((Point)points.get(i)).getDifference(newSourceRefPoint);
                        Dimension t = ((Point)points.get(i)).getDifference(newTargetRefPoint);
                        ((RelativeBendpoint)((List)optionalRelativeBendpointsContraint.get()).get(i)).setRelativeDimensions(s, t);
                        ++i;
                    }
                    this.getConnection().setRoutingConstraint(optionalRelativeBendpointsContraint.get());
                } else {
                    i = 0;
                    while (i < points.size()) {
                        ((AbsoluteBendpoint)((List)optionalAsboluteBendpointsContraint.get()).get(i)).setLocation((Point)points.get(i));
                        ++i;
                    }
                    this.getConnection().setRoutingConstraint(optionalAsboluteBendpointsContraint.get());
                }
            } else {
                LinkedList newConstraint = Lists.newLinkedList();
                int i = 0;
                while (i < points.size()) {
                    Dimension s = ((Point)points.get(i)).getDifference(newSourceRefPoint);
                    Dimension t = ((Point)points.get(i)).getDifference(newTargetRefPoint);
                    RelativeBendpoint rb = new RelativeBendpoint(this.getConnection());
                    rb.setRelativeDimensions(s, t);
                    rb.setWeight((float)i / ((float)points.size() - 1.0f));
                    newConstraint.add(rb);
                    ++i;
                }
                this.getConnection().setRoutingConstraint((Object)newConstraint);
            }
        }
    }

    protected void eraseConnectionMoveFeedback(ReconnectRequest request) {
        super.eraseConnectionMoveFeedback(request);
        if (this.originalAnchor != null) {
            this.getConnection().setRoutingConstraint(this.originalConstraint);
            this.originalAnchor = null;
        }
        this.originalConstraint = null;
    }
}

