/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.layout.provider;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GroupEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.providers.internal.CompositeLayoutProvider;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graph.AdvancedSubGraph;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramElementContainerEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.layout.LayoutExtender;
import org.eclipse.sirius.diagram.ui.tools.api.layout.PinHelper;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.ExtendableLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.ArrangeAllWithAutoSize;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.AutoSizeAndRegionAwareGraphLayout;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.DiagramLayoutCustomization;

public abstract class AbstractCompositeLayoutProvider
extends CompositeLayoutProvider
implements ExtendableLayoutProvider {
    private final LayoutExtender extender = new LayoutExtender(this);
    private final DiagramLayoutCustomization padder = new DiagramLayoutCustomization();
    private final ArrangeAllWithAutoSize autoSize = new ArrangeAllWithAutoSize();
    private Predicate<Object> validateAllElementInArrayListAreIDiagramElementEditPart = new Predicate<Object>(){

        public boolean apply(Object input) {
            return input instanceof IDiagramElementEditPart;
        }
    };
    private ArrayList<IDiagramElementEditPart> elementsToKeepFixed = Lists.newArrayList();

    public abstract Rectangle translateToGraph(Rectangle var1);

    public abstract Rectangle translateFromGraph(Rectangle var1);

    public boolean provides(IOperation operation) {
        return true;
    }

    @Override
    public boolean handleConnectableListItems() {
        return this.shouldHandleConnectableListItems();
    }

    @Override
    public Rectangle provideNodeMetrics(Node node) {
        return this.getNodeMetrics(node);
    }

    @Override
    public LayoutExtender getExtender() {
        return this.extender;
    }

    public Command layoutEditParts(List selectedObjects, IAdaptable layoutHint) {
        this.padder.initializePaddingWithEditParts(selectedObjects);
        this.extender.startLayouting();
        this.elementsToKeepFixed.clear();
        if (layoutHint.getAdapter(Collection.class) instanceof ArrayList && Iterables.all((Iterable)((ArrayList)layoutHint.getAdapter(Collection.class)), this.validateAllElementInArrayListAreIDiagramElementEditPart)) {
            this.elementsToKeepFixed = new ArrayList((ArrayList)layoutHint.getAdapter(Collection.class));
        }
        Command result = super.layoutEditParts(selectedObjects, layoutHint);
        this.elementsToKeepFixed.clear();
        return result;
    }

    protected DirectedGraphLayout createGraphLayout() {
        return new AutoSizeAndRegionAwareGraphLayout();
    }

    protected List getRelevantConnections(final Hashtable editPartToNodeDict) {
        List list = super.getRelevantConnections(new Hashtable(){

            @Override
            public synchronized Object get(Object key) {
                if (key != null) {
                    return editPartToNodeDict.get(key);
                }
                return null;
            }

            @Override
            public synchronized Enumeration keys() {
                return editPartToNodeDict.keys();
            }
        });
        return this.extender.getRelevantConnections(editPartToNodeDict, list);
    }

    protected Command update_diagram(GraphicalEditPart diagramEP, DirectedGraph g, boolean isLayoutForSelected) {
        CompoundCommand cc = new CompoundCommand("");
        Point diff = this.getLayoutPositionDelta(g, isLayoutForSelected);
        this.layoutDefaultMargin = MapModeUtil.getMapMode((IFigure)diagramEP.getFigure()).DPtoLP(25);
        Command cmd = this.createNodeChangeBoundCommands(g, diff);
        if (cmd != null) {
            cc.add(cmd);
        }
        if ((cmd = this.createEdgesChangeBoundsCommands(g, diff)) != null) {
            cc.add(cmd);
        }
        return cc;
    }

    private Point getLayoutPositionDelta(DirectedGraph g, boolean isLayoutForSelected) {
        if (isLayoutForSelected) {
            ListIterator vi = g.nodes.listIterator();
            Point ptLayoutMin = new Point(-1, -1);
            while (vi.hasNext()) {
                Node node = (Node)vi.next();
                if (node.data == null) continue;
                Rectangle nodeExt = this.getNodeMetricsConsideringBorderedNodes(node);
                if (ptLayoutMin.x == -1) {
                    ptLayoutMin.x = nodeExt.x;
                    ptLayoutMin.y = nodeExt.y;
                    continue;
                }
                ptLayoutMin.x = Math.min(ptLayoutMin.x, nodeExt.x);
                ptLayoutMin.y = Math.min(ptLayoutMin.y, nodeExt.y);
            }
            return new Point(this.minX - ptLayoutMin.x, this.minY - ptLayoutMin.y);
        }
        return new Point(this.layoutDefaultMargin, this.layoutDefaultMargin);
    }

    private Rectangle getNodeMetricsConsideringBorderedNodes(Node node) {
        Rectangle result = this.getNodeMetrics(node);
        if (node instanceof Subgraph && node.data instanceof IGraphicalEditPart) {
            Subgraph subGraph = (Subgraph)node;
            NodeList children = subGraph.members;
            int i = 0;
            while (i < children.size()) {
                Node child = children.getNode(i);
                if (child instanceof IBorderItemEditPart) {
                    result.union(this.getNodeMetrics(child));
                }
                ++i;
            }
        }
        return result;
    }

    protected EdgeList buildEdges(List selectedObjects, Map editPartToNodeDict) {
        return super.buildEdges(this.extender.filterEdges(selectedObjects, editPartToNodeDict), editPartToNodeDict);
    }

    protected NodeList buildNodes(List selectedObjects, Map editPartToNodeDict, Subgraph rootGraph) {
        ListIterator li = selectedObjects.listIterator();
        this.autoSize.prepareForArrangeAll((Iterator<AbstractDiagramElementContainerEditPart>)Iterators.filter(li, AbstractDiagramElementContainerEditPart.class));
        NodeList nodes = new NodeList();
        li = selectedObjects.listIterator();
        while (li.hasNext()) {
            IGraphicalEditPart gep = (IGraphicalEditPart)li.next();
            boolean hasChildren = this.hasChildren(gep);
            if (gep instanceof IBorderItemEditPart || !(gep instanceof ShapeEditPart) && !(gep instanceof ShapeCompartmentEditPart)) continue;
            org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart ep = (org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)gep;
            Point position = ep.getFigure().getBounds().getLocation();
            if (this.minX == -1) {
                this.minX = position.x;
                this.minY = position.y;
            } else {
                this.minX = Math.min(this.minX, position.x);
                this.minY = Math.min(this.minY, position.y);
            }
            Node n = null;
            if (hasChildren && !(gep instanceof GroupEditPart)) {
                AdvancedSubGraph subGraph = null;
                subGraph = rootGraph != null ? new AdvancedSubGraph((Object)ep, rootGraph) : new AdvancedSubGraph((Object)ep);
                subGraph.setAutoSize(this.isAutoSizeOn(subGraph, (IGraphicalEditPart)ep));
                if (gep instanceof CompartmentEditPart) {
                    subGraph.setHasBufferedZone(true);
                }
                subGraph.setDirection(this.getLayoutDirection(ep));
                n = subGraph;
            } else {
                n = rootGraph != null ? new Node((Object)ep, rootGraph) : new Node((Object)ep);
            }
            this.adjustNodePadding(n, editPartToNodeDict);
            Dimension size = this.autoSize.getSizeToConsiderDuringArrangeAll((IGraphicalEditPart)ep);
            this.setNodeMetrics(n, new Rectangle(position.x, position.y, size.width, size.height));
            editPartToNodeDict.put(ep, n);
            nodes.add((Object)n);
            if (!hasChildren || gep instanceof GroupEditPart) continue;
            this.buildNodes(gep.getChildren(), editPartToNodeDict, (Subgraph)n);
        }
        return nodes;
    }

    private boolean isAutoSizeOn(AdvancedSubGraph subGraph, IGraphicalEditPart gEP) {
        if (gEP instanceof CompartmentEditPart && subGraph.getParent() instanceof AdvancedSubGraph) {
            if (((AdvancedSubGraph)subGraph.getParent()).isAutoSize()) {
                return true;
            }
        } else {
            org.eclipse.gmf.runtime.notation.Node node;
            LayoutConstraint contraint;
            View notationView = gEP.getNotationView();
            if (notationView != null && notationView instanceof org.eclipse.gmf.runtime.notation.Node && (contraint = (node = (org.eclipse.gmf.runtime.notation.Node)notationView).getLayoutConstraint()) instanceof Size) {
                Size size = (Size)contraint;
                if (size.getHeight() != -1 && size.getWidth() != -1) {
                    return ArrangeAllWithAutoSize.isEnabled();
                }
                return true;
            }
        }
        return false;
    }

    protected void createSubCommands(Point diff, ListIterator vi, CompoundCommand cc) {
        ArrayList nodes = Lists.newArrayList((Iterator)vi);
        if (ArrangeAllWithAutoSize.isEnabled()) {
            this.autoSize.createSubCommands(diff, nodes.listIterator(), cc, this, this.minX, this.minY);
        } else {
            super.createSubCommands(diff, nodes.listIterator(), cc);
        }
        this.extender.keepLocationChanges(nodes, diff);
    }

    protected void adjustNodePadding(Node node, Map editPartToNodeDict) {
        org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart ep = (org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)node.data;
        Insets padding = this.padder.getNodePadding((GraphicalEditPart)ep);
        org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart parent = (org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)ep.getParent();
        if (parent != null && node.getParent() != null && editPartToNodeDict.get(parent) != node.getParent()) {
            IFigure thisFigure = parent.getFigure();
            IFigure parentFigure = ((org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)node.getParent().data).getFigure();
            Point parentLocation = parentFigure.getBounds().getLocation();
            Point nodeLocation = thisFigure.getBounds().getLocation();
            thisFigure.translateToAbsolute((Translatable)nodeLocation);
            parentFigure.translateToAbsolute((Translatable)parentLocation);
            Dimension delta = nodeLocation.getDifference(parentLocation);
            Rectangle rect = this.translateToGraph(new Rectangle(delta.width, delta.height, 0, 0));
            padding.top += rect.y;
            padding.left += rect.x;
        }
        node.setPadding(padding);
    }

    protected Command routeThrough(Edge edge, ConnectionEditPart connectEP, Node source, Node target, PointList points, Point diff) {
        if (connectEP instanceof IGraphicalEditPart && this.isPinned((IGraphicalEditPart)connectEP) || this.elementsToKeepFixed != null && this.elementsToKeepFixed.contains(connectEP)) {
            return null;
        }
        return super.routeThrough(edge, connectEP, source, target, points, diff);
    }

    protected boolean isPinned(IGraphicalEditPart part) {
        boolean isPinned = false;
        if (part.resolveSemanticElement() instanceof DDiagramElement) {
            DDiagramElement dDiagramElement = (DDiagramElement)part.resolveSemanticElement();
            isPinned = new PinHelper().isPinned(dDiagramElement);
        }
        return isPinned;
    }
}

