/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.api.query;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.business.api.query.DMappingBasedQuery;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.viewpoint.DMappingBased;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class EdgeMappingQuery
extends DiagramElementMappingQuery {
    private EdgeMapping mapping;

    public EdgeMappingQuery(EdgeMapping mapping) {
        super(mapping);
        this.mapping = mapping;
    }

    public boolean canCreate(DMappingBased source, DMappingBased target) {
        return new DMappingBasedQuery(source).isFromAnyMapping((Collection<? extends DiagramElementMapping>)this.mapping.getSourceMapping()) && new DMappingBasedQuery(target).isFromAnyMapping((Collection<? extends DiagramElementMapping>)this.mapping.getTargetMapping());
    }

    public boolean evaluatePrecondition(DSemanticDiagram diagram, DragAndDropTarget containerView, IInterpreter interpreter, EObject semantic, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        DslCommonPlugin.PROFILER.startWork("Check precondition expressions");
        boolean result = true;
        if (!StringUtil.isEmpty((String)this.mapping.getPreconditionExpression())) {
            EObject container = null;
            if (containerView instanceof DSemanticDecorator) {
                container = ((DSemanticDecorator)containerView).getTarget();
            }
            interpreter.setVariable("containerView", (Object)containerView);
            interpreter.setVariable("container", (Object)container);
            interpreter.setVariable("viewpoint", (Object)diagram);
            interpreter.setVariable("diagram", (Object)diagram);
            interpreter.setVariable("sourceView", (Object)sourceView);
            interpreter.setVariable("targetView", (Object)targetView);
            interpreter.setVariable("source", (Object)sourceView.getTarget());
            interpreter.setVariable("target", (Object)targetView.getTarget());
            try {
                result = interpreter.evaluateBoolean(semantic, this.mapping.getPreconditionExpression());
            }
            catch (EvaluationException e) {
                SiriusPlugin.getDefault().warning("the following edge mapping precondition could not be correctly evaluated : " + this.mapping.getPreconditionExpression(), (Exception)((Object)e));
            }
            interpreter.unSetVariable("target");
            interpreter.unSetVariable("source");
            interpreter.unSetVariable("targetView");
            interpreter.unSetVariable("sourceView");
            interpreter.unSetVariable("container");
            interpreter.unSetVariable("containerView");
            interpreter.unSetVariable("diagram");
            interpreter.unSetVariable("viewpoint");
        }
        DslCommonPlugin.PROFILER.stopWork("Check precondition expressions");
        return result;
    }

    public Collection<EObject> evaluateSourceFinderExpression(DSemanticDiagram diagram, IInterpreter interpreter, EObject sourceSemantic) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        interpreter.setVariable("viewPoint", (Object)diagram);
        interpreter.setVariable("viewpoint", (Object)diagram);
        interpreter.setVariable("diagram", (Object)diagram);
        try {
            try {
                Collection sourceSemantics = interpreter.evaluateCollection(sourceSemantic, this.mapping.getSourceFinderExpression());
                if (sourceSemantics != null) {
                    result.addAll(sourceSemantics);
                }
            }
            catch (EvaluationException e) {
                SiriusPlugin.getDefault().warning("the following edge mapping source finder expression could not be correctly evaluated : " + this.mapping.getSourceFinderExpression(), (Exception)((Object)e));
                interpreter.unSetVariable("diagram");
                interpreter.unSetVariable("viewpoint");
                interpreter.unSetVariable("viewPoint");
            }
        }
        finally {
            interpreter.unSetVariable("diagram");
            interpreter.unSetVariable("viewpoint");
            interpreter.unSetVariable("viewPoint");
        }
        return result;
    }

    public boolean hasTargetFinderExpression() {
        return this.mapping.getTargetFinderExpression() != null && !StringUtil.isEmpty((String)this.mapping.getTargetFinderExpression());
    }

    public Collection<EObject> evaluateTargetFinderExpression(DSemanticDiagram diagram, IInterpreter interpreter, EObject sourceSemantic) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        interpreter.setVariable("viewPoint", (Object)diagram);
        interpreter.setVariable("viewpoint", (Object)diagram);
        interpreter.setVariable("diagram", (Object)diagram);
        try {
            try {
                Collection targetSemantics = interpreter.evaluateCollection(sourceSemantic, this.mapping.getTargetFinderExpression());
                if (targetSemantics != null) {
                    result.addAll(targetSemantics);
                }
            }
            catch (EvaluationException e) {
                SiriusPlugin.getDefault().warning("the following edge mapping target finder expression could not be correctly evaluated : " + this.mapping.getTargetFinderExpression(), (Exception)((Object)e));
                interpreter.unSetVariable("diagram");
                interpreter.unSetVariable("viewpoint");
                interpreter.unSetVariable("viewPoint");
            }
        }
        finally {
            interpreter.unSetVariable("diagram");
            interpreter.unSetVariable("viewpoint");
            interpreter.unSetVariable("viewPoint");
        }
        return result;
    }
}

