/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.internal.command.builders;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.helper.task.InitInterpreterVariablesTask;
import org.eclipse.sirius.business.api.helper.task.UnexecutableTask;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.internal.helper.task.DeleteDDiagramElementTask;
import org.eclipse.sirius.business.internal.helper.task.DeleteDRepresentationTask;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.business.api.query.IEdgeMappingQuery;
import org.eclipse.sirius.diagram.business.internal.helper.task.DeleteSeveralDDiagramElementsTask;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.tool.DeleteElementDescription;
import org.eclipse.sirius.diagram.tools.internal.command.builders.AbstractDiagramCommandBuilder;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.tools.api.command.NoNullResourceCommand;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public class DeletionCommandBuilder
extends AbstractDiagramCommandBuilder {
    protected static final String DELETE = "Delete";
    protected static final String DELETE_FROM_DIAGRAM_LABEL = "Delete from diagram";
    protected static final String DELETE_FROM_MODEL = "Delete from model ";
    protected static final String DELETE_DIAGRAM_LABEL = "Delete diagram";
    private DDiagram diagram;
    private DDiagramElement diagramElement;
    private DeleteElementDescription tool;
    private boolean deleteFromDiagram;

    public DeletionCommandBuilder() {
    }

    public DeletionCommandBuilder(DDiagram diagram) {
        this.diagram = diagram;
    }

    public DeletionCommandBuilder(DDiagramElement diagramElement, boolean deleteFromDiagram) {
        this.diagramElement = diagramElement;
        this.deleteFromDiagram = deleteFromDiagram;
    }

    public Command buildCommand() {
        UnexecutableCommand command = UnexecutableCommand.INSTANCE;
        if (this.diagram != null) {
            command = this.buildDeleteDiagram();
        } else if (this.diagramElement != null) {
            command = this.deleteFromDiagram ? this.buildDeleteDiagramElementFromDiagram() : this.buildDeleteDiagramElement();
        }
        return command;
    }

    private Command buildDeleteDiagram() {
        UnexecutableCommand cmd = UnexecutableCommand.INSTANCE;
        if (this.permissionAuthority.canEditInstance((EObject)this.diagram) && this.permissionAuthority.canEditInstance(this.diagram.eContainer())) {
            DCommand vpCmd = this.createEnclosingCommand();
            this.addDeleteDiagramTask(vpCmd, this.diagram);
            cmd = vpCmd;
        }
        return cmd;
    }

    private Command buildDeleteDiagramElementFromDiagram() {
        if (this.permissionAuthority.canEditInstance((EObject)this.diagramElement) && this.permissionAuthority.canEditInstance(this.diagramElement.eContainer())) {
            DCommand cmd = this.createEnclosingCommand();
            cmd.getTasks().add(this.createDeleteDiagramElementTask(this.diagramElement));
            ArrayList contents = Lists.newArrayList((Iterable)this.modelAccessor.eAllContents((EObject)this.diagramElement, "EdgeTarget"));
            contents.add(this.diagramElement);
            for (EObject element : contents) {
                if (!(element instanceof EdgeTarget)) continue;
                EdgeTarget target = (EdgeTarget)element;
                for (DEdge edge : Iterables.concat(target.getIncomingEdges(), target.getOutgoingEdges())) {
                    cmd.getTasks().add(this.createDeleteDiagramElementTask(edge));
                }
            }
            return cmd;
        }
        return UnexecutableCommand.INSTANCE;
    }

    private DeleteDDiagramElementTask createDeleteDiagramElementTask(DDiagramElement aDiagramElement) {
        DeleteDDiagramElementTask task = new DeleteDDiagramElementTask((EObject)aDiagramElement, this.modelAccessor);
        return task;
    }

    private Command buildDeleteDiagramElement() {
        UnexecutableCommand cmd = UnexecutableCommand.INSTANCE;
        if (this.permissionAuthority.canEditInstance((EObject)this.diagramElement) && this.permissionAuthority.canEditInstance(this.diagramElement.eContainer())) {
            boolean semanticElementCanBeDeleted = true;
            Set<EObject> allSemanticElements = this.getSemanticElementsToDestroy(this.diagramElement);
            for (EObject semantic : allSemanticElements) {
                EObject container = semantic.eContainer();
                if (this.permissionAuthority.canDeleteInstance(semantic) && (container == null || this.permissionAuthority.canEditInstance(container))) continue;
                semanticElementCanBeDeleted = false;
            }
            if (semanticElementCanBeDeleted) {
                DCommand result = this.createEnclosingCommand();
                this.setTool();
                if (this.tool != null) {
                    this.addDeleteDiagramElementFromTool(result);
                    this.addRefreshTask(this.diagramElement, result, (AbstractToolDescription)this.tool);
                    cmd = new NoNullResourceCommand((Command)result, (EObject)this.diagramElement);
                } else {
                    cmd = this.buildDeleteDiagramElementCommandWithoutTool(result);
                }
            }
        }
        return cmd;
    }

    private void setTool() {
        DiagramElementMapping mapping = null;
        mapping = this.diagramElement.getDiagramElementMapping();
        if (mapping != null) {
            this.tool = mapping.getDeletionDescription();
        }
    }

    private void addDeleteDiagramElementFromTool(DCommand cmd) {
        EObject semanticContainer = this.diagramElement.getTarget();
        EObject viewContainer = this.diagramElement.eContainer();
        boolean delete = true;
        if (this.tool.getPrecondition() != null && !StringUtil.isEmpty((String)this.tool.getPrecondition().trim())) {
            delete = false;
            IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)this.diagramElement);
            interpreter.setVariable("containerView", (Object)viewContainer);
            interpreter.setVariable("view", (Object)this.diagramElement);
            interpreter.setVariable("element", (Object)semanticContainer);
            try {
                delete = false;
                delete = interpreter.evaluateBoolean(semanticContainer, this.tool.getPrecondition());
            }
            catch (EvaluationException e) {
                RuntimeLoggerManager.INSTANCE.error((EObject)this.tool, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition(), (Throwable)e);
            }
            interpreter.unSetVariable("containerView");
            interpreter.unSetVariable("view");
            interpreter.unSetVariable("element");
        }
        if (delete) {
            Option<EdgeMapping> edgeMapping;
            cmd.getTasks().addAll(this.buildDeleteFromToolTask(semanticContainer, viewContainer).getTasks());
            cmd.getTasks().add(new DeleteSeveralDDiagramElementsTask(this.editingDomain, this.modelAccessor, this.uiCallback, cmd, this.diagramElement));
            if (this.diagramElement instanceof DEdge && (edgeMapping = new IEdgeMappingQuery(((DEdge)this.diagramElement).getActualMapping()).getEdgeMapping()).some() && !((EdgeMapping)edgeMapping.get()).isUseDomainElement()) {
                cmd.getTasks().add(new DeleteDDiagramElementTask((EObject)this.diagramElement, this.modelAccessor));
            }
        } else {
            cmd.getTasks().add(UnexecutableTask.INSTANCE);
        }
    }

    private DCommand buildDeleteFromToolTask(EObject deletedSemanticElement, EObject containerView) {
        DCommand result = this.createEnclosingCommand();
        if (this.permissionAuthority.canEditInstance(containerView)) {
            IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)deletedSemanticElement);
            HashMap<Object, Object> variables = new HashMap<Object, Object>();
            result.getTasks().add(new InitInterpreterVariablesTask(variables, interpreter, this.uiCallback));
            variables.put(this.tool.getContainerView(), containerView);
            variables.put(this.tool.getElement(), deletedSemanticElement);
            variables.put(this.tool.getElementView(), this.diagramElement);
            this.addDiagramVariable(result, containerView, interpreter);
            Option<DDiagram> parentDiagram = new EObjectQuery(containerView).getParentDiagram();
            if (this.tool.getInitialOperation() != null && this.tool.getInitialOperation().getFirstModelOperations() != null) {
                result.getTasks().add(this.taskHelper.buildTaskFromModelOperation((DRepresentation)parentDiagram.get(), deletedSemanticElement, this.tool.getInitialOperation().getFirstModelOperations()));
            }
        } else {
            result.getTasks().add(UnexecutableTask.INSTANCE);
        }
        return result;
    }

    private Command buildDeleteDiagramElementCommandWithoutTool(DCommand result) {
        DCommand cmd;
        Set<EObject> allSemanticElements = this.getSemanticElementsToDestroy(this.diagramElement);
        if (allSemanticElements.isEmpty()) {
            cmd = result;
        } else {
            DDiagram parentDiagram = this.diagramElement.getParentDiagram();
            if (parentDiagram != null) {
                Set diagramElements = this.taskHelper.getDElementToClearFromSemanticElements((EObject)parentDiagram, allSemanticElements);
                for (DSemanticDecorator decorator : diagramElements) {
                    result.getTasks().add(new DeleteDDiagramElementTask((EObject)decorator, this.modelAccessor));
                    if (!(decorator instanceof EdgeTarget)) continue;
                    for (DEdge incommingEdge : ((EdgeTarget)decorator).getIncomingEdges()) {
                        result.getTasks().add(new DeleteDDiagramElementTask((EObject)incommingEdge, this.modelAccessor));
                    }
                    for (DEdge outgoingEdge : ((EdgeTarget)decorator).getOutgoingEdges()) {
                        result.getTasks().add(new DeleteDDiagramElementTask((EObject)outgoingEdge, this.modelAccessor));
                    }
                }
            }
            for (EObject semantic : allSemanticElements) {
                DeleteDDiagramElementTask deleteSemanticElementTask = new DeleteDDiagramElementTask(semantic, this.modelAccessor);
                result.getTasks().add(deleteSemanticElementTask);
            }
            this.addRefreshTask(parentDiagram, result, (AbstractToolDescription)this.tool);
            cmd = new NoNullResourceCommand((Command)result, (EObject)this.diagramElement);
        }
        return cmd;
    }

    private Set<EObject> getSemanticElementsToDestroy(DDiagramElement currentDiagramElement) {
        HashSet elementsToDestroy = Sets.newHashSet();
        for (EObject semantic : currentDiagramElement.getSemanticElements()) {
            if (semantic == null) continue;
            elementsToDestroy.add(semantic);
            elementsToDestroy.addAll(this.getAllChildren(semantic));
        }
        for (EObject child : currentDiagramElement.eContents()) {
            if (!(child instanceof DDiagramElement)) continue;
            elementsToDestroy.addAll(this.getSemanticElementsToDestroy((DDiagramElement)child));
        }
        return elementsToDestroy;
    }

    private Set<EObject> getAllChildren(EObject semanticElement) {
        return Sets.newHashSet((Iterator)semanticElement.eAllContents());
    }

    private void addDeleteDiagramTask(DCommand cmd, DDiagram vp) {
        cmd.getTasks().add(new DeleteDRepresentationTask((DRepresentation)vp));
    }

    public void addDeleteDiagramTasks(DCommand cmd, DDiagram diagramToDelete) {
        if (this.permissionAuthority.canEditInstance((EObject)diagramToDelete) && this.permissionAuthority.canEditInstance(diagramToDelete.eContainer())) {
            this.addDeleteDiagramTask(cmd, diagramToDelete);
            TreeIterator it = diagramToDelete.eAllContents();
            while (it.hasNext()) {
                EObject eObj = (EObject)it.next();
                if (!(eObj instanceof DDiagram)) continue;
                this.addDeleteDiagramTask(cmd, (DDiagram)eObj);
            }
        } else {
            cmd.getTasks().add(UnexecutableTask.INSTANCE);
        }
    }

    public Set<DSemanticDecorator> getDElementToClearFromSemanticElements(EObject root, Set<EObject> semanticElements) {
        return this.taskHelper.getDElementToClearFromSemanticElements(root, semanticElements);
    }

    protected String getEnclosingCommandLabel() {
        String commandLabel = DELETE;
        if (this.diagram != null) {
            commandLabel = DELETE_DIAGRAM_LABEL;
        } else if (this.diagramElement != null) {
            commandLabel = this.deleteFromDiagram ? DELETE_FROM_DIAGRAM_LABEL : (this.tool == null ? DELETE_FROM_MODEL : new IdentifiedElementQuery((IdentifiedElement)this.tool).getLabel());
        }
        return commandLabel;
    }

    @Override
    protected Option<DDiagram> getDDiagram() {
        if (this.diagram == null && this.diagramElement != null) {
            return Options.newSome((Object)this.diagramElement.getParentDiagram());
        }
        return Options.newSome((Object)this.diagram);
    }
}

