/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ecore.design.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.ecore.design.service.EAttributeServices;
import org.eclipse.sirius.ecore.design.service.EOperationServices;
import org.eclipse.sirius.ecore.design.service.EReferenceServices;
import org.eclipse.sirius.ext.emf.AllContents;

public class EcoreService {
    public Collection<EObject> allRoots(EObject any) {
        Resource res = any.eResource();
        if (res != null && res.getResourceSet() != null) {
            ArrayList<EObject> roots = new ArrayList<EObject>();
            for (Resource childRes : res.getResourceSet().getResources()) {
                roots.addAll((Collection<EObject>)childRes.getContents());
            }
            return roots;
        }
        return Collections.emptySet();
    }

    public String eResourceName(EObject current) {
        if (current != null && current.eResource() != null) {
            return current.eResource().getURI().lastSegment();
        }
        return null;
    }

    public String render(EAttribute attr) {
        return new EAttributeServices().render(attr);
    }

    public EAttribute performEdit(EAttribute attr, String editString) {
        return new EAttributeServices().performEdit(attr, editString);
    }

    public String render(EOperation op) {
        return new EOperationServices().render(op);
    }

    public String renderToolTip(EOperation op) {
        return new EOperationServices().renderTooltip(op);
    }

    public EOperation performEdit(EOperation op, String editString) {
        return new EOperationServices().performEdit(op, editString);
    }

    public List<ENamedElement> getAllAssociatedElements(EOperation op) {
        return new EOperationServices().getAllAssociatedElements(op);
    }

    public String renderTooltip(EClass klass) {
        return String.valueOf(((EPackage)klass.eContainer()).getName()) + "." + klass.getName();
    }

    public String render(EReference ref) {
        return new EReferenceServices().render(ref);
    }

    public EReference performEdit(EReference ref, String editString) {
        return new EReferenceServices().performEdit(ref, editString);
    }

    public EClassifier findTypeByName(EObject obj, String name) {
        EClassifier result = this.findTypeByName(this.allRoots(obj), name);
        if (result == null) {
            result = this.findTypeByNameFrom((EObject)EcorePackage.eINSTANCE, name);
        }
        return result;
    }

    public EObject getRootContainer(EObject eObject) {
        return EcoreUtil.getRootContainer((EObject)eObject);
    }

    private EClassifier findTypeByName(Iterable<EObject> roots, String name) {
        for (EObject root : roots) {
            EClassifier result = this.findTypeByNameFrom(root, name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private EClassifier findTypeByNameFrom(EObject root, String name) {
        if (root instanceof EClassifier && this.nameMatches((EClassifier)root, name)) {
            return (EClassifier)root;
        }
        for (EObject obj : AllContents.of((EObject)root)) {
            if (!(obj instanceof EClassifier) || !this.nameMatches((EClassifier)obj, name)) continue;
            return (EClassifier)obj;
        }
        return null;
    }

    private boolean nameMatches(EClassifier type, String name) {
        if (type != null && type.getName() != null && name != null) {
            return type.getName().trim().equalsIgnoreCase(name.trim());
        }
        return false;
    }
}

