/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderedShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DescriptionCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.TextEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.preferences.SiriusPreferencesKeys;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.tools.api.preferences.SiriusDiagramPreferencesKeys;
import org.eclipse.sirius.diagram.tools.internal.preferences.SiriusDiagramInternalPreferencesKeys;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramEdgeEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.preferences.SiriusDiagramUiPreferencesKeys;
import org.eclipse.sirius.diagram.ui.tools.internal.preferences.SiriusDiagramUiInternalPreferencesKeys;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;
import org.eclipse.sirius.tests.support.api.EclipseTestsSupportHelper;
import org.eclipse.sirius.tests.support.api.TestCaseCleaner;
import org.eclipse.sirius.tests.support.api.TestsUtil;
import org.eclipse.sirius.tests.swtbot.support.api.business.UIDiagramRepresentation;
import org.eclipse.sirius.tests.swtbot.support.api.business.UILocalSession;
import org.eclipse.sirius.tests.swtbot.support.api.business.UIPerspective;
import org.eclipse.sirius.tests.swtbot.support.api.business.UIProject;
import org.eclipse.sirius.tests.swtbot.support.api.business.UIResource;
import org.eclipse.sirius.tests.swtbot.support.api.condition.OperationRedoneCondition;
import org.eclipse.sirius.tests.swtbot.support.api.condition.OperationUndoneCondition;
import org.eclipse.sirius.tests.swtbot.support.api.editor.SWTBotSiriusDiagramEditor;
import org.eclipse.sirius.tests.swtbot.support.api.editor.SWTBotSiriusHelper;
import org.eclipse.sirius.tests.swtbot.support.api.editor.SWTBotVSMEditor;
import org.eclipse.sirius.tests.swtbot.support.api.editor.SWTBotVSMHelper;
import org.eclipse.sirius.tests.swtbot.support.api.perspective.DesignerPerspectives;
import org.eclipse.sirius.tests.swtbot.support.api.view.DesignerViews;
import org.eclipse.sirius.tests.swtbot.support.utils.SWTBotCommonHelper;
import org.eclipse.sirius.tests.swtbot.support.utils.SWTBotUtils;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.eclipse.gef.finder.SWTBotGefTestCase;
import org.eclipse.swtbot.eclipse.gef.finder.widgets.SWTBotGefEditPart;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.ClassUtils;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.utils.SWTUtils;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ErrorEditorPart;
import org.hamcrest.Matcher;
import org.junit.Assert;

public abstract class AbstractSiriusSwtBotGefTestCase
extends SWTBotGefTestCase {
    protected static final String MODELS_DIR = "Models";
    protected static final String TEMP_PROJECT_NAME = "DesignerTestProject";
    private static final String EN_US = "EN_US";
    private static final String SET_STYLE_TO_WORKSPACE_IMAGE = "Set style to workspace image";
    private static final String POINT = ".";
    private static final String EDIT_MENU_NAME = "Edit";
    private static boolean fFullScreen;
    protected UIPerspective designerPerspective;
    protected DesignerPerspectives designerPerspectives;
    protected DesignerViews designerViews;
    protected UIProject designerProject;
    protected UIResource sessionAirdResource;
    protected UILocalSession localSession;
    protected SWTBotSiriusDiagramEditor editor;
    protected LinkedHashMultimap<String, IStatus> errors;
    private boolean defaultEnableAnimatedZoom;
    private boolean defaultEnableAnimatedLayout;
    private final HashMap<String, Object> oldValueDiagramPreferences;
    private final HashMap<String, Object> oldValueDiagramUIPreferences;
    private final HashMap<String, Object> oldValueSiriusPreferences;
    private final HashMap<String, Object> oldValueSiriusUIPreferences;
    private final HashMap<String, Object> oldPlatformUIPreferences;
    private Thread.UncaughtExceptionHandler exceptionHandler;
    private ILogListener logListener;
    private boolean errorCatchActive;

    static {
        SWTBotPreferences.TIMEOUT = 10000L;
        fFullScreen = true;
    }

    public AbstractSiriusSwtBotGefTestCase() {
        this.designerPerspective = new UIPerspective((SWTWorkbenchBot)this.bot);
        this.designerPerspectives = new DesignerPerspectives((SWTWorkbenchBot)this.bot);
        this.designerViews = new DesignerViews((SWTWorkbenchBot)this.bot);
        this.oldValueDiagramPreferences = new HashMap();
        this.oldValueDiagramUIPreferences = new HashMap();
        this.oldValueSiriusPreferences = new HashMap();
        this.oldValueSiriusUIPreferences = new HashMap();
        this.oldPlatformUIPreferences = new HashMap();
    }

    protected void setUp() throws Exception {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                PlatformUI.getWorkbench().getWorkbenchWindows()[0].getShell().setFullScreen(fFullScreen);
            }
        });
        this.errors = LinkedHashMultimap.create();
        this.initErrorLoggers();
        System.out.println("Setup of " + ((Object)((Object)this)).getClass().getName() + POINT + this.getName() + "()");
        try {
            super.setUp();
            UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

                public void run() {
                    IPreferenceStore preferenceStore = DiagramUIPlugin.getPlugin().getPreferenceStore();
                    AbstractSiriusSwtBotGefTestCase.this.defaultEnableAnimatedZoom = preferenceStore.getBoolean("Global.enableAnimatedZoom");
                    preferenceStore.setValue("Global.enableAnimatedZoom", false);
                    AbstractSiriusSwtBotGefTestCase.this.defaultEnableAnimatedLayout = preferenceStore.getBoolean("Global.enableAnimatedLayout");
                    preferenceStore.setValue("Global.enableAnimatedLayout", false);
                    DefaultScope.INSTANCE.getNode("org.eclipse.sirius").putBoolean(SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), true);
                    InstanceScope.INSTANCE.getNode("org.eclipse.sirius").putBoolean(SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), AbstractSiriusSwtBotGefTestCase.this.getAutoRefreshMode());
                }
            });
            this.designerProject = this.designerPerspective.createProject(this.getProjectName());
            this.onSetUpBeforeClosingWelcomePage();
            this.closeWelcomePage();
            this.designerPerspectives.openModelingPerspective();
            this.onSetUpAfterOpeningDesignerPerspective();
        }
        catch (Throwable e) {
            this.takeScreenshot("-after-setup");
            try {
                this.failureTearDown();
            }
            catch (Exception exception) {}
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw new RuntimeException(e);
        }
    }

    protected boolean getAutoRefreshMode() {
        return false;
    }

    protected String getProjectName() {
        return TEMP_PROJECT_NAME;
    }

    protected void onSetUpBeforeClosingWelcomePage() throws Exception {
    }

    protected void onSetUpAfterOpeningDesignerPerspective() throws Exception {
    }

    protected void closeAllEditors() {
        this.bot.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < PlatformUI.getWorkbench().getWorkbenchWindows().length) {
                    int j = 0;
                    while (j < PlatformUI.getWorkbench().getWorkbenchWindows()[i].getPages().length) {
                        PlatformUI.getWorkbench().getWorkbenchWindows()[i].getPages()[j].closeAllEditors(false);
                        ++j;
                    }
                    ++i;
                }
            }
        });
        SWTBotUtils.waitAllUiEvents();
    }

    private void closeAllSessions() {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                for (Session sess : Sets.newLinkedHashSet((Iterable)SessionManager.INSTANCE.getSessions())) {
                    if (!sess.isOpen()) continue;
                    sess.save((IProgressMonitor)new NullProgressMonitor());
                    try {
                        Job.getJobManager().join((Object)"org.eclipse.sirius.common.ResourceSyncClientNotification", (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (OperationCanceledException e) {
                        TestCase.fail((String)e.getLocalizedMessage());
                    }
                    catch (InterruptedException e) {
                        TestCase.fail((String)e.getLocalizedMessage());
                    }
                    sess.close((IProgressMonitor)new NullProgressMonitor());
                }
            }
        });
    }

    protected void closeWelcomePage() {
        Matcher matcher = WidgetMatcherFactory.withPartName((String)"Welcome");
        List views = this.bot.views(matcher);
        for (SWTBotView swtBotView : views) {
            swtBotView.close();
        }
    }

    protected void manualRefresh() {
        if (TestsUtil.isDynamicTabbar()) {
            this.bot.toolbarButtonWithTooltip("Refresh diagram").click();
        } else {
            new SWTBotSiriusDiagramEditor((IEditorReference)this.bot.activeEditor().getReference(), (SWTWorkbenchBot)this.bot).clickContextMenu("Refresh");
        }
        SWTBotUtils.waitProgressMonitorClose("Progress Information");
    }

    protected void runTest() throws Throwable {
        try {
            super.runTest();
        }
        catch (Throwable running) {
            this.takeScreenshot("-before-tearDown");
            throw running;
        }
    }

    public void takeScreenshot(CharSequence suffix) {
        String fileName = "screenshots/screenshot-" + ClassUtils.simpleClassName(((Object)((Object)this)).getClass()) + POINT + this.getName() + suffix + POINT + SWTBotPreferences.SCREENSHOT_FORMAT.toLowerCase();
        new File("screenshots").mkdirs();
        SWTUtils.captureScreenshot((String)fileName);
    }

    protected void openErrorLogViewByAPI() {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.pde.runtime.LogView");
                }
                catch (PartInitException e) {
                    TestCase.fail((String)("Unable to open errorLog view : " + e.getMessage()));
                }
            }
        });
    }

    public int getNbStatusInErrorLog() {
        this.openErrorLogViewByAPI();
        SWTBotView logViewBot = this.bot.viewByTitle("Error Log");
        logViewBot.show();
        SWTBotTree tree = logViewBot.bot().tree();
        int nbStatus = tree.getAllItems().length;
        logViewBot.close();
        return nbStatus;
    }

    protected void assertEditorIsNotError(String message, SWTBotEditor activeEditor) {
        IEditorPart editorPart = ((IEditorReference)activeEditor.getReference()).getEditor(false);
        boolean isError = editorPart instanceof ErrorEditorPart;
        if (isError) {
            activeEditor.close();
        }
        TestCase.assertFalse((String)message, (boolean)isError);
    }

    protected void undo() {
        Assert.assertTrue((this.editor != null ? 1 : 0) != 0);
        OperationUndoneCondition condition = new OperationUndoneCondition();
        this.bot.activeEditor();
        String savedKeyboardLayout = SWTBotPreferences.KEYBOARD_LAYOUT;
        SWTBotPreferences.KEYBOARD_LAYOUT = EN_US;
        this.editor.getCanvas().pressShortcut(262144, 'z');
        SWTBotPreferences.KEYBOARD_LAYOUT = savedKeyboardLayout;
        this.bot.waitUntil((ICondition)condition);
    }

    protected void undo(Session session) {
        session.getTransactionalEditingDomain().getCommandStack().undo();
    }

    protected void undo(String cmdName) {
        this.bot.menu(EDIT_MENU_NAME).menu("Undo " + cmdName).click();
    }

    protected void redo() {
        Assert.assertTrue((this.editor != null ? 1 : 0) != 0);
        OperationRedoneCondition condition = new OperationRedoneCondition();
        this.bot.activeEditor();
        String savedKeyboardLayout = SWTBotPreferences.KEYBOARD_LAYOUT;
        SWTBotPreferences.KEYBOARD_LAYOUT = EN_US;
        if (System.getProperty("os.name").equals("Linux") && (TestsUtil.isJuno3Platform() || TestsUtil.isEclipse4xPlatform())) {
            this.editor.getCanvas().pressShortcut(393216, 'z');
        } else {
            this.editor.getCanvas().pressShortcut(262144, 'y');
        }
        SWTBotPreferences.KEYBOARD_LAYOUT = savedKeyboardLayout;
        this.bot.waitUntil((ICondition)condition);
    }

    protected void redo(String cmdName) {
        this.bot.menu(EDIT_MENU_NAME).menu("Redo " + cmdName).click();
    }

    protected void redo(Session session) {
        session.getTransactionalEditingDomain().getCommandStack().redo();
    }

    protected void launchCancelCustomStyle() {
        this.bot.buttonWithTooltip("Cancel custom style").click();
    }

    protected void changeDiagramPreference(String preferenceKey, Boolean newValue) {
        this.assertNoDiagramUIPreferenceChangedinDiagramCoreStore(preferenceKey);
        boolean oldValue = Platform.getPreferencesService().getBoolean("org.eclipse.sirius.diagram", preferenceKey, false, null);
        this.oldValueDiagramPreferences.put(preferenceKey, oldValue);
        IEclipsePreferences diagramCorePreferences = InstanceScope.INSTANCE.getNode("org.eclipse.sirius.diagram");
        diagramCorePreferences.putBoolean(preferenceKey, newValue.booleanValue());
        boolean valueToCheck = Platform.getPreferencesService().getBoolean("org.eclipse.sirius.diagram", preferenceKey, false, null);
        TestCase.assertEquals((String)this.getErrorMessage(preferenceKey, "org.eclipse.sirius.diagram"), (boolean)newValue, (boolean)valueToCheck);
    }

    protected void resetDiagramPreference(String preferenceKey) {
        IEclipsePreferences diagramCorePreferences = InstanceScope.INSTANCE.getNode("org.eclipse.sirius.diagram");
        this.resetDiagramPreference(preferenceKey, diagramCorePreferences);
    }

    private void resetDiagramPreference(String preferenceKey, IEclipsePreferences diagramCorePreferences) {
        Object initialValue = this.oldValueDiagramPreferences.get(preferenceKey);
        if (initialValue instanceof Boolean) {
            diagramCorePreferences.putBoolean(preferenceKey, ((Boolean)initialValue).booleanValue());
        } else if (initialValue instanceof Integer) {
            diagramCorePreferences.putInt(preferenceKey, ((Integer)initialValue).intValue());
        }
    }

    protected void changeDiagramUIPreference(final String preferenceKey, final Boolean newValue) {
        this.assertNoDiagramCorePreferenceChangedinDiagramUIStore(preferenceKey);
        final IPreferenceStore prefs = DiagramUIPlugin.getPlugin().getPreferenceStore();
        this.oldValueDiagramUIPreferences.put(preferenceKey, prefs.getBoolean(preferenceKey));
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                prefs.setValue(preferenceKey, newValue.booleanValue());
            }
        });
    }

    protected void resetDiagramUIPreference(String preferenceKey) {
        IPreferenceStore diagramUIPreferences = DiagramUIPlugin.getPlugin().getPreferenceStore();
        this.resetDiagramUIPreference(preferenceKey, diagramUIPreferences);
    }

    private void resetDiagramUIPreference(String preferenceKey, IPreferenceStore diagramUIPreferences) {
        Object initialValue = this.oldValueDiagramUIPreferences.get(preferenceKey);
        if (initialValue instanceof Boolean) {
            diagramUIPreferences.setValue(preferenceKey, ((Boolean)initialValue).booleanValue());
        } else if (initialValue instanceof Integer) {
            diagramUIPreferences.setValue(preferenceKey, ((Integer)initialValue).intValue());
        }
    }

    protected void changeSiriusPreference(String preferenceKey, Boolean newValue) {
        boolean oldValue = Platform.getPreferencesService().getBoolean("org.eclipse.sirius", preferenceKey, false, null);
        this.oldValueSiriusPreferences.put(preferenceKey, oldValue);
        IEclipsePreferences corePreferences = InstanceScope.INSTANCE.getNode("org.eclipse.sirius");
        corePreferences.putBoolean(preferenceKey, newValue.booleanValue());
        boolean valueToCheck = Platform.getPreferencesService().getBoolean("org.eclipse.sirius", preferenceKey, false, null);
        TestCase.assertEquals((String)this.getErrorMessage(preferenceKey, "org.eclipse.sirius"), (boolean)newValue, (boolean)valueToCheck);
    }

    protected void changeSiriusUIPreference(String preferenceKey, Boolean newValue) {
        this.assertNoSiriusCorePreferenceChangedinSiriusUIStore(preferenceKey);
        IPreferenceStore viewpointUIPrefs = SiriusEditPlugin.getPlugin().getPreferenceStore();
        this.oldValueSiriusUIPreferences.put(preferenceKey, viewpointUIPrefs.getBoolean(preferenceKey));
        viewpointUIPrefs.setValue(preferenceKey, newValue.booleanValue());
    }

    protected void changePlatformUIPreference(String preferenceKey, Boolean newValue) {
        IPreferenceStore viewpointUIPrefs = PlatformUI.getPreferenceStore();
        this.oldPlatformUIPreferences.put(preferenceKey, viewpointUIPrefs.getBoolean(preferenceKey));
        viewpointUIPrefs.setValue(preferenceKey, newValue.booleanValue());
    }

    private void assertNoSiriusCorePreferenceChangedinSiriusUIStore(String preferenceKey) {
        ArrayList coreKeys = Lists.newArrayList((Object[])SiriusPreferencesKeys.values());
        Function<SiriusPreferencesKeys, String> prefToName = new Function<SiriusPreferencesKeys, String>(){

            public String apply(SiriusPreferencesKeys input) {
                return input.name();
            }
        };
        TestCase.assertFalse((String)("The DesignerPreferenceKey named " + preferenceKey + " should not be modified in the UI store."), (boolean)Lists.newArrayList((Iterable)Iterables.transform((Iterable)coreKeys, (Function)prefToName)).contains(preferenceKey));
    }

    private void assertNoDiagramCorePreferenceChangedinDiagramUIStore(String preferenceKey) {
        SiriusDiagramInternalPreferencesKeys key;
        ArrayList coreKeys = Lists.newArrayList();
        SiriusDiagramInternalPreferencesKeys[] siriusDiagramInternalPreferencesKeysArray = SiriusDiagramInternalPreferencesKeys.values();
        int n = siriusDiagramInternalPreferencesKeysArray.length;
        int n2 = 0;
        while (n2 < n) {
            key = siriusDiagramInternalPreferencesKeysArray[n2];
            coreKeys.add(key.name());
            ++n2;
        }
        siriusDiagramInternalPreferencesKeysArray = SiriusDiagramPreferencesKeys.values();
        n = siriusDiagramInternalPreferencesKeysArray.length;
        n2 = 0;
        while (n2 < n) {
            key = siriusDiagramInternalPreferencesKeysArray[n2];
            coreKeys.add(key.name());
            ++n2;
        }
        coreKeys.add("Viewpoint.Connectors.enableOverride");
        coreKeys.add("Viewpoint.Connectors.lineStyle");
        AbstractSiriusSwtBotGefTestCase.assertFalse((String)("The Diagram core preference named " + preferenceKey + " should not be modified in the Diagram UI store."), (boolean)coreKeys.contains(preferenceKey));
    }

    private void assertNoDiagramUIPreferenceChangedinDiagramCoreStore(String preferenceKey) {
        SiriusDiagramUiInternalPreferencesKeys key;
        ArrayList uiKeys = Lists.newArrayList();
        SiriusDiagramUiInternalPreferencesKeys[] siriusDiagramUiInternalPreferencesKeysArray = SiriusDiagramUiInternalPreferencesKeys.values();
        int n = siriusDiagramUiInternalPreferencesKeysArray.length;
        int n2 = 0;
        while (n2 < n) {
            key = siriusDiagramUiInternalPreferencesKeysArray[n2];
            uiKeys.add(key.name());
            ++n2;
        }
        siriusDiagramUiInternalPreferencesKeysArray = SiriusDiagramUiPreferencesKeys.values();
        n = siriusDiagramUiInternalPreferencesKeysArray.length;
        n2 = 0;
        while (n2 < n) {
            key = siriusDiagramUiInternalPreferencesKeysArray[n2];
            uiKeys.add(key.name());
            ++n2;
        }
        AbstractSiriusSwtBotGefTestCase.assertFalse((String)("The Diagram UI preference named " + preferenceKey + " should not be modified in the Diagram core store."), (boolean)uiKeys.contains(preferenceKey));
    }

    private String getErrorMessage(String preferenceKey, String pluginId) {
        return "The " + preferenceKey + " preference value was not changed for plugin " + pluginId;
    }

    protected void deleteSelectedElement() {
        SWTBotMenu deleteMenu = this.checkDeleteMenuEnablement(true);
        deleteMenu.click();
    }

    protected void deleteFromDiagram() {
        String savedKeyboardLayout = SWTBotPreferences.KEYBOARD_LAYOUT;
        SWTBotPreferences.KEYBOARD_LAYOUT = EN_US;
        this.editor.getCanvas().pressShortcut(393216, 'd');
        SWTBotPreferences.KEYBOARD_LAYOUT = savedKeyboardLayout;
        SWTBotUtils.waitAllUiEvents();
    }

    protected SWTBotMenu checkDeleteMenuEnablement(boolean expected) {
        SWTBotMenu deleteMenu = this.bot.menu(EDIT_MENU_NAME).menu("Delete");
        String errorMessage = expected ? "Delete menu should be enabled" : "Delete menu was not enabled";
        TestCase.assertEquals((String)errorMessage, (boolean)expected, (boolean)deleteMenu.isEnabled());
        return deleteMenu;
    }

    protected void maximizeEditor() {
        this.bot.menu("Window").menu("Navigation").menu("Maximize Active View or Editor").click();
    }

    protected void maximizeEditor(SWTBotSiriusDiagramEditor swtBotDesignerEditor) {
        swtBotDesignerEditor.maximize();
    }

    protected void pressZoomInButton(SWTBotSiriusDiagramEditor swtBotDesignerEditor) {
        this.pressZoomInButton(swtBotDesignerEditor, 1);
    }

    protected void pressZoomInButton(SWTBotSiriusDiagramEditor swtBotDesignerEditor, int pressCount) {
        int i = 1;
        while (i <= pressCount) {
            if (TestsUtil.isDynamicTabbar()) {
                try {
                    swtBotDesignerEditor.bot().toolbarButtonWithTooltip("Zoom In (Ctrl++)").click();
                }
                catch (WidgetNotFoundException widgetNotFoundException) {
                    swtBotDesignerEditor.bot().toolbarButtonWithTooltip("Zoom In (Ctrl+=)").click();
                }
            } else {
                double currentZoom = GraphicalHelper.getZoom((IGraphicalEditPart)((IGraphicalEditPart)((DiagramRootEditPart)swtBotDesignerEditor.rootEditPart().part()).getContents()));
                swtBotDesignerEditor.zoom(UIDiagramRepresentation.ZoomLevel.createNextZoomInLevel(currentZoom));
            }
            ++i;
        }
    }

    protected void pressZoomOutButton(SWTBotSiriusDiagramEditor swtBotDesignerEditor) {
        this.pressZoomOutButton(swtBotDesignerEditor, 1);
    }

    protected void pressZoomOutButton(SWTBotSiriusDiagramEditor swtBotDesignerEditor, int pressCount) {
        int i = 1;
        while (i <= pressCount) {
            if (TestsUtil.isDynamicTabbar()) {
                swtBotDesignerEditor.bot().toolbarButtonWithTooltip("Zoom Out (Ctrl+-)").click();
            } else {
                double currentZoom = GraphicalHelper.getZoom((IGraphicalEditPart)((IGraphicalEditPart)((DiagramRootEditPart)swtBotDesignerEditor.rootEditPart().part()).getContents()));
                swtBotDesignerEditor.zoom(UIDiagramRepresentation.ZoomLevel.createNextZoomOutLevel(currentZoom));
            }
            ++i;
        }
    }

    protected void restoreEditor(SWTBotSiriusDiagramEditor swtBotDesignerEditor) {
        swtBotDesignerEditor.restore();
    }

    protected SWTBotMenu arrangeAll() {
        this.editor.setFocus();
        this.editor.select(new SWTBotGefEditPart[]{this.editor.mainEditPart()});
        SWTBotMenu arrangeAllMenutBot = this.bot.menu("Diagram").menu("Arrange").menu("All").click();
        SWTBotUtils.waitAllUiEvents();
        return arrangeAllMenutBot;
    }

    protected Collection<DRepresentation> getRepresentations(Session session, String representationDescriptionName) {
        Collection allRepresentations = DialectManager.INSTANCE.getAllRepresentations(session);
        HashSet<DRepresentation> representations = new HashSet<DRepresentation>();
        for (DRepresentation representation : allRepresentations) {
            RepresentationDescription desc = DialectManager.INSTANCE.getDescription(representation);
            if (desc == null || !representationDescriptionName.equals(desc.getName())) continue;
            representations.add(representation);
        }
        return representations;
    }

    protected final DRepresentation getRepresentationWithName(Session session, String representationDescriptionName, final String representationName) {
        try {
            DRepresentation existingRepresentation = (DRepresentation)Iterables.find(this.getRepresentations(session, representationDescriptionName), (Predicate)new Predicate<DRepresentation>(){

                public boolean apply(DRepresentation input) {
                    return input.getName().equals(representationName);
                }
            });
            return existingRepresentation;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NoSuchElementException("No representation found in session with \"" + representationName + "\" as representation name and with \"" + representationDescriptionName + "\" as representation description name.");
        }
    }

    @Deprecated
    protected SWTBotSiriusDiagramEditor openDiagram(Session session, String diagramDescriptionName, String diagramName, Class<? extends DRepresentation> expectedRepresentationClass) {
        return this.openDiagram(session, diagramDescriptionName, diagramName, expectedRepresentationClass, false);
    }

    @Deprecated
    protected SWTBotSiriusDiagramEditor openDiagram(Session session, String diagramDescriptionName, String diagramName, Class<? extends DRepresentation> expectedRepresentationClass, boolean disableSnapToGridOnThisEditor) {
        AbstractSiriusSwtBotGefTestCase.assertTrue((String)"This method is only able to deal with diagrams.", (boolean)DiagramPackage.Literals.DDIAGRAM.getInstanceClass().isAssignableFrom(expectedRepresentationClass));
        SWTBotEditor diagramEditor = this.openRepresentation(session, diagramDescriptionName, diagramName, expectedRepresentationClass, disableSnapToGridOnThisEditor);
        AbstractSiriusSwtBotGefTestCase.assertTrue((boolean)(diagramEditor instanceof SWTBotSiriusDiagramEditor));
        return (SWTBotSiriusDiagramEditor)diagramEditor;
    }

    protected SWTBotEditor openRepresentation(Session session, String representationDescriptionName, String representationName, Class<? extends DRepresentation> expectedRepresentationClass) {
        return this.openRepresentation(session, representationDescriptionName, representationName, expectedRepresentationClass, false);
    }

    protected SWTBotEditor openRepresentation(Session session, String representationDescriptionName, String representationName, Class<? extends DRepresentation> expectedRepresentationClass, boolean disableSnapToGridOnThisEditor) {
        DRepresentation representation = this.getRepresentationWithName(session, representationDescriptionName, representationName);
        TestCase.assertTrue((String)("This representation should be a " + expectedRepresentationClass.getSimpleName()), (boolean)expectedRepresentationClass.isInstance(representation));
        IEditorPart editorPart = DialectUIManager.INSTANCE.openEditor(session, representation, (IProgressMonitor)new NullProgressMonitor());
        SWTBotUtils.waitAllUiEvents();
        SWTBotSiriusDiagramEditor swtBotEditor = null;
        if (DDiagram.class.isAssignableFrom(expectedRepresentationClass)) {
            swtBotEditor = SWTBotSiriusHelper.getSiriusDiagramEditor(editorPart.getTitle());
            if (disableSnapToGridOnThisEditor) {
                swtBotEditor.disableSnapToGrid();
            }
        } else {
            swtBotEditor = SWTBotSiriusHelper.getSiriusEditor(editorPart.getTitle());
        }
        return swtBotEditor;
    }

    protected AbstractSWTBot<? extends Widget> getSetStyleToWorkspaceImageButton(boolean tabbar, boolean enabled) {
        Object wkpImageButton = null;
        wkpImageButton = tabbar ? this.getSetStyleToWorkspaceImageButtonFromTabbar() : this.getSetStyleToWorkspaceImageButtonFromAppearanceTab();
        TestCase.assertNotNull((String)("Can't find the SetStyleToWorkspaceImage button in the " + (tabbar ? "tabbar" : "Appearance tab")), (Object)wkpImageButton);
        TestCase.assertEquals((String)("The SetStyleToWorkspaceImage button should be " + (enabled ? "enabled" : "disabled")), (boolean)enabled, (boolean)wkpImageButton.isEnabled());
        return wkpImageButton;
    }

    protected AbstractSWTBot<? extends Widget> getResetStylePropertiesToDefaultValuesButton(boolean tabbar, boolean enabled) {
        Object resetStylePropertiesToDefaultValuesButton = null;
        resetStylePropertiesToDefaultValuesButton = !tabbar ? this.getResetStylePropertiesToDefaultValuesButtonFromAppearanceTab() : this.getResetStylePropertiesToDefaultValuesButtonFromTabbar();
        TestCase.assertNotNull((String)("Can't find the \"Reset style properties to default values\" button in the " + (tabbar ? "tabbar" : "Appearance tab")), (Object)resetStylePropertiesToDefaultValuesButton);
        TestCase.assertEquals((String)("The \"Reset style properties to default values\" button should be " + (enabled ? "enabled" : "disabled")), (boolean)enabled, (boolean)resetStylePropertiesToDefaultValuesButton.isEnabled());
        return resetStylePropertiesToDefaultValuesButton;
    }

    private SWTBotToolbarButton getSetStyleToWorkspaceImageButtonFromTabbar() {
        return this.getTabbarButton(SET_STYLE_TO_WORKSPACE_IMAGE);
    }

    protected SWTBotToolbarButton getResetStylePropertiesToDefaultValuesButtonFromTabbar() {
        return this.getTabbarButton("Reset style properties to default values");
    }

    private SWTBotButton getSetStyleToWorkspaceImageButtonFromAppearanceTab() {
        return this.getSectionButton(3, SET_STYLE_TO_WORKSPACE_IMAGE);
    }

    protected void click(AbstractSWTBot<? extends Widget> button) {
        if (button instanceof SWTBotToolbarButton) {
            ((SWTBotToolbarButton)button).click();
        } else if (button instanceof SWTBotButton) {
            ((SWTBotButton)button).click();
        }
    }

    protected SWTBotButton getResetStylePropertiesToDefaultValuesButtonFromAppearanceTab() {
        IStructuredSelection structuredSelection;
        SWTBotButton resetStylePropertiesToDefaultValuesButtonFromAppearanceTab = null;
        int buttonIndex = 4;
        this.editor.show();
        this.editor.setFocus();
        ISelection selection = this.editor.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).getFirstElement() instanceof AbstractDiagramEdgeEditPart) {
            buttonIndex = 3;
        }
        resetStylePropertiesToDefaultValuesButtonFromAppearanceTab = this.getSectionButton(buttonIndex, "Reset style properties to default values");
        return resetStylePropertiesToDefaultValuesButtonFromAppearanceTab;
    }

    protected SWTBotButton getSectionButton(int index, String tooltip) {
        SWTBot propertiesBot = this.bot.viewByTitle("Properties").bot();
        this.bot.viewByTitle("Properties").setFocus();
        SWTBotSiriusHelper.selectPropertyTabItem("Appearance");
        SWTBotButton button = propertiesBot.buttonInGroup("Fonts and Colors:", index);
        TestCase.assertNotNull((Object)button);
        TestCase.assertEquals((String)tooltip, (String)button.getToolTipText());
        return button;
    }

    private SWTBotToolbarButton getTabbarButton(String tooltip) {
        this.editor.show();
        SWTBot tabbarBot = this.editor.bot();
        SWTBotToolbarButton button = tabbarBot.toolbarButtonWithTooltip(tooltip);
        TestCase.assertNotNull((String)("No button found with tooltip \"" + tooltip + "\""), (Object)button);
        return button;
    }

    private void initErrorLoggers() {
        this.logListener = new ILogListener(){

            public void logging(IStatus status, String plugin) {
                if (status.getSeverity() == 4 && !"org.eclipse.ui.views.properties.tabbed".equals(status.getPlugin()) && status.getMessage() != null && !status.getMessage().startsWith("Contributor org.eclipse.ui.navigator.ProjectExplorer cannot be created., exception: org.eclipse.core.runtime.CoreException: Plug-in \"org.eclipse.ui.navigator.resources\" was unable to instantiate class \"org.eclipse.ui.internal.navigator.resources.workbench.TabbedPropertySheetTitleProvider\".")) {
                    AbstractSiriusSwtBotGefTestCase.this.errorOccurs(status, plugin);
                }
            }
        };
        Platform.addLogListener((ILogListener)this.logListener);
        this.exceptionHandler = new Thread.UncaughtExceptionHandler(){
            private final String sourcePlugin = "Uncaught exception";

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                Status status = new Status(4, "Uncaught exception", "Uncaught exception", e);
                AbstractSiriusSwtBotGefTestCase.this.errorOccurs((IStatus)status, "Uncaught exception");
            }
        };
        Thread.setDefaultUncaughtExceptionHandler(this.exceptionHandler);
        this.setErrorCatchActive(true);
    }

    private void disposeErrorLoggers() {
        if (this.logListener != null) {
            Platform.removeLogListener((ILogListener)this.logListener);
        }
    }

    protected synchronized boolean doesAnErrorOccurs() {
        if (this.errors != null) {
            return this.errors.values().size() != 0;
        }
        return false;
    }

    protected synchronized boolean isErrorCatchActive() {
        return this.errorCatchActive;
    }

    private synchronized void errorOccurs(IStatus status, String sourcePlugin) {
        if (this.errorCatchActive) {
            this.errors.put((Object)sourcePlugin, (Object)status);
        }
    }

    protected synchronized void setErrorCatchActive(boolean errorCatchActive) {
        this.errorCatchActive = errorCatchActive;
    }

    private void checkErrors() {
        if (!TestsUtil.shouldSkipUnreliableTests() && this.doesAnErrorOccurs()) {
            Assert.fail((String)this.getErrorLoggersMessage());
        }
    }

    protected synchronized String getErrorLoggersMessage() {
        StringBuilder log1 = new StringBuilder();
        String br = "\n";
        String testName = ((Object)((Object)this)).getClass().getName();
        log1.append("Error(s) raised during test : " + testName).append(br);
        for (Map.Entry entry : this.errors.asMap().entrySet()) {
            String reporter = (String)entry.getKey();
            log1.append(". Log Plugin : " + reporter).append(br);
            for (IStatus status : (Collection)entry.getValue()) {
                log1.append("  . " + this.getSeverity(status) + " from plugin:" + status.getPlugin() + ", message: " + status.getMessage() + ", exception: " + status.getException()).append(br);
                this.appendStackTrace(log1, br, status);
            }
            log1.append(br);
        }
        return log1.toString();
    }

    private void appendStackTrace(StringBuilder log1, String br, IStatus status) {
        PrintWriter pw = null;
        String stacktrace = null;
        if (status.getException() != null) {
            try {
                StringWriter sw = new StringWriter();
                pw = new PrintWriter(sw);
                status.getException().printStackTrace(pw);
                stacktrace = sw.toString();
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
                if (stacktrace == null) {
                    stacktrace = status.getException().toString();
                }
                log1.append("   . Stack trace: " + stacktrace).append(br);
            }
        }
    }

    private String getSeverity(IStatus status) {
        String severity;
        switch (status.getSeverity()) {
            case 0: {
                severity = "Ok";
                break;
            }
            case 1: {
                severity = "Info";
                break;
            }
            case 2: {
                severity = "Warning";
                break;
            }
            case 8: {
                severity = "Cancel";
                break;
            }
            case 4: {
                severity = "Error";
                break;
            }
            default: {
                severity = "Unspecified";
            }
        }
        return severity;
    }

    private void failureTearDown() throws Exception {
        try {
            SWTBotUtils.waitAllUiEvents();
            if (this.bot != null) {
                SWTBotShell[] foundShells;
                Shell[] shells = this.bot.getFinder().getShells();
                ArrayList<SWTBotShell> result = new ArrayList<SWTBotShell>();
                Shell[] shellArray = shells;
                int n = shells.length;
                int n2 = 0;
                while (n2 < n) {
                    Shell shell = shellArray[n2];
                    if (!shell.isDisposed()) {
                        result.add(new SWTBotShell(shell));
                    }
                    ++n2;
                }
                SWTBotShell[] sWTBotShellArray = foundShells = result.toArray(new SWTBotShell[0]);
                int n3 = foundShells.length;
                n = 0;
                while (n < n3) {
                    SWTBotShell swtBotShell = sWTBotShellArray[n];
                    if (swtBotShell.isOpen()) {
                        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
                        int n4 = iWorkbenchWindowArray.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            IWorkbenchWindow w = iWorkbenchWindowArray[n5];
                            if (swtBotShell.widget != w.getShell()) {
                                swtBotShell.close();
                            }
                            ++n5;
                        }
                    }
                    ++n;
                }
            }
            SWTBotUtils.waitAllUiEvents();
            this.closeAllEditors();
            SWTBotUtils.waitAllUiEvents();
            this.closeAllSessions();
            SWTBotUtils.waitAllUiEvents();
            Job.getJobManager().join((Object)"org.eclipse.sirius.common.ResourceSyncClientNotification", (IProgressMonitor)new NullProgressMonitor());
            this.bot.closeAllEditors();
            this.designerProject = null;
            SWTBotUtils.waitAllUiEvents();
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n6 = 0;
            while (n6 < n) {
                IProject project = iProjectArray[n6];
                this.designerPerspective.deleteProject(project.getName());
                ++n6;
            }
            this.disposeErrorLoggers();
        }
        catch (Throwable throwable) {
            this.resetPreferences();
            SWTBotUtils.waitAllUiEvents();
            UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

                public void run() {
                    IPreferenceStore preferenceStore = DiagramUIPlugin.getPlugin().getPreferenceStore();
                    preferenceStore.setValue("Global.enableAnimatedZoom", AbstractSiriusSwtBotGefTestCase.this.defaultEnableAnimatedZoom);
                    preferenceStore.setValue("Global.enableAnimatedLayout", AbstractSiriusSwtBotGefTestCase.this.defaultEnableAnimatedLayout);
                }
            });
            this.setErrorCatchActive(false);
            this.checkErrors();
            throw throwable;
        }
        this.resetPreferences();
        SWTBotUtils.waitAllUiEvents();
        UIThreadRunnable.syncExec((VoidResult)new /* invalid duplicate definition of identical inner class */);
        this.setErrorCatchActive(false);
        this.checkErrors();
    }

    private void resetPreferences() {
        IEclipsePreferences diagamCorePreferences = InstanceScope.INSTANCE.getNode("org.eclipse.sirius.diagram");
        for (String key : this.oldValueDiagramPreferences.keySet()) {
            this.resetDiagramPreference(key, diagamCorePreferences);
        }
        IPreferenceStore diagramUIPreferences = DiagramUIPlugin.getPlugin().getPreferenceStore();
        for (String key : this.oldValueDiagramUIPreferences.keySet()) {
            this.resetDiagramUIPreference(key, diagramUIPreferences);
        }
        boolean currentUiPreference = diagramUIPreferences.getBoolean(SiriusDiagramUiPreferencesKeys.PREF_OLD_UI.name());
        if (currentUiPreference) {
            System.out.println("This test has not reset the oldUiPreference : " + ((Object)((Object)this)).getClass().getName() + " (it is currently true).");
        }
        IPreferenceStore platformPrefs = PlatformUI.getPreferenceStore();
        for (String key : this.oldPlatformUIPreferences.keySet()) {
            platformPrefs.setValue(key, ((Boolean)this.oldPlatformUIPreferences.get(key)).booleanValue());
        }
        IPreferenceStore viewpointUIPrefs = SiriusEditPlugin.getPlugin().getPreferenceStore();
        for (String key : this.oldValueSiriusUIPreferences.keySet()) {
            viewpointUIPrefs.setValue(key, ((Boolean)this.oldValueSiriusUIPreferences.get(key)).booleanValue());
        }
        IEclipsePreferences corePreferences = InstanceScope.INSTANCE.getNode("org.eclipse.sirius");
        for (String key : this.oldValueSiriusPreferences.keySet()) {
            corePreferences.putBoolean(key, ((Boolean)this.oldValueSiriusPreferences.get(key)).booleanValue());
        }
    }

    public SWTBotVSMEditor openViewpointSpecificationModel(String viewpointSpecificationModel) {
        SWTBotCommonHelper.openEditor(this.getProjectName(), viewpointSpecificationModel);
        SWTBotVSMEditor odesignEditor = SWTBotVSMHelper.getVSMEditorContainingName(viewpointSpecificationModel);
        odesignEditor.setFocus();
        return odesignEditor;
    }

    protected void copyFileToTestProject(String pluginId, String dataUnitDir, String ... fileNames) {
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            EclipseTestsSupportHelper.INSTANCE.copyFile(pluginId, String.valueOf(dataUnitDir) + fileName, String.valueOf(this.getProjectName()) + "/" + fileName);
            ++n2;
        }
    }

    public SWTBotGefEditPart findTextEditPart(String label) {
        return this.findTextEditPart(this.editor.rootEditPart(), label);
    }

    public SWTBotGefEditPart findTextEditPart(SWTBotSiriusDiagramEditor designerEditor, String label) {
        return this.findTextEditPart(designerEditor.rootEditPart(), label);
    }

    public SWTBotGefEditPart findTextEditPart(SWTBotGefEditPart parent, String label) {
        SWTBotGefEditPart result = null;
        if (parent.part() instanceof TextEditPart) {
            TextEditPart textEditPart = (TextEditPart)parent.part();
            DescriptionCompartmentEditPart descriptionCompartmentEditPart = (DescriptionCompartmentEditPart)Iterables.getOnlyElement((Iterable)Iterables.filter((Iterable)textEditPart.getChildren(), DescriptionCompartmentEditPart.class));
            if (descriptionCompartmentEditPart.getFigure() instanceof WrappingLabel && label.equals(((WrappingLabel)descriptionCompartmentEditPart.getFigure()).getText())) {
                result = parent;
            }
        } else {
            for (SWTBotGefEditPart child : parent.children()) {
                SWTBotGefEditPart childrenResult = this.findTextEditPart(child, label);
                if (childrenResult == null) continue;
                return childrenResult;
            }
        }
        return result;
    }

    protected String changeDefaultFontName(String fontName) {
        IPreferenceStore preferenceStore = (IPreferenceStore)DiagramUIPlugin.DIAGRAM_PREFERENCES_HINT.getPreferenceStore();
        FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)preferenceStore, (String)"Appearance.defaultFont");
        String oldName = fontData.getName();
        fontData.setName(fontName);
        PreferenceConverter.setDefault((IPreferenceStore)preferenceStore, (String)"Appearance.defaultFont", (FontData)fontData);
        return oldName;
    }

    protected Color getFigureBackgroundColor(AbstractBorderedShapeEditPart editPart, Class<? extends Figure> figureClass) {
        IFigure figure = editPart.getFigure();
        if (figureClass.isInstance(figure)) {
            return figure.getBackgroundColor();
        }
        return this.getFigureBackgroundColor(figure, figureClass);
    }

    protected Color getFigureBackgroundColor(IFigure parentFigure, Class<? extends Figure> figureClass) {
        Iterable filter = Iterables.filter((Iterable)parentFigure.getChildren(), figureClass);
        if (Iterables.size((Iterable)filter) == 1) {
            return ((Figure)Iterables.getOnlyElement((Iterable)filter)).getBackgroundColor();
        }
        Color backgroundColor = null;
        for (IFigure childFigure : Iterables.filter((Iterable)parentFigure.getChildren(), IFigure.class)) {
            backgroundColor = this.getFigureBackgroundColor(childFigure, figureClass);
            if (backgroundColor != null) break;
        }
        return backgroundColor;
    }

    protected void tearDown() throws Exception {
        this.failureTearDown();
        new TestCaseCleaner((TestCase)this).clearAllFields();
        super.tearDown();
        this.setErrorCatchActive(false);
    }
}

