/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.business;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.query.URIQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.tests.swtbot.support.api.business.UIAddLocalSemanticResourceWizardUIWrapper;
import org.eclipse.sirius.tests.swtbot.support.api.business.UIDiagramRepresentation;
import org.eclipse.sirius.tests.swtbot.support.api.business.UINewRepresentationBuilder;
import org.eclipse.sirius.tests.swtbot.support.api.business.UINewRepresentationBuilderFlow;
import org.eclipse.sirius.tests.swtbot.support.api.business.UIProject;
import org.eclipse.sirius.tests.swtbot.support.api.business.UIResource;
import org.eclipse.sirius.tests.swtbot.support.api.business.UITableRepresentation;
import org.eclipse.sirius.tests.swtbot.support.api.business.UITreeRepresentation;
import org.eclipse.sirius.tests.swtbot.support.api.business.sessionbrowser.UILocalSessionBrowser;
import org.eclipse.sirius.tests.swtbot.support.api.condition.ItemEnabledCondition;
import org.eclipse.sirius.tests.swtbot.support.api.condition.SessionClosedCondition;
import org.eclipse.sirius.tests.swtbot.support.api.condition.SessionSavedCondition;
import org.eclipse.sirius.tests.swtbot.support.api.condition.TreeItemExpanded;
import org.eclipse.sirius.tests.swtbot.support.api.dialog.ViewpointSelectionDialog;
import org.eclipse.sirius.tests.swtbot.support.utils.SWTBotUtils;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTableItem;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.junit.Assert;

public class UILocalSession {
    private static final String SEPARATOR = "/";
    protected UIResource modelResource;
    protected Session openedSession;
    protected final SWTWorkbenchBot bot;
    protected final UIResource sessionResource;
    private SWTBotView modelContentView;

    public UILocalSession(UIResource sessionResource) {
        this.sessionResource = sessionResource;
        this.modelResource = null;
        this.bot = new SWTWorkbenchBot();
        this.initSession();
    }

    public UILocalSession(UIResource modelResource, UIResource sessionResource) {
        this.modelResource = modelResource;
        this.sessionResource = sessionResource;
        this.bot = new SWTWorkbenchBot();
        this.initSession();
    }

    public UILocalSession(UIResource modelResource, UIResource sessionResource, Session openedSession) {
        this(modelResource, sessionResource);
        this.openedSession = openedSession;
    }

    private void initSession() {
        URI sessionResourceURI = URI.createPlatformResourceURI((String)this.sessionResource.getFullPath(), (boolean)true);
        this.openedSession = SessionManager.INSTANCE.getSession(sessionResourceURI, (IProgressMonitor)new NullProgressMonitor());
        if (this.modelResource == null && !this.openedSession.getSemanticResources().isEmpty()) {
            Resource firstSemanticResource = (Resource)this.openedSession.getSemanticResources().iterator().next();
            String path = this.sessionResource.getProject().getName();
            int i = 1;
            while (i < firstSemanticResource.getURI().segmentCount() - 1) {
                path = String.valueOf(path) + SEPARATOR + firstSemanticResource.getURI().segment(i);
                ++i;
            }
            this.modelResource = new UIResource(this.sessionResource.getProject(), path, firstSemanticResource.getURI().lastSegment());
        }
    }

    public Session getOpenedSession() {
        return this.openedSession;
    }

    public UILocalSession selectView() {
        this.modelContentView = this.bot.viewById("org.eclipse.sirius.ui.tools.views.model.explorer");
        this.modelContentView.setFocus();
        return this;
    }

    public SWTBotTreeItem getSemanticResourceNode(UIResource uiResource) {
        SWTBotTreeItem semanticResourceNode = null;
        SWTBotTreeItem rootTreeItem = this.getRootSessionTreeItem().expand();
        if (new URIQuery(this.openedSession.getSessionResource().getURI()).isInMemoryURI()) {
            semanticResourceNode = rootTreeItem.expand();
        } else {
            if (this.isModelingProject()) {
                semanticResourceNode = rootTreeItem;
                if (uiResource.getNodePath() != null && !uiResource.getNodePath().isEmpty()) {
                    int i = 0;
                    while (i < uiResource.getNodePath().size()) {
                        String pathSegment = uiResource.getNodePath().get(i);
                        semanticResourceNode = semanticResourceNode.getNode(pathSegment).expand();
                        ++i;
                    }
                }
            } else {
                semanticResourceNode = this.getRepresentationsFileTreeItem();
            }
            semanticResourceNode = semanticResourceNode.getNode(this.getSemanticResourceNodeLabel(uiResource)).expand();
        }
        return semanticResourceNode;
    }

    public UINewRepresentationBuilderFlow.ItemChoice<UIDiagramRepresentation> newDiagramRepresentation(String clickedRepresentationName) {
        return new UINewRepresentationBuilder<UIDiagramRepresentation>(clickedRepresentationName, UIDiagramRepresentation.class);
    }

    public UINewRepresentationBuilderFlow.ItemChoice<UITableRepresentation> newTableRepresentation(String clickedRepresentationName) {
        return new UINewRepresentationBuilder<UITableRepresentation>(clickedRepresentationName, UITableRepresentation.class);
    }

    public UINewRepresentationBuilderFlow.ItemChoice<UITreeRepresentation> newTreeRepresentation(String clickedRepresentationName) {
        return new UINewRepresentationBuilder<UITreeRepresentation>(clickedRepresentationName, UITreeRepresentation.class);
    }

    public UIAddLocalSemanticResourceWizardUIWrapper addLocalSemanticResource() {
        return new UIAddLocalSemanticResourceWizardUIWrapper(this);
    }

    public UILocalSessionBrowser getLocalSessionBrowser() {
        return new UILocalSessionBrowser(this.getRepresentationsFileTreeItem());
    }

    private String getLocalSessionNodeLabel() {
        if (this.isTransient()) {
            return this.modelResource.getName();
        }
        return this.sessionResource.getName();
    }

    protected String getSemanticResourceNodeLabel(UIResource modelUIResource) {
        String semanticResourceNodeLabel = null;
        if (this.isTransient()) {
            semanticResourceNodeLabel = modelUIResource.getName();
        } else if (this.isFirstSemanticResourceShared()) {
            Resource semanticResource = this.getCorrespondingResource(modelUIResource, this.openedSession.getSemanticResources());
            if (semanticResource != null) {
                semanticResourceNodeLabel = String.valueOf(modelUIResource.getName()) + " - [" + semanticResource.getURI() + "]";
            }
        } else {
            semanticResourceNodeLabel = String.valueOf(modelUIResource.getName()) + " - [platform:/resource/" + this.modelResource.getProject().getName() + SEPARATOR + modelUIResource.getLongName() + "]";
        }
        return semanticResourceNodeLabel;
    }

    private Resource getCorrespondingResource(UIResource modelUIResource, Collection<Resource> resources) {
        Resource correspondingResource = null;
        for (Resource resource : resources) {
            if (!modelUIResource.getName().equals(resource.getURI().lastSegment())) continue;
            correspondingResource = resource;
            break;
        }
        return correspondingResource;
    }

    private boolean isTransient() {
        return this.openedSession != null && this.openedSession.getSessionResource() != null && new URIQuery(this.openedSession.getSessionResource().getURI()).isInMemoryURI();
    }

    private boolean isFirstSemanticResourceShared() {
        boolean isFirstSemanticResourceShared = new URIQuery(((Resource)this.openedSession.getSemanticResources().iterator().next()).getURI()).isCDOURI();
        return isFirstSemanticResourceShared;
    }

    public UIResource getSessionResource() {
        return this.sessionResource;
    }

    public void close(boolean save) {
        if (this.isDirty()) {
            this.close();
            SWTBotButton button = save ? this.bot.button("Yes") : this.bot.button("No");
            this.bot.waitUntil((ICondition)new ItemEnabledCondition((AbstractSWTBot<? extends Widget>)button));
            SWTBotShell saveShell = this.bot.shell("Save");
            button.click();
            this.bot.waitUntil(Conditions.shellCloses((SWTBotShell)saveShell));
            this.bot.waitUntil((ICondition)new SessionClosedCondition(this.getOpenedSession()));
        } else {
            this.closeNoDirty();
        }
    }

    public boolean isDirty() {
        boolean isDirty = false;
        if (this.openedSession == null || SessionStatus.DIRTY.equals((Object)this.openedSession.getStatus())) {
            isDirty = true;
        }
        return isDirty;
    }

    public void closeNoDirty() {
        Assert.assertFalse((String)"The session is not expected to be dirty", (boolean)this.isDirty());
        this.close();
        this.bot.waitUntil((ICondition)new SessionClosedCondition(this.getOpenedSession()));
    }

    public void refresh() {
        SWTBotTreeItem rootTreeItem = this.getRootSessionTreeItem().select();
        SWTBotUtils.clickContextMenu(rootTreeItem, "Refresh");
        SWTBotUtils.waitAllUiEvents();
    }

    protected void close() {
        SWTBotTreeItem rootTreeItem = this.getRootSessionTreeItem().select();
        if (this.getOpenedSession().isOpen()) {
            if (this.isModelingProject()) {
                SWTBotUtils.clickContextMenu(rootTreeItem, "Close Project");
                SWTBotUtils.waitAllUiEvents();
            } else {
                SWTBotUtils.clickContextMenu(rootTreeItem, "Close");
                SWTBotUtils.waitAllUiEvents();
            }
        }
    }

    public void closeAndDiscardChanges() {
        this.close(false);
    }

    public UILocalSession save() {
        SWTBotTreeItem rootTreeItem = this.getRootSessionTreeItem().select();
        if (this.getOpenedSession().getStatus() == SessionStatus.DIRTY) {
            SWTBotUtils.clickContextMenu(rootTreeItem, "Save");
            SWTBotUtils.waitProgressMonitorClose("Progress Information");
            this.bot.waitUntil((ICondition)new SessionSavedCondition(this.getOpenedSession()), 2L * SWTBotPreferences.TIMEOUT);
        }
        return this;
    }

    public SWTBotTree getSWTBotTree() {
        return this.modelContentView.bot().tree();
    }

    public SWTBotTreeItem getRootSessionTreeItem() {
        this.selectView();
        SWTBotTreeItem treeItem = null;
        treeItem = this.isModelingProject() ? this.sessionResource.getProject().getProjectTreeItem() : this.getRepresentationsFileTreeItem();
        return treeItem;
    }

    public SWTBotTreeItem getRepresentationsFileTreeItem() {
        SWTBotTreeItem treeItem = null;
        this.selectView();
        SWTBotTree modelContentTree = this.getSWTBotTree();
        this.bot.waitUntil((ICondition)new ItemEnabledCondition((AbstractSWTBot<? extends Widget>)modelContentTree));
        SWTBotTreeItem[] allItems = modelContentTree.getAllItems();
        String localSessionNodeLabel = this.getLocalSessionNodeLabel();
        treeItem = this.findAndExpand(allItems, localSessionNodeLabel);
        return treeItem.expand();
    }

    public boolean isModelingProject() {
        boolean isModelingProject = false;
        String projectName = this.sessionResource.getProject().getName();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        try {
            isModelingProject = project.exists() && project.hasNature("org.eclipse.sirius.nature.modelingproject");
        }
        catch (CoreException coreException) {
            isModelingProject = false;
        }
        return isModelingProject;
    }

    private SWTBotTreeItem findAndExpand(SWTBotTreeItem[] allItems, String localSessionNodeLabel) {
        SWTBotTreeItem treeItem = null;
        if (localSessionNodeLabel == null) {
            return treeItem;
        }
        String dirtylocalSessionNodeLabel = "*" + localSessionNodeLabel;
        SWTBotTreeItem[] sWTBotTreeItemArray = allItems;
        int n = allItems.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem item = sWTBotTreeItemArray[n2];
            String text = item.getText();
            if (item.isEnabled() && localSessionNodeLabel.equals(text) || dirtylocalSessionNodeLabel.equals(text)) {
                treeItem = item;
            } else {
                boolean oldExpanded = item.isExpanded();
                item.expand();
                treeItem = this.findAndExpand(item.getItems(), localSessionNodeLabel);
                if (treeItem == null && !oldExpanded) {
                    item.collapse();
                }
            }
            if (treeItem != null) break;
            ++n2;
        }
        return treeItem;
    }

    public UILocalSession changeViewpointSelection(Set<String> viewpointsToSelect, Set<String> viewpointsToDeselect) {
        SWTBotTreeItem rootTreeItem = this.getRootSessionTreeItem().select();
        SWTBotUtils.clickContextMenu(rootTreeItem, "Viewpoints Selection");
        return this.changeViewpointSelectionInOpenedSelectionDialog(viewpointsToSelect, viewpointsToDeselect);
    }

    public UILocalSession changeViewpointSelectionInOpenedSelectionDialog(Set<String> viewpointsToSelect, Set<String> viewpointsToDeselect) {
        new ViewpointSelectionDialog(this.bot).selectViewpoint(viewpointsToSelect, viewpointsToDeselect);
        return this;
    }

    public UILocalSession export() {
        return this.export(false, true, false);
    }

    public UILocalSession export(boolean overrideExistingResources, boolean connectToExportedProject, boolean exportReferencedWorkspaceImages) {
        return this.export(overrideExistingResources, connectToExportedProject, exportReferencedWorkspaceImages, "localhost", "2037", "collab");
    }

    public UILocalSession export(boolean overrideExistingResources, boolean connectToExportedProject, boolean exportReferencedWorkspaceImages, String serverLocation, String serverPortNumber, String repositoryName) {
        SWTBotTreeItem projectTreeItem = this.getSessionResource().getProject().getProjectTreeItem();
        projectTreeItem.select();
        SWTBotUtils.clickContextMenu(projectTreeItem, "Export...");
        this.bot.waitUntil(Conditions.shellIsActive((String)"Export"));
        SWTBotShell activeShell = this.bot.activeShell();
        SWTBotUtils.waitAllUiEvents();
        SWTBot exportWizardBot = activeShell.bot();
        String exportWizardName = "Shared Modeling Project from Local";
        exportWizardBot.text().setText(exportWizardName);
        SWTBotTreeItem treeItem = exportWizardBot.tree().getTreeItem("Sirius");
        this.bot.waitUntil((ICondition)new TreeItemExpanded(treeItem, exportWizardName));
        treeItem.getNode(exportWizardName).select();
        exportWizardBot.button("Next >").click();
        if (overrideExistingResources) {
            exportWizardBot.button("Override existing resources").click();
        }
        if (!connectToExportedProject) {
            exportWizardBot.button("Connect to the exported project").click();
        }
        if (!exportReferencedWorkspaceImages) {
            exportWizardBot.checkBox("Export referenced workspace images").click();
        }
        exportWizardBot.button("Next >").click();
        exportWizardBot.text(0).setText(serverLocation);
        exportWizardBot.text(1).setText(serverPortNumber);
        exportWizardBot.text(2).setText(repositoryName);
        exportWizardBot.button("Test connection").click();
        SWTBotButton finishButton = exportWizardBot.button("Finish");
        this.bot.waitUntil(Conditions.widgetIsEnabled((AbstractSWTBot)finishButton));
        finishButton.click();
        if (connectToExportedProject) {
            this.bot.waitUntil(Conditions.shellIsActive((String)"Connect to the Exported Project"), 5L * SWTBotPreferences.TIMEOUT);
            SWTBot connectWizardBot = this.bot.activeShell().bot();
            finishButton = connectWizardBot.button("Finish");
            this.bot.waitUntil(Conditions.widgetIsEnabled((AbstractSWTBot)finishButton));
            finishButton.click();
            this.bot.waitUntil(Conditions.shellIsActive((String)"Viewpoints Selection"));
            SWTBotShell viewpointSelectionShell = this.bot.activeShell();
            SWTBot viewpointSelectionBot = viewpointSelectionShell.bot();
            Collection selectedViewpoints = this.getOpenedSession().getSelectedViewpoints(false);
            block0: for (Viewpoint locallySelectedViewpoint : selectedViewpoints) {
                int i = 0;
                while (i < viewpointSelectionBot.table().rowCount()) {
                    SWTBotTableItem tableItem = viewpointSelectionBot.table().getTableItem(i);
                    if (locallySelectedViewpoint.getName().equals(tableItem.getText(2))) {
                        viewpointSelectionBot.table().click(i, 0);
                        continue block0;
                    }
                    ++i;
                }
            }
            viewpointSelectionBot.button("OK").click();
            this.bot.waitUntil(Conditions.shellCloses((SWTBotShell)viewpointSelectionShell));
        }
        this.bot.waitUntil(Conditions.shellCloses((SWTBotShell)activeShell));
        UIProject sharedModelingProject = new UIProject(String.valueOf(this.getSessionResource().getProject().getName()) + ".shared");
        UIResource sharedSessionResource = new UIResource(sharedModelingProject, String.valueOf(sharedModelingProject.getName()) + "." + "aird");
        return new UILocalSession(sharedSessionResource);
    }
}

