/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.api.session;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.factory.SessionFactory;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.ui.IMemento;

public class SessionEditorInput
extends URIEditorInput {
    private static final String SESSION_RESOURCE_URI = "SESSION_RESOURCE_URI";
    private static final String DEFAULT_EDITOR_NAME = "Representation";
    private Session session;
    private String name;
    private URI sessionResourceURI;

    public SessionEditorInput(URI uri, String name, Session session) {
        super(uri, name);
        this.name = name;
        this.session = session;
        if (session.getSessionResource() != null) {
            this.sessionResourceURI = session.getSessionResource().getURI();
        }
    }

    public SessionEditorInput(IMemento memento) {
        super(memento);
        String sessionResourceURIString = memento.getString(SESSION_RESOURCE_URI);
        if (sessionResourceURIString != null) {
            this.sessionResourceURI = URI.createURI((String)sessionResourceURIString);
        }
    }

    public Session getSession() {
        if (this.session == null) {
            URI sessionModelURI = this.getURI().trimFragment();
            if (this.sessionResourceURI != null) {
                sessionModelURI = this.sessionResourceURI;
            }
            this.session = this.getSession(sessionModelURI);
        }
        return this.session;
    }

    public String getName() {
        return this.name == null ? super.getName() : this.name;
    }

    void setName(String string) {
        this.name = string;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putString("name", this.getName());
        memento.putString("class", ((Object)((Object)this)).getClass().getName());
        if (this.sessionResourceURI != null) {
            memento.putString(SESSION_RESOURCE_URI, this.sessionResourceURI.toString());
        }
    }

    protected void loadState(IMemento memento) {
        super.loadState(memento);
        this.setName(memento.getString("name"));
        String sessionResourceURIString = memento.getString(SESSION_RESOURCE_URI);
        if (sessionResourceURIString != null) {
            this.sessionResourceURI = URI.createURI((String)sessionResourceURIString);
            this.session = this.getSession(this.sessionResourceURI);
        }
    }

    protected Session getSession(URI sessionModelURI) {
        Session sessionFromURI;
        try {
            sessionFromURI = SessionManager.INSTANCE.getSession(sessionModelURI, (IProgressMonitor)new NullProgressMonitor());
            if (sessionFromURI != null) {
                if (!sessionFromURI.isOpen()) {
                    sessionFromURI.open((IProgressMonitor)new NullProgressMonitor());
                }
                IEditingSession uiSession = SessionUIManager.INSTANCE.getOrCreateUISession(sessionFromURI);
                uiSession.open();
            }
        }
        catch (IllegalStateException illegalStateException) {
            sessionFromURI = null;
        }
        return sessionFromURI;
    }

    protected String getBundleSymbolicName() {
        return SiriusEditPlugin.getPlugin().getSymbolicName();
    }

    public String getFactoryId() {
        return "org.eclipse.sirius.ui.business.api.session.SessionEditorInputFactory";
    }

    public static SessionEditorInput create(URI sessionResourceURI) {
        Session session;
        try {
            session = SessionFactory.INSTANCE.createSession(sessionResourceURI, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            return null;
        }
        return new SessionEditorInput(sessionResourceURI, DEFAULT_EDITOR_NAME, session);
    }

    public String getToolTipText() {
        return String.valueOf(this.getURI().trimFragment().toString()) + "/" + this.getName();
    }

    public void dispose() {
        this.session = null;
    }

    public boolean exists() {
        boolean exists = super.exists();
        if (!exists && this.session != null) {
            URI resourceURI = this.getURI().trimFragment();
            for (Resource resource : this.session.getAllSessionResources()) {
                if (!resource.getURI().equals(resourceURI)) continue;
                exists = true;
                break;
            }
        }
        return exists;
    }

    public Object getAdapter(Class adapter) {
        Session inputSession;
        Object a = super.getAdapter(adapter);
        if (IFile.class == adapter && a == null && EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE && (inputSession = this.getSession()) != null) {
            a = URIEditorInput.EclipseUtil.getAdatper((Class)adapter, (URI)inputSession.getSessionResource().getURI());
        }
        return a;
    }
}

