/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.dialect.description;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.filter.MappingFilter;
import org.eclipse.sirius.diagram.description.filter.VariableFilter;
import org.eclipse.sirius.diagram.description.filter.util.FilterSwitch;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class FilterInterpretedExpressionTargetSwitch
extends FilterSwitch<Option<Collection<String>>> {
    private static final int DO_NOT_CONSIDER_FEATURE = -1;
    protected int featureID;
    private IInterpretedExpressionTargetSwitch globalSwitch;
    private int lastFeatureID;

    public FilterInterpretedExpressionTargetSwitch(EStructuralFeature feature, IInterpretedExpressionTargetSwitch defaultInterpretedExpressionTargetSwitch) {
        this.lastFeatureID = this.featureID = feature != null ? feature.getFeatureID() : -1;
        this.globalSwitch = defaultInterpretedExpressionTargetSwitch;
    }

    public Option<Collection<String>> doSwitch(EObject theEObject) {
        Option doSwitch = (Option)super.doSwitch(theEObject);
        if (doSwitch != null) {
            return doSwitch;
        }
        LinkedHashSet targets = Sets.newLinkedHashSet();
        return Options.newSome((Object)targets);
    }

    public Option<Collection<String>> caseMappingFilter(MappingFilter object) {
        LinkedHashSet targetTypes = Sets.newLinkedHashSet();
        for (DiagramElementMapping mapping : object.getMappings()) {
            Option targetTypesForMapping = this.globalSwitch.doSwitch((EObject)mapping, false);
            if (!targetTypesForMapping.some()) continue;
            targetTypes.addAll((Collection)targetTypesForMapping.get());
        }
        return Options.newSome((Object)targetTypes);
    }

    public Option<Collection<String>> caseVariableFilter(VariableFilter object) {
        return Options.newNone();
    }

    public void setConsiderFeature(boolean considerFeature) {
        if (considerFeature) {
            this.featureID = this.lastFeatureID;
        } else {
            this.lastFeatureID = this.featureID;
            this.featureID = -1;
        }
    }
}

