/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.util.ObjectAdapter;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.DeferredLayoutCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ContainerEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.layout.IInternalLayoutRunnable;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.layout.LayoutNode;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.SnapCommand;
import org.eclipse.sirius.diagram.ui.tools.internal.ui.GMFRuntimeCompatibility;

public class SiriusContainerEditPolicy
extends ContainerEditPolicy {
    protected Command getArrangeCommand(ArrangeRequest request) {
        if (GMFRuntimeCompatibility.hasGMFPluginReleaseBetween1_2_0_And_1_3_3()) {
            Command snapCmd;
            IPreferenceStore preferenceStore;
            if ("arrange_deferred".equals(request.getType())) {
                String layoutType = request.getLayoutType();
                TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
                return new ICommandProxy((ICommand)new DeferredLayoutCommand(editingDomain, request.getViewAdaptersToArrange(), (IGraphicalEditPart)this.getHost(), layoutType));
            }
            String layoutDesc = request.getLayoutType() != null ? request.getLayoutType() : "DEFAULT";
            boolean offsetFromBoundingBox = false;
            List editparts = new ArrayList();
            if ("arrangeAllAction".equals(request.getType()) || "toolbarArrangeAllAction".equals(request.getType())) {
                editparts = ((IGraphicalEditPart)this.getHost()).getChildren();
                request.setPartsToArrange(editparts);
            }
            if ("arrangeSelectionAction".equals(request.getType()) || "toolbarArrangeSelectionAction".equals(request.getType())) {
                editparts = request.getPartsToArrange();
                offsetFromBoundingBox = true;
            }
            if ("arrange_radial".equals(request.getType())) {
                editparts = request.getPartsToArrange();
                offsetFromBoundingBox = true;
                layoutDesc = "RADIAL";
            }
            if (editparts.isEmpty()) {
                return null;
            }
            ArrayList<LayoutNode> nodes = new ArrayList<LayoutNode>(editparts.size());
            ListIterator li = editparts.listIterator();
            while (li.hasNext()) {
                IGraphicalEditPart ep = (IGraphicalEditPart)li.next();
                View view = ep.getNotationView();
                if (!ep.isActive() || view == null || !(view instanceof Node)) continue;
                Rectangle bounds = ep.getFigure().getBounds();
                nodes.add(new LayoutNode((Node)view, bounds.width, bounds.height));
            }
            if (nodes.isEmpty()) {
                return null;
            }
            ArrayList<String> hints = new ArrayList<String>(2);
            hints.add(layoutDesc);
            hints.add((String)this.getHost());
            ObjectAdapter layoutHint = new ObjectAdapter(hints);
            final Runnable layoutRun = this.layoutNodes(nodes, offsetFromBoundingBox, (IAdaptable)layoutHint);
            boolean isSnap = true;
            IGraphicalEditPart firstEditPart = (IGraphicalEditPart)editparts.get(0);
            if (firstEditPart.getViewer() instanceof DiagramGraphicalViewer && (preferenceStore = ((DiagramGraphicalViewer)firstEditPart.getViewer()).getWorkspaceViewerPreferenceStore()) != null) {
                isSnap = preferenceStore.getBoolean("rulergrid.snaptogrid");
            }
            TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
            CompositeTransactionalCommand ctc = new CompositeTransactionalCommand(editingDomain, "");
            if (layoutRun instanceof IInternalLayoutRunnable) {
                ctc.add((IUndoableOperation)new CommandProxy(((IInternalLayoutRunnable)layoutRun).getCommand()));
            } else {
                ctc.add((IUndoableOperation)new AbstractTransactionalCommand(editingDomain, "", null){

                    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                        layoutRun.run();
                        return CommandResult.newOKCommandResult();
                    }
                });
            }
            if (isSnap && (snapCmd = this.getSnapCommand((Request)request)) != null) {
                ctc.add((IUndoableOperation)new CommandProxy(this.getSnapCommand((Request)request)));
            }
            return new ICommandProxy((ICommand)ctc);
        }
        return super.getArrangeCommand(request);
    }

    private Command getSnapCommand(Request request) {
        List editparts = null;
        if (request instanceof GroupRequest) {
            editparts = ((GroupRequest)request).getEditParts();
        } else if (request instanceof ArrangeRequest) {
            editparts = ((ArrangeRequest)request).getPartsToArrange();
        }
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (editparts != null) {
            return new ICommandProxy((ICommand)new SnapCommand(editingDomain, editparts));
        }
        return null;
    }
}

