/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.IdentityCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionAnchorsCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionEndsCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetPropertyCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.TreeGraphicalNodeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.SetConnectionBendpointsCommand;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.ConnectorStyle;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.query.EdgeCreationDescriptionQuery;
import org.eclipse.sirius.diagram.business.api.query.IEdgeMappingQuery;
import org.eclipse.sirius.diagram.business.api.query.ReconnectEdgeDescriptionQuery;
import org.eclipse.sirius.diagram.description.CompositeLayout;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.Layout;
import org.eclipse.sirius.diagram.description.OrderedTreeLayout;
import org.eclipse.sirius.diagram.description.tool.EdgeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.ReconnectEdgeDescription;
import org.eclipse.sirius.diagram.description.tool.ReconnectionKind;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.tools.internal.command.builders.EdgeCreationCommandBuilder;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.business.internal.command.SiriusSetConnectionAnchorsCommand;
import org.eclipse.sirius.diagram.ui.business.internal.command.TreeLayoutSetConnectionAnchorsCommand;
import org.eclipse.sirius.diagram.ui.business.internal.query.DEdgeQuery;
import org.eclipse.sirius.diagram.ui.business.internal.query.RequestQuery;
import org.eclipse.sirius.diagram.ui.business.internal.view.EdgeLayoutData;
import org.eclipse.sirius.diagram.ui.business.internal.view.RootLayoutData;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramEdgeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramEdgeEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramEdgeEditPartOperation;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.command.GMFCommandWrapper;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.api.util.GMFNotationHelper;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DMappingBased;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.swt.widgets.Display;

public class SiriusGraphicalNodeEditPolicy
extends TreeGraphicalNodeEditPolicy {
    protected static final String GMF_EDGE_CREATION_DESCRIPTION = "edge.creation.description";
    protected static final String GMF_EDGE_TARGET_SOURCE = "edgeTarget.source";
    protected static final String GMF_EDGE_LOCATION_SOURCE = "edge.location.source";
    protected static final String GMF_EDGE_SOURCE_TERMINAL = "edge.newSourceTerminal";
    private static final int WIDTH_FEEDBACK = 2;
    private RectangleFigure highlightFigure;

    protected org.eclipse.gef.commands.Command getReconnectSourceCommand(ReconnectRequest request) {
        Edge edge;
        if (request.getConnectionEditPart().getModel() instanceof Edge && GMFNotationHelper.isNoteAttachment(edge = (Edge)request.getConnectionEditPart().getModel())) {
            return super.getReconnectSourceCommand(request);
        }
        edge = null;
        EdgeTarget target = null;
        ConnectionEditPart connectionEditPart = request.getConnectionEditPart();
        if (connectionEditPart.getModel() instanceof View && ((View)connectionEditPart.getModel()).getElement() instanceof DEdge) {
            edge = (DEdge)((View)connectionEditPart.getModel()).getElement();
        }
        EdgeTarget source = null;
        if (edge != null) {
            source = edge.getSourceNode();
        }
        if (request.getTarget().getModel() instanceof View && ((View)request.getTarget().getModel()).getElement() instanceof EdgeTarget) {
            target = (EdgeTarget)((View)request.getTarget().getModel()).getElement();
        }
        UnexecutableCommand cmd = UnexecutableCommand.INSTANCE;
        if (source != null && target != null) {
            if (target != source) {
                ReconnectEdgeDescription tool;
                Option edgeMapping = new IEdgeMappingQuery(edge.getActualMapping()).getEdgeMapping();
                ReconnectEdgeDescription reconnectEdgeDescription = tool = edgeMapping.some() ? this.getBestTool((EdgeMapping)edgeMapping.get(), true, source, target, (DEdge)edge) : null;
                if (tool != null) {
                    CompoundCommand result = new CompoundCommand();
                    result.add(this.getToolCommand(tool, (DEdge)edge, source, target));
                    result.add(this.getReconnectSourceCommandAfterTool(request));
                    cmd = result;
                }
            } else {
                cmd = this.applySpecificTreeLayout(request.getConnectionEditPart()) ? this.getReconnectSourceForTreeLayoutCommand(request) : super.getReconnectSourceCommand(request);
            }
        }
        return cmd;
    }

    private org.eclipse.gef.commands.Command getReconnectSourceCommandAfterTool(ReconnectRequest request) {
        INodeEditPart node = this.getConnectableEditPart();
        if (node == null) {
            return null;
        }
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        ConnectionAnchor sourceAnchor = node.getSourceConnectionAnchor((Request)request);
        View sourceView = (View)request.getTarget().getModel();
        SiriusSetConnectionAnchorsCommand scaCommand = new SiriusSetConnectionAnchorsCommand(editingDomain, DiagramUIMessages.Commands_SetConnectionEndsCommand_Source, sourceView, (List<Edge>)sourceView.getSourceEdges(), ReconnectionKind.RECONNECT_SOURCE_LITERAL);
        scaCommand.setNewSourceTerminal(node.mapConnectionAnchorToTerminal(sourceAnchor));
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.Commands_SetConnectionEndsCommand_Source);
        cc.compose((IUndoableOperation)scaCommand);
        return new ICommandProxy((ICommand)scaCommand);
    }

    protected org.eclipse.gef.commands.Command getReconnectTargetCommand(ReconnectRequest request) {
        Edge edge;
        if (request.getConnectionEditPart().getModel() instanceof Edge && GMFNotationHelper.isNoteAttachment(edge = (Edge)request.getConnectionEditPart().getModel())) {
            return super.getReconnectTargetCommand(request);
        }
        edge = null;
        EdgeTarget target = null;
        ConnectionEditPart connectionEditPart = request.getConnectionEditPart();
        if (connectionEditPart.getModel() instanceof View && ((View)connectionEditPart.getModel()).getElement() instanceof DEdge) {
            edge = (DEdge)((View)connectionEditPart.getModel()).getElement();
        }
        EdgeTarget source = null;
        if (edge != null) {
            source = edge.getTargetNode();
        }
        if (request.getTarget().getModel() instanceof View && ((View)request.getTarget().getModel()).getElement() instanceof EdgeTarget) {
            target = (EdgeTarget)((View)request.getTarget().getModel()).getElement();
        }
        UnexecutableCommand cmd = UnexecutableCommand.INSTANCE;
        if (source != null && target != null) {
            if (target != source) {
                ReconnectEdgeDescription tool;
                Option edgeMapping = new IEdgeMappingQuery(edge.getActualMapping()).getEdgeMapping();
                ReconnectEdgeDescription reconnectEdgeDescription = tool = edgeMapping.some() ? this.getBestTool((EdgeMapping)edgeMapping.get(), false, source, target, (DEdge)edge) : null;
                if (tool != null) {
                    CompoundCommand result = new CompoundCommand();
                    result.add(this.getToolCommand(tool, (DEdge)edge, source, target));
                    result.add(this.getReconnectTargetCommandAfterTool(request));
                    cmd = result;
                }
            } else {
                cmd = this.applySpecificTreeLayout(request.getConnectionEditPart()) ? this.getReconnectTargetForTreeLayoutCommand(request) : super.getReconnectTargetCommand(request);
            }
        }
        return cmd;
    }

    private org.eclipse.gef.commands.Command getReconnectTargetCommandAfterTool(ReconnectRequest request) {
        org.eclipse.gef.commands.Command cmdRouter;
        INodeEditPart node = this.getConnectableEditPart();
        if (node == null || this.getConnectionCompleteEditPart((Request)request) == null) {
            return null;
        }
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        ConnectionAnchor targetAnchor = this.getConnectionTargetAnchor((Request)request);
        INodeEditPart targetEP = this.getConnectionCompleteEditPart((Request)request);
        View targetView = (View)targetEP.getModel();
        SiriusSetConnectionAnchorsCommand scaCommand = new SiriusSetConnectionAnchorsCommand(editingDomain, DiagramUIMessages.Commands_SetConnectionEndsCommand_Target, targetView, (List<Edge>)targetView.getTargetEdges(), ReconnectionKind.RECONNECT_TARGET_LITERAL);
        scaCommand.setNewTargetTerminal(targetEP.mapConnectionAnchorToTerminal(targetAnchor));
        ICommandProxy cmd = new ICommandProxy((ICommand)scaCommand);
        ConnectionEditPart cep = request.getConnectionEditPart();
        RoutingStyle style = (RoutingStyle)((View)cep.getModel()).getStyle(NotationPackage.eINSTANCE.getRoutingStyle());
        Routing currentRouter = Routing.MANUAL_LITERAL;
        if (style != null) {
            currentRouter = style.getRouting();
        }
        if ((cmdRouter = this.getRoutingAdjustment((IAdaptable)request.getConnectionEditPart(), this.getSemanticHint((Request)request), currentRouter, request.getTarget())) != null) {
            cmd = cmd == null ? cmdRouter : cmd.chain(cmdRouter);
            ConnectionAnchor sourceAnchor = node.getSourceConnectionAnchor((Request)request);
            PointList pointList = new PointList();
            pointList.addPoint(sourceAnchor.getLocation(targetAnchor.getReferencePoint()));
            pointList.addPoint(targetAnchor.getLocation(sourceAnchor.getReferencePoint()));
            SetConnectionBendpointsCommand sbbCommand = new SetConnectionBendpointsCommand(editingDomain);
            sbbCommand.setEdgeAdapter((IAdaptable)request.getConnectionEditPart());
            sbbCommand.setNewPointList(pointList, sourceAnchor.getReferencePoint(), targetAnchor.getReferencePoint());
            ICommandProxy cmdBP = new ICommandProxy((ICommand)sbbCommand);
            if (cmdBP != null) {
                cmd = cmd == null ? cmdBP : cmd.chain((org.eclipse.gef.commands.Command)cmdBP);
            }
        }
        return cmd;
    }

    private ReconnectEdgeDescription getBestTool(EdgeMapping mapping, boolean source, EdgeTarget oldTarget, EdgeTarget newTarget, DEdge edge) {
        ArrayList<ReconnectEdgeDescription> candidateTool = new ArrayList<ReconnectEdgeDescription>((Collection<ReconnectEdgeDescription>)mapping.getReconnections());
        ReconnectEdgeDescription bestTool = null;
        EObject semanticSource = null;
        EObject semanticTarget = null;
        EObject semanticElement = null;
        if (oldTarget instanceof DSemanticDecorator) {
            semanticSource = ((DSemanticDecorator)oldTarget).getTarget();
        }
        if (newTarget instanceof DSemanticDecorator) {
            semanticTarget = ((DSemanticDecorator)newTarget).getTarget();
        }
        semanticElement = edge.getTarget();
        this.selectReconnectionToolCandidates(candidateTool, source);
        if (!candidateTool.isEmpty()) {
            ReconnectEdgeDescription myTool;
            Iterator toolIterator = candidateTool.iterator();
            while (toolIterator.hasNext()) {
                myTool = (ReconnectEdgeDescription)toolIterator.next();
                String precondition = myTool.getPrecondition();
                if (precondition == null || StringUtil.isEmpty((String)precondition)) continue;
                IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(semanticElement);
                interpreter.setVariable("diagram", (Object)edge.getParentDiagram());
                interpreter.setVariable("source", (Object)semanticSource);
                interpreter.setVariable("sourceView", (Object)oldTarget);
                interpreter.setVariable("target", (Object)semanticTarget);
                interpreter.setVariable("targetView", (Object)newTarget);
                interpreter.setVariable("element", (Object)semanticElement);
                boolean preconditionOK = RuntimeLoggerManager.INSTANCE.decorate(interpreter).evaluateBoolean(semanticElement, (EObject)myTool, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition());
                if (!preconditionOK) {
                    toolIterator.remove();
                }
                interpreter.unSetVariable("source");
                interpreter.unSetVariable("target");
                interpreter.unSetVariable("element");
                interpreter.unSetVariable("diagram");
                interpreter.unSetVariable("sourceView");
                interpreter.unSetVariable("targetView");
            }
            toolIterator = candidateTool.iterator();
            while (toolIterator.hasNext()) {
                myTool = (ReconnectEdgeDescription)toolIterator.next();
                if (new ReconnectEdgeDescriptionQuery(myTool).isEndAuthorized(source, newTarget)) continue;
                toolIterator.remove();
            }
        }
        if (!candidateTool.isEmpty()) {
            bestTool = (ReconnectEdgeDescription)candidateTool.get(0);
        }
        return bestTool;
    }

    private void selectReconnectionToolCandidates(List<ReconnectEdgeDescription> candidateTool, boolean source) {
        Iterator<ReconnectEdgeDescription> iterTools = candidateTool.iterator();
        while (iterTools.hasNext()) {
            ReconnectEdgeDescription currentTool = iterTools.next();
            if ((!source || currentTool.getReconnectionKind() != ReconnectionKind.RECONNECT_TARGET_LITERAL) && (source || currentTool.getReconnectionKind() != ReconnectionKind.RECONNECT_SOURCE_LITERAL)) continue;
            iterTools.remove();
        }
    }

    private org.eclipse.gef.commands.Command getToolCommand(ReconnectEdgeDescription tool, DEdge edge, EdgeTarget source, EdgeTarget target) {
        DDiagramEditor diagramEditor = (DDiagramEditor)this.getHost().getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
        if (diagramEditor != null) {
            Object adapter = diagramEditor.getAdapter(IDiagramCommandFactoryProvider.class);
            IDiagramCommandFactoryProvider cmdFactoryProvider = (IDiagramCommandFactoryProvider)adapter;
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)source);
            IDiagramCommandFactory emfCommandFactory = cmdFactoryProvider.getCommandFactory(domain);
            return new ICommandProxy((ICommand)new GMFCommandWrapper(domain, emfCommandFactory.buildReconnectEdgeCommandFromTool(tool, edge, source, target)));
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected org.eclipse.gef.commands.Command getConnectionCreateCommand(CreateConnectionRequest request) {
        org.eclipse.gef.commands.Command connectionCreateCommand = null;
        if (request instanceof CreateConnectionViewRequest) {
            connectionCreateCommand = super.getConnectionCreateCommand(request);
        } else {
            AbstractToolDescription abstractToolDescription;
            View view;
            Map extendedData = request.getExtendedData();
            ConnectionAnchor sourceAnchor = this.getConnectableEditPart().getSourceConnectionAnchor((Request)request);
            String newSourceTerminal = this.getConnectableEditPart().mapConnectionAnchorToTerminal(sourceAnchor);
            Point sourceLocation = this.getConvertedLocation((CreateRequest)request);
            extendedData.put(GMF_EDGE_LOCATION_SOURCE, sourceLocation.getCopy());
            extendedData.put(GMF_EDGE_SOURCE_TERMINAL, newSourceTerminal);
            GraphicalEditPart graphicalEditPart = (GraphicalEditPart)this.getHost();
            DSemanticDecorator decorateSemanticElement = null;
            if (graphicalEditPart.getModel() instanceof View && (view = (View)graphicalEditPart.getModel()).getElement() instanceof DSemanticDecorator) {
                decorateSemanticElement = (DSemanticDecorator)view.getElement();
            }
            if (decorateSemanticElement instanceof EdgeTarget && request.getNewObject() instanceof AbstractToolDescription && (abstractToolDescription = (AbstractToolDescription)request.getNewObject()) instanceof EdgeCreationDescription) {
                EdgeCreationDescription edgeCreationDescription = (EdgeCreationDescription)abstractToolDescription;
                boolean canCreate = new EdgeCreationDescriptionQuery(edgeCreationDescription).isValidAsSourceElement((DMappingBased)decorateSemanticElement);
                boolean bl = canCreate = canCreate && new EdgeCreationCommandBuilder(edgeCreationDescription, (EdgeTarget)decorateSemanticElement, null).checkStartPrecondition();
                if (canCreate) {
                    extendedData.put(GMF_EDGE_CREATION_DESCRIPTION, edgeCreationDescription);
                    extendedData.put(GMF_EDGE_TARGET_SOURCE, decorateSemanticElement);
                    connectionCreateCommand = new ICommandProxy((ICommand)IdentityCommand.INSTANCE);
                }
            }
        }
        if (connectionCreateCommand == null) {
            connectionCreateCommand = super.getConnectionCreateCommand(request);
        }
        return connectionCreateCommand;
    }

    protected org.eclipse.gef.commands.Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        org.eclipse.gef.commands.Command connectionCompleteCommand = null;
        connectionCompleteCommand = new RequestQuery((Request)request).isNoteAttachmentCreationRequest() ? super.getConnectionCompleteCommand(request) : this.buildSiriusConnectionCreationCmd(request);
        return connectionCompleteCommand;
    }

    private org.eclipse.gef.commands.Command buildSiriusConnectionCreationCmd(CreateConnectionRequest request) {
        org.eclipse.gef.commands.Command viewpointConnectionCreationCmd = null;
        INodeEditPart targetEP = this.getConnectionCompleteEditPart((Request)request);
        if (targetEP != null) {
            EdgeTarget source;
            View view;
            INodeEditPart sourceEditPart = (INodeEditPart)request.getSourceEditPart();
            Point sourceLocation = this.getEdgeLocationSource(request);
            Point targetLocation = this.getConvertedLocation((CreateRequest)request);
            String newSourceTerminal = this.getEdgeTerminalSource(request);
            ConnectionAnchor sourceAnchor = sourceEditPart.mapTerminalToConnectionAnchor(newSourceTerminal);
            ConnectionAnchor targetAnchor = targetEP.getTargetConnectionAnchor((Request)request);
            String newTargetTerminal = targetEP.mapConnectionAnchorToTerminal(targetAnchor);
            PointList pointList = new PointList();
            if (request.getLocation() == null) {
                pointList.addPoint(sourceAnchor.getLocation(targetAnchor.getReferencePoint()));
                pointList.addPoint(targetAnchor.getLocation(sourceAnchor.getReferencePoint()));
            } else {
                pointList.addPoint(sourceAnchor.getLocation(request.getLocation()));
                pointList.addPoint(targetAnchor.getLocation(request.getLocation()));
            }
            Point sourceRefPoint = sourceAnchor.getReferencePoint();
            Point targetRefPoint = targetAnchor.getReferencePoint();
            RootLayoutData sourceLayoutData = new RootLayoutData((EditPart)sourceEditPart, sourceLocation.getCopy(), null);
            RootLayoutData targetLayoutData = new RootLayoutData((EditPart)targetEP, targetLocation.getCopy(), null);
            EdgeLayoutData edgeLayoutData = new EdgeLayoutData(sourceLayoutData, targetLayoutData);
            edgeLayoutData.setSourceTerminal(newSourceTerminal);
            edgeLayoutData.setTargetTerminal(newTargetTerminal);
            edgeLayoutData.setPointList(pointList.getCopy());
            edgeLayoutData.setSourceRefPoint(sourceRefPoint.getCopy());
            edgeLayoutData.setTargetRefPoint(targetRefPoint.getCopy());
            DSemanticDecorator decorateSemanticElement = null;
            if (this.getHost().getModel() instanceof View && (view = (View)this.getHost().getModel()).getElement() instanceof DSemanticDecorator) {
                decorateSemanticElement = (DSemanticDecorator)view.getElement();
            }
            if (decorateSemanticElement instanceof EdgeTarget && request.getExtendedData().get(GMF_EDGE_CREATION_DESCRIPTION) instanceof EdgeCreationDescription && (source = (EdgeTarget)request.getExtendedData().get(GMF_EDGE_TARGET_SOURCE)) != null) {
                EdgeTarget target = (EdgeTarget)decorateSemanticElement;
                EdgeCreationDescription edgeCreationDescription = (EdgeCreationDescription)request.getExtendedData().get(GMF_EDGE_CREATION_DESCRIPTION);
                boolean canCreate = new EdgeCreationDescriptionQuery(edgeCreationDescription).canBeAppliedOn((DMappingBased)source, (DMappingBased)target);
                if (canCreate) {
                    DDiagramEditor diagramEditor = (DDiagramEditor)this.getHost().getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
                    IDiagramCommandFactoryProvider cmdFactoryProvider = (IDiagramCommandFactoryProvider)diagramEditor.getAdapter(IDiagramCommandFactoryProvider.class);
                    viewpointConnectionCreationCmd = this.buildCreateEdgeCommand(request, source, target, edgeCreationDescription, cmdFactoryProvider, edgeLayoutData);
                }
            }
        }
        return viewpointConnectionCreationCmd;
    }

    private Point getConvertedLocation(CreateRequest request) {
        Point realLocation;
        Point location = request.getLocation().getCopy();
        if (location != null && this.getHost() instanceof GraphicalEditPart) {
            IFigure fig = ((GraphicalEditPart)this.getHost()).getFigure();
            fig.translateToRelative((Translatable)location);
            Point containerLocation = fig.getBounds().getLocation();
            location = new Point(location.x - containerLocation.x, location.y - containerLocation.y);
            if (fig instanceof ResizableCompartmentFigure) {
                Point scrollOffset = ((ResizableCompartmentFigure)fig).getScrollPane().getViewport().getViewLocation();
                realLocation = new Point(location.x + scrollOffset.x, location.y + scrollOffset.y);
            } else {
                realLocation = location;
            }
        } else {
            realLocation = location;
        }
        return realLocation;
    }

    private String getEdgeTerminalSource(CreateConnectionRequest request) {
        ICommandProxy commandProxy;
        org.eclipse.gef.commands.Command startCommand;
        String edgeTerminalSource = (String)request.getExtendedData().get(GMF_EDGE_SOURCE_TERMINAL);
        if (edgeTerminalSource == null && (startCommand = request.getStartCommand()) instanceof ICommandProxy && (commandProxy = (ICommandProxy)startCommand).getICommand() instanceof CompositeCommand) {
            CompositeCommand compositeCommand = (CompositeCommand)commandProxy.getICommand();
            for (Object cmd : compositeCommand) {
                if (!(cmd instanceof SetConnectionAnchorsCommand)) continue;
                SetConnectionAnchorsCommand setConnectionAnchorsCommand = (SetConnectionAnchorsCommand)cmd;
                edgeTerminalSource = setConnectionAnchorsCommand.getNewSourceTerminal();
            }
        }
        return edgeTerminalSource;
    }

    private Point getEdgeLocationSource(CreateConnectionRequest request) {
        Point edgeLocationSource = (Point)request.getExtendedData().get(GMF_EDGE_LOCATION_SOURCE);
        return edgeLocationSource;
    }

    protected org.eclipse.gef.commands.Command buildCreateEdgeCommand(CreateConnectionRequest request, EdgeTarget source, EdgeTarget target, EdgeCreationDescription edgeCreationDescription, IDiagramCommandFactoryProvider cmdFactoryProvider, EdgeLayoutData edgeLayoutData) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)source);
        CompoundCommand result = new CompoundCommand(edgeCreationDescription.getName());
        this.addStoreLayoutDataCommand(result, edgeLayoutData);
        Command emfCommand = cmdFactoryProvider.getCommandFactory(domain).buildCreateEdgeCommandFromTool(source, target, edgeCreationDescription);
        result.add((org.eclipse.gef.commands.Command)new ICommandProxy((ICommand)new GMFCommandWrapper(domain, emfCommand)));
        return result;
    }

    protected void addStoreLayoutDataCommand(CompoundCommand result, final EdgeLayoutData edgeLayoutData) {
        result.add(new org.eclipse.gef.commands.Command(){

            public void execute() {
                SiriusLayoutDataManager.INSTANCE.addData(edgeLayoutData);
            }
        });
    }

    protected org.eclipse.gef.commands.Command getRoutingAdjustment(IAdaptable connection, String connectionHint, Routing currentRouterType, EditPart target) {
        org.eclipse.gef.commands.Command cmd = null;
        if (connectionHint == null || target == null || target.getModel() == null || ((View)target.getModel()).getElement() == null) {
            return null;
        }
        Routing newRouterType = null;
        if (connection instanceof IDiagramEdgeEditPart) {
            TransactionalEditingDomain domain;
            SetPropertyCommand spc;
            ICommandProxy cmdRouter;
            DEdge dEdge;
            DDiagramElement element = ((IDiagramEdgeEditPart)connection).resolveDiagramElement();
            if (element instanceof DEdge && (newRouterType = new DEdgeQuery(dEdge = (DEdge)element).getRouting()) != null && !currentRouterType.equals(newRouterType) && (cmdRouter = new ICommandProxy((ICommand)(spc = new SetPropertyCommand(domain = TransactionUtil.getEditingDomain((EObject)element), connection, Properties.ID_ROUTING, "", (Object)newRouterType)))) != null) {
                cmd = cmdRouter;
            }
        } else {
            cmd = super.getRoutingAdjustment(connection, connectionHint, currentRouterType, target);
        }
        return cmd;
    }

    protected ConnectionAnchor getConnectionTargetAnchor(Request request) {
        INodeEditPart node;
        ReconnectRequest reconnectRequest;
        if (request instanceof ReconnectRequest && (reconnectRequest = (ReconnectRequest)request).getTarget() instanceof DEdgeEditPart && reconnectRequest.getConnectionEditPart() instanceof DEdgeEditPart && (node = this.getConnectableEditPart()) != null) {
            return node.getTargetConnectionAnchor(request);
        }
        return super.getConnectionTargetAnchor(request);
    }

    protected INodeEditPart getConnectionCompleteEditPart(Request request) {
        ReconnectRequest reconnectRequest;
        if (request instanceof ReconnectRequest && (reconnectRequest = (ReconnectRequest)request).getTarget() instanceof DEdgeEditPart && reconnectRequest.getConnectionEditPart() instanceof DEdgeEditPart && this.getHost() instanceof INodeEditPart) {
            return (INodeEditPart)this.getHost();
        }
        return super.getConnectionCompleteEditPart(request);
    }

    protected void showTargetConnectionFeedback(DropRequest request) {
        this.removeHighlight();
        boolean reveal = false;
        if (request instanceof ReconnectRequest) {
            reveal = true;
            this.addHighlight(reveal);
        }
    }

    private void addHighlight(boolean reveal) {
        Rectangle bounds = this.getHostFigure().getBounds().getCopy();
        this.getHostFigure().getParent().translateToAbsolute((Translatable)bounds);
        this.getFeedbackLayer().translateToRelative((Translatable)bounds);
        if (this.getHostFigure() instanceof AbstractDiagramEdgeEditPart.ViewEdgeFigure) {
            if (this.getHostFigure() != null && Display.getCurrent() != null) {
                this.getHostFigure().setForegroundColor(Display.getCurrent().getSystemColor(26));
                ((AbstractDiagramEdgeEditPart.ViewEdgeFigure)this.getHostFigure()).setLineWidth(DiagramEdgeEditPartOperation.getLineWidth((IDiagramEdgeEditPart)this.getHost()) + 2);
                for (Object child : this.getHostFigure().getChildren()) {
                    if (!(child instanceof PolylineDecoration)) continue;
                    PolylineDecoration decoration = (PolylineDecoration)child;
                    decoration.setLineWidth(DiagramEdgeEditPartOperation.getLineWidth((IDiagramEdgeEditPart)this.getHost()) + 2);
                }
                if (reveal) {
                    this.getHost().getViewer().reveal(this.getHost());
                }
            }
        } else {
            this.highlightFigure = new RectangleFigure(){

                public void paint(Graphics graphics) {
                    graphics.setAlpha(128);
                    super.paint(graphics);
                }
            };
            this.highlightFigure.setBounds(bounds);
            this.highlightFigure.setBackgroundColor(Display.getCurrent().getSystemColor(26));
            this.addFeedback((IFigure)this.highlightFigure);
            if (reveal) {
                this.getHost().getViewer().reveal(this.getHost());
            }
        }
    }

    protected void eraseTargetConnectionFeedback(DropRequest request) {
        this.removeHighlight();
    }

    private void removeHighlight() {
        if (this.highlightFigure != null) {
            this.removeFeedback((IFigure)this.highlightFigure);
            this.highlightFigure = null;
        }
        if (this.getHostFigure() instanceof AbstractDiagramEdgeEditPart.ViewEdgeFigure) {
            ((IDiagramEdgeEditPart)this.getHost()).refreshForegroundColor();
            ((IDiagramEdgeEditPart)this.getHost()).refreshLineStyle();
        }
    }

    private boolean applySpecificTreeLayout(ConnectionEditPart connectionEditPart) {
        Diagram diagram;
        boolean isLayoutComponent = false;
        if (this.isEdgeTreeRoutingStyle(connectionEditPart) && !this.isSourceOrTargetIsEdge(connectionEditPart) && (diagram = this.getDiagram(connectionEditPart)) != null && diagram.getElement() instanceof DSemanticDiagram) {
            DSemanticDiagram dSemanticDiagram = (DSemanticDiagram)diagram.getElement();
            Layout layout = dSemanticDiagram.getDescription().getLayout();
            isLayoutComponent = this.isOrderedTreeLayoutOrCompositeLayout(layout);
        }
        return isLayoutComponent;
    }

    private boolean isSourceOrTargetIsEdge(ConnectionEditPart connectionEditPart) {
        return connectionEditPart.getSource() instanceof ConnectionEditPart || connectionEditPart.getTarget() instanceof ConnectionEditPart;
    }

    private boolean isEdgeTreeRoutingStyle(ConnectionEditPart connectionEditPart) {
        Edge edge;
        boolean isEdgeTreeRoutingStyle = false;
        if (connectionEditPart.getModel() instanceof Edge && !(edge = (Edge)connectionEditPart.getModel()).getStyles().isEmpty() && edge.getStyles().get(0) instanceof ConnectorStyle) {
            ConnectorStyle connectorStyle = (ConnectorStyle)edge.getStyles().get(0);
            if (Routing.TREE_LITERAL.getLiteral().equals(connectorStyle.getRouting().getLiteral())) {
                isEdgeTreeRoutingStyle = true;
            }
        }
        return isEdgeTreeRoutingStyle;
    }

    private Diagram getDiagram(ConnectionEditPart connectionEditPart) {
        DiagramEditPart diagramEditPart;
        DiagramRootEditPart diagramRootEditPart;
        Diagram diagram = null;
        if (connectionEditPart.getParent() instanceof DiagramRootEditPart && (diagramRootEditPart = (DiagramRootEditPart)connectionEditPart.getParent()).getChildren().get(0) instanceof DiagramEditPart && (diagramEditPart = (DiagramEditPart)diagramRootEditPart.getChildren().get(0)).getModel() instanceof Diagram) {
            diagram = (Diagram)diagramEditPart.getModel();
        }
        return diagram;
    }

    private boolean isOrderedTreeLayoutOrCompositeLayout(Layout layout) {
        boolean isLayout = false;
        if (layout instanceof OrderedTreeLayout || layout instanceof CompositeLayout) {
            isLayout = layout instanceof CompositeLayout ? true : true;
        }
        return isLayout;
    }

    private org.eclipse.gef.commands.Command getReconnectTargetForTreeLayoutCommand(ReconnectRequest request) {
        INodeEditPart node = this.getConnectableEditPart();
        ICommandProxy cmd = null;
        if (node != null) {
            TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
            ConnectionAnchor targetAnchor = this.getConnectionTargetAnchor((Request)request);
            INodeEditPart targetEP = this.getConnectionCompleteEditPart((Request)request);
            if (targetEP != null) {
                SetConnectionEndsCommand sceCommand = new SetConnectionEndsCommand(editingDomain, "");
                sceCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)request.getConnectionEditPart().getModel()));
                sceCommand.setNewTargetAdaptor((IAdaptable)targetEP);
                TreeLayoutSetConnectionAnchorsCommand scaCommand = new TreeLayoutSetConnectionAnchorsCommand(editingDomain, "");
                scaCommand.setEdgeAdaptor((IAdaptable)request.getConnectionEditPart());
                scaCommand.setNewTargetTerminal(targetEP.mapConnectionAnchorToTerminal(targetAnchor));
                CompositeCommand cc = new CompositeCommand(DiagramUIMessages.Commands_SetConnectionEndsCommand_Target);
                cc.compose((IUndoableOperation)sceCommand);
                cc.compose((IUndoableOperation)scaCommand);
                cmd = new ICommandProxy((ICommand)cc);
            }
        }
        return cmd;
    }

    private org.eclipse.gef.commands.Command getReconnectSourceForTreeLayoutCommand(ReconnectRequest request) {
        INodeEditPart node = this.getConnectableEditPart();
        if (node == null) {
            return null;
        }
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        ConnectionAnchor sourceAnchor = node.getSourceConnectionAnchor((Request)request);
        SetConnectionEndsCommand sceCommand = new SetConnectionEndsCommand(editingDomain, "");
        sceCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)((View)request.getConnectionEditPart().getModel())));
        sceCommand.setNewSourceAdaptor((IAdaptable)new EObjectAdapter((EObject)((View)node.getModel())));
        TreeLayoutSetConnectionAnchorsCommand scaCommand = new TreeLayoutSetConnectionAnchorsCommand(editingDomain, "");
        scaCommand.setEdgeAdaptor((IAdaptable)request.getConnectionEditPart());
        scaCommand.setNewSourceTerminal(node.mapConnectionAnchorToTerminal(sourceAnchor));
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.Commands_SetConnectionEndsCommand_Source);
        cc.compose((IUndoableOperation)sceCommand);
        cc.compose((IUndoableOperation)scaCommand);
        return new ICommandProxy((ICommand)cc);
    }
}

