/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.componentization.mappings;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramDescriptionMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramDescriptionMappingsManagerListener;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManagerRegistry;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.business.internal.experimental.sync.AbstractDNodeCandidate;
import org.eclipse.sirius.diagram.business.internal.layers.GlobalMappingsTable;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.MappingsListVisitor;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.ContainerMappingImport;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.viewpoint.description.AbstractMappingImport;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public final class DiagramMappingsManagerImpl
implements DiagramMappingsManager,
DiagramDescriptionMappingsManagerListener {
    private final DDiagram diagram;
    private final DiagramDescriptionMappingsManager descriptionMappings;
    private GlobalMappingsTable mappingsTable;

    public DiagramMappingsManagerImpl(DDiagram diagram, DiagramDescriptionMappingsManager descriptionMappings) {
        this.diagram = diagram;
        this.descriptionMappings = descriptionMappings;
        this.descriptionMappings.addListener(this);
        this.mappingsTable = new GlobalMappingsTable(descriptionMappings);
    }

    @Override
    public void computeMappings(Collection<Viewpoint> enabledVPs, boolean computeDescriptionMappings) {
        if (computeDescriptionMappings) {
            this.descriptionMappings.computeMappings(enabledVPs);
        }
        this.mappingsTable.build((Collection<Layer>)this.diagram.getActivatedLayers());
    }

    @Override
    public List<NodeMapping> getNodeMappings() {
        if (this.descriptionMappings.isLayerMode()) {
            return this.mappingsTable.getNodeMappings();
        }
        return this.descriptionMappings.getNodeMappings();
    }

    @Override
    public List<ContainerMapping> getContainerMappings() {
        if (this.descriptionMappings.isLayerMode()) {
            return this.mappingsTable.getContainerMappings();
        }
        return this.descriptionMappings.getContainerMappings();
    }

    @Override
    public List<EdgeMapping> getEdgeMappings() {
        if (this.descriptionMappings.isLayerMode()) {
            return this.mappingsTable.getEdgeMappings();
        }
        return this.descriptionMappings.getEdgeMappings();
    }

    @Override
    public List<ContainerMapping> getContainerMappings(DNodeContainer container) {
        return this.getContainerMappings(container, false);
    }

    @Override
    public List<ContainerMapping> getContainerMappings(DNodeContainer container, boolean takeAlsoChildrenOfAllImportedMappings) {
        ArrayList<ContainerMapping> childrenContainerMappings = new ArrayList<ContainerMapping>();
        ContainerMapping containerViewMapping = container.getActualMapping();
        List<ContainerMapping> containerMappings = this.descriptionMappings.getContainerMappings(containerViewMapping);
        if (this.descriptionMappings.isLayerMode()) {
            containerMappings = this.mappingsTable.getContainerMappings(containerMappings);
        }
        childrenContainerMappings.addAll(containerMappings);
        if (takeAlsoChildrenOfAllImportedMappings && containerViewMapping instanceof ContainerMappingImport && !((ContainerMappingImport)containerViewMapping).isHideSubMappings()) {
            DiagramElementMappingQuery diagramElementMappingQuery = new DiagramElementMappingQuery(containerViewMapping);
            for (DiagramElementMapping diagramElementMapping : diagramElementMappingQuery.hierachy()) {
                if (!(diagramElementMapping instanceof ContainerMapping)) continue;
                containerViewMapping = (ContainerMapping)diagramElementMapping;
                containerMappings = this.descriptionMappings.getContainerMappings(containerViewMapping);
                if (this.descriptionMappings.isLayerMode()) {
                    containerMappings = this.mappingsTable.getContainerMappings(containerMappings);
                }
                childrenContainerMappings.addAll(childrenContainerMappings.size(), containerMappings);
                if (containerViewMapping instanceof ContainerMappingImport && ((ContainerMappingImport)containerViewMapping).isHideSubMappings()) break;
            }
        }
        return childrenContainerMappings;
    }

    @Override
    public List<NodeMapping> getNodeMappings(DNodeList container) {
        return this.getNodeMappings(container, false);
    }

    @Override
    public List<NodeMapping> getNodeMappings(DNodeList container, boolean takeAlsoChildrenOfAllImportedMappings) {
        ArrayList<NodeMapping> childrenNodeMappings = new ArrayList<NodeMapping>();
        ContainerMapping containerViewMapping = container.getActualMapping();
        List<NodeMapping> nodeMappings = this.descriptionMappings.getNodeMappings(containerViewMapping);
        if (this.descriptionMappings.isLayerMode()) {
            nodeMappings = this.mappingsTable.getNodeMappings(nodeMappings);
        }
        childrenNodeMappings.addAll(nodeMappings);
        if (takeAlsoChildrenOfAllImportedMappings && containerViewMapping instanceof ContainerMappingImport && !((ContainerMappingImport)containerViewMapping).isHideSubMappings()) {
            DiagramElementMappingQuery diagramElementMappingQuery = new DiagramElementMappingQuery(containerViewMapping);
            for (DiagramElementMapping diagramElementMapping : diagramElementMappingQuery.hierachy()) {
                if (!(diagramElementMapping instanceof ContainerMapping)) continue;
                containerViewMapping = (ContainerMapping)diagramElementMapping;
                nodeMappings = this.descriptionMappings.getNodeMappings(containerViewMapping);
                if (this.descriptionMappings.isLayerMode()) {
                    nodeMappings = this.mappingsTable.getNodeMappings(nodeMappings);
                }
                childrenNodeMappings.addAll(childrenNodeMappings.size(), nodeMappings);
                if (containerViewMapping instanceof ContainerMappingImport && ((ContainerMappingImport)containerViewMapping).isHideSubMappings()) break;
            }
        }
        return childrenNodeMappings;
    }

    @Override
    public List<NodeMapping> getNodeMappings(DNodeContainer container) {
        return this.getNodeMappings(container, false);
    }

    @Override
    public List<NodeMapping> getNodeMappings(DNodeContainer container, boolean takeAlsoChildrenOfAllImportedMappings) {
        ArrayList<NodeMapping> childrenNodeMappings = new ArrayList<NodeMapping>();
        ContainerMapping containerViewMapping = container.getActualMapping();
        List<NodeMapping> nodeMappings = this.descriptionMappings.getNodeMappings(containerViewMapping);
        if (this.descriptionMappings.isLayerMode()) {
            nodeMappings = this.mappingsTable.getNodeMappings(nodeMappings);
        }
        childrenNodeMappings.addAll(nodeMappings);
        if (takeAlsoChildrenOfAllImportedMappings && containerViewMapping instanceof ContainerMappingImport && !((ContainerMappingImport)containerViewMapping).isHideSubMappings()) {
            DiagramElementMappingQuery diagramElementMappingQuery = new DiagramElementMappingQuery(containerViewMapping);
            for (DiagramElementMapping diagramElementMapping : diagramElementMappingQuery.hierachy()) {
                if (!(diagramElementMapping instanceof ContainerMapping)) continue;
                containerViewMapping = (ContainerMapping)diagramElementMapping;
                nodeMappings = this.descriptionMappings.getNodeMappings(containerViewMapping);
                if (this.descriptionMappings.isLayerMode()) {
                    nodeMappings = this.mappingsTable.getNodeMappings(nodeMappings);
                }
                childrenNodeMappings.addAll(childrenNodeMappings.size(), nodeMappings);
                if (containerViewMapping instanceof ContainerMappingImport && ((ContainerMappingImport)containerViewMapping).isHideSubMappings()) break;
            }
        }
        return childrenNodeMappings;
    }

    @Override
    public List<NodeMapping> getBorderedNodeMappings(AbstractDNode node) {
        return this.getBorderedNodeMappings(node, false);
    }

    @Override
    public List<NodeMapping> getBorderedNodeMappings(AbstractDNode node, boolean takeAlsoChildrenOfAllImportedMappings) {
        ArrayList<NodeMapping> childrenBorderedNodeMappings = new ArrayList<NodeMapping>();
        AbstractNodeMapping containerViewMapping = (AbstractNodeMapping)node.getMapping();
        List<NodeMapping> borderNodeMappings = this.descriptionMappings.getBorderedNodeMappings(containerViewMapping);
        if (this.descriptionMappings.isLayerMode()) {
            borderNodeMappings = this.mappingsTable.getBorderedNodeMappings(borderNodeMappings);
        }
        childrenBorderedNodeMappings.addAll(borderNodeMappings);
        if (takeAlsoChildrenOfAllImportedMappings && containerViewMapping instanceof AbstractMappingImport && !((AbstractMappingImport)containerViewMapping).isHideSubMappings()) {
            DiagramElementMappingQuery diagramElementMappingQuery = new DiagramElementMappingQuery(containerViewMapping);
            for (DiagramElementMapping diagramElementMapping : diagramElementMappingQuery.hierachy()) {
                if (!(diagramElementMapping instanceof ContainerMapping)) continue;
                containerViewMapping = (ContainerMapping)diagramElementMapping;
                borderNodeMappings = this.descriptionMappings.getBorderedNodeMappings(containerViewMapping);
                if (this.descriptionMappings.isLayerMode()) {
                    borderNodeMappings = this.mappingsTable.getNodeMappings(borderNodeMappings);
                }
                childrenBorderedNodeMappings.addAll(childrenBorderedNodeMappings.size(), borderNodeMappings);
                if (containerViewMapping instanceof AbstractMappingImport && ((AbstractMappingImport)containerViewMapping).isHideSubMappings()) break;
            }
        }
        return childrenBorderedNodeMappings;
    }

    @Override
    public List<DiagramElementMapping> getOtherImportersMappings() {
        if (this.descriptionMappings.isLayerMode()) {
            return this.mappingsTable.getOtherImportersMappings();
        }
        return Collections.emptyList();
    }

    @Override
    public void mappingsComputed(Collection<Viewpoint> enabledViewpoints) {
        this.computeMappings(enabledViewpoints, false);
    }

    @Override
    public void dispose() {
        DiagramMappingsManagerRegistry.INSTANCE.removeDiagramMappingsManagers(this);
    }

    @Override
    public Collection<Layer> getActiveParentLayers(DiagramElementMapping mapping) {
        return this.mappingsTable.getIndirectParentLayers(mapping);
    }

    @Override
    public <T extends AbstractNodeMapping> void iterate(MappingsListVisitor visitor, DragAndDropTarget container) {
        if (this.descriptionMappings.isLayerMode()) {
            if (container instanceof DDiagram) {
                this.iterateOnMappings(this.getContainerMappings(), visitor);
                this.iterateOnMappings(this.getNodeMappings(), visitor);
            } else if (container instanceof DNodeContainer) {
                this.iterateOnMappings(this.getContainerMappings((DNodeContainer)container), visitor);
                this.iterateOnMappings(this.getNodeMappings((DNodeContainer)container), visitor);
                this.iterateOnMappings(this.getBorderedNodeMappings((DNodeContainer)container), visitor);
            } else if (container instanceof DNodeList) {
                this.iterateOnMappings(this.getNodeMappings((DNodeList)container), visitor);
            } else if (container instanceof DNode) {
                this.iterateOnMappings(this.getBorderedNodeMappings((DNode)container), visitor);
            }
        }
    }

    private void iterateOnMappings(List<? extends DiagramElementMapping> mappings, MappingsListVisitor visitor) {
        HashSet candidateFilter = Sets.newHashSet();
        for (DiagramElementMapping diagramElementMapping : mappings) {
            Set<AbstractDNodeCandidate> candidateElementsProceed = visitor.visit(diagramElementMapping, candidateFilter);
            candidateFilter.addAll(candidateElementsProceed);
        }
    }
}

