/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.tools.api.assist;

import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.editor.properties.sections.common.ModelViewBinding;
import org.eclipse.sirius.editor.tools.internal.assist.TypeAssistant;
import org.eclipse.sirius.editor.tools.internal.assist.TypeContentProposal;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;

public class TypeContentProposalProvider
implements IContentProposalProvider {
    private final TypeAssistant assistant;

    public TypeContentProposalProvider(TypeAssistant assistant) {
        this.assistant = assistant;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        String incompleteText = contents.substring(0, position);
        List<EClassifier> proposals = this.assistant.proposal(incompleteText);
        IContentProposal[] result = new IContentProposal[proposals.size()];
        int i = 0;
        while (i < proposals.size()) {
            TypeContentProposal newProposal = new TypeContentProposal(proposals.get(i), incompleteText);
            result[i] = newProposal;
            ++i;
        }
        return result;
    }

    public static void bindCompletionProcessor(final AbstractPropertySection section, Text text) {
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        TriggerSequence[] contentAssistBindings = bindingService.getActiveBindingsFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        if (contentAssistBindings != null && contentAssistBindings.length > 0) {
            KeyStroke keyStroke = TypeContentProposalProvider.getKeyStroke(contentAssistBindings[0]);
            TypeAssistant typeAssistant = new TypeAssistant(DslCommonPlugin.getDefault().getWorkspaceEPackageRegistry(), section);
            ContentProposalAdapter adapter = new ContentProposalAdapter((Control)text, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new TypeContentProposalProvider(typeAssistant), keyStroke, null);
            adapter.addContentProposalListener(new IContentProposalListener2(){

                public void proposalPopupClosed(ContentProposalAdapter arg0) {
                    if (section instanceof ModelViewBinding) {
                        ((ModelViewBinding)section).enableModelUpdating();
                    }
                }

                public void proposalPopupOpened(ContentProposalAdapter arg0) {
                    if (section instanceof ModelViewBinding) {
                        ((ModelViewBinding)section).disableModelUpdating();
                    }
                }
            });
        }
    }

    private static KeyStroke getKeyStroke(TriggerSequence sequence) {
        Trigger[] triggerArray = sequence.getTriggers();
        int n = triggerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Trigger trigger = triggerArray[n2];
            if (trigger instanceof KeyStroke) {
                return (KeyStroke)trigger;
            }
            ++n2;
        }
        return null;
    }
}

