/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.listeners;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.permission.exception.LockedInstanceException;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.TablePackage;
import org.eclipse.sirius.table.metamodel.table.provider.TableUIPlugin;
import org.eclipse.sirius.table.ui.tools.internal.command.ChangeColumnWidthCommand;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableViewerManager;
import org.eclipse.sirius.table.ui.tools.internal.editor.provider.DTableEditorUtil;
import org.eclipse.sirius.table.ui.tools.internal.editor.utils.TreeColumnWidthQuery;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeColumn;

public class DTableViewerListener
implements ITreeViewerListener,
ControlListener {
    private DTableViewerManager dTableViewerManager;
    private DTable dTable;
    private Session session;
    private TransactionalEditingDomain domain;

    public DTableViewerListener(DTableViewerManager dTableViewerManager, Session session) {
        this.dTableViewerManager = dTableViewerManager;
        this.dTable = (DTable)this.dTableViewerManager.getEditor().getRepresentation();
        this.session = session;
        this.domain = session.getTransactionalEditingDomain();
    }

    public void treeExpanded(TreeExpansionEvent event) {
        DLine dLine;
        if (event.getElement() instanceof DLine && (dLine = (DLine)event.getElement()).isCollapsed()) {
            CommandStack commandStack = this.domain.getCommandStack();
            CompoundCommand expandDLineCmd = new CompoundCommand("Expand " + dLine.getName() + " line");
            expandDLineCmd.append((Command)new SetAccessorRecordingCommand(this.session, event, false));
            commandStack.execute((Command)expandDLineCmd);
        }
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        DLine dLine;
        if (event.getElement() instanceof DLine && !(dLine = (DLine)event.getElement()).isCollapsed()) {
            CommandStack commandStack = this.domain.getCommandStack();
            CompoundCommand expandDTreeItemCmd = new CompoundCommand("Collapse " + dLine.getName() + " line");
            expandDTreeItemCmd.append((Command)new SetAccessorRecordingCommand(this.session, event, true));
            commandStack.execute((Command)expandDTreeItemCmd);
        }
    }

    public void controlMoved(ControlEvent event) {
    }

    public void controlResized(ControlEvent event) {
        if (event.widget instanceof TreeColumn && this.dTableViewerManager.getEditor().isPropertiesUpdateEnabled()) {
            String featureName;
            DColumn objectToModify;
            TreeColumn treeColumn = (TreeColumn)event.widget;
            boolean mustUpdateModel = false;
            TreeColumnWidthQuery treeColumnWidthQuery = new TreeColumnWidthQuery(treeColumn);
            Display.getDefault().syncExec((Runnable)((Object)treeColumnWidthQuery));
            int widgetWidth = (Integer)treeColumnWidthQuery.getResult();
            DColumn dColumn = (DColumn)treeColumn.getData("org.eclipse.sirius.table.ui.dTableColumn");
            if (dColumn != null) {
                boolean bl = mustUpdateModel = dColumn.isVisible() && dColumn.getWidth() != widgetWidth;
                if (DTableViewerManager.IS_GTK_OS && DTableEditorUtil.isLastColumn(treeColumn)) {
                    mustUpdateModel = false;
                }
                objectToModify = dColumn;
                featureName = TablePackage.eINSTANCE.getDColumn_Width().getName();
            } else {
                mustUpdateModel = this.dTable.getHeaderColumnWidth() != widgetWidth;
                objectToModify = this.dTable;
                featureName = TablePackage.eINSTANCE.getDTable_HeaderColumnWidth().getName();
            }
            ModelAccessor modelAccessor = this.session.getModelAccessor();
            TransactionalEditingDomain ted = this.session.getTransactionalEditingDomain();
            if (mustUpdateModel && modelAccessor.getPermissionAuthority().canEditFeature((EObject)objectToModify, featureName) && ((TransactionalEditingDomainImpl)ted).getActiveTransaction() == null) {
                if (widgetWidth == 0) {
                    widgetWidth = 1;
                }
                if (objectToModify instanceof DColumn && widgetWidth != dColumn.getWidth()) {
                    ted.getCommandStack().execute((Command)new ChangeColumnWidthCommand(this.session, widgetWidth, dColumn));
                } else if (this.dTable.getHeaderColumnWidth() != widgetWidth) {
                    ted.getCommandStack().execute((Command)new ChangeColumnWidthCommand(this.session, widgetWidth, this.dTable));
                }
            }
        }
    }

    private static class SetAccessorRecordingCommand
    extends RecordingCommand {
        private Session session;
        private TreeExpansionEvent event;
        private Object value;

        public SetAccessorRecordingCommand(Session session, TreeExpansionEvent event, Object value) {
            super(session.getTransactionalEditingDomain());
            this.session = session;
            this.event = event;
            this.value = value;
        }

        protected void doExecute() {
            try {
                this.session.getModelAccessor().eSet((EObject)((DLine)this.event.getElement()), TablePackage.eINSTANCE.getDLine_Collapsed().getName(), this.value);
            }
            catch (LockedInstanceException e) {
                TableUIPlugin.getPlugin().error("Error while modifying model", (Exception)((Object)e));
            }
            catch (FeatureNotFoundException e) {
                TableUIPlugin.getPlugin().error("Error while modifying model", (Exception)((Object)e));
            }
        }
    }
}

