/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.dialog;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.sirius.tests.swtbot.support.utils.SWTBotUtils;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTableItem;
import org.junit.Assert;

public class ViewpointSelectionDialog {
    public static final String VIEWPOINT_DIALOG_NAME = "Viewpoints Selection";
    private final SWTWorkbenchBot bot;

    public ViewpointSelectionDialog(SWTWorkbenchBot bot) {
        this.bot = bot;
    }

    public void selectViewpoint(Set<String> viewpointToSelect, Set<String> viewpointToDeselect) {
        this.bot.waitUntil(Conditions.shellIsActive((String)VIEWPOINT_DIALOG_NAME));
        SWTBotShell shellViewpointsSelection = this.bot.shell(VIEWPOINT_DIALOG_NAME);
        if (viewpointToSelect != null && viewpointToDeselect != null) {
            Sets.SetView allViewpointNames = Sets.union(viewpointToSelect, viewpointToDeselect);
            HashMap viewpointSelection = Maps.newHashMap();
            for (String vpName : allViewpointNames) {
                viewpointSelection.put(vpName, viewpointToSelect.contains(vpName));
            }
            if (!viewpointSelection.isEmpty()) {
                int rowPosition = 0;
                while (rowPosition < this.bot.table().rowCount()) {
                    SWTBotTableItem item = this.bot.table().getTableItem(rowPosition);
                    String text = item.getText(2);
                    if (viewpointSelection.containsKey(text)) {
                        this.bot.table().click(rowPosition, 0);
                        viewpointSelection.remove(text);
                    }
                    ++rowPosition;
                }
                this.failIfMissingViewpoints(viewpointSelection);
                final SWTBotButton okButton = this.bot.button("OK");
                this.bot.waitUntil((ICondition)new DefaultCondition(){

                    public String getFailureMessage() {
                        return "OK button is not enabled";
                    }

                    public boolean test() throws Exception {
                        return okButton.isEnabled();
                    }
                });
            }
        }
        this.bot.button("OK").click();
        SWTBotUtils.waitProgressMonitorClose("Progress Information");
        this.bot.waitUntil(Conditions.shellCloses((SWTBotShell)shellViewpointsSelection));
        SWTBotUtils.waitProgressMonitorClose("Apply new viewpoints selection");
    }

    private void failIfMissingViewpoints(Map<String, Boolean> remainingViewpoints) {
        StringBuilder message = new StringBuilder();
        for (String vpName : remainingViewpoints.keySet()) {
            message.append("\"");
            message.append(vpName);
            message.append("\" ");
        }
        if (message.length() > 0) {
            message.append(" viewpoint(s) was/were not found");
            Assert.fail((String)message.toString());
        }
    }
}

