/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.business.internal.dialect.common.tree;

import com.google.common.base.Function;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.synchronizer.ChildCreationSupport;
import org.eclipse.sirius.synchronizer.CreatedOutput;
import org.eclipse.sirius.synchronizer.OutputDescriptor;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.DTreeItemContainer;
import org.eclipse.sirius.tree.TreeFactory;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.CreatedTreeItem;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.OutputTreeItemDescriptor;
import org.eclipse.sirius.tree.business.internal.dialect.common.viewpoint.GlobalContext;
import org.eclipse.sirius.tree.description.TreeItemMapping;

class TreeItemContainerChildSupport
implements ChildCreationSupport {
    private DTreeItemContainer container;
    private GlobalContext ctx;

    public TreeItemContainerChildSupport(GlobalContext ctx, DTreeItemContainer container) {
        this.container = container;
        this.ctx = ctx;
    }

    public void reorderChilds(Iterable<CreatedOutput> outDesc) {
        LinkedHashMultiset subMappings = LinkedHashMultiset.create();
        final HashMap outputToItem = Maps.newHashMap();
        for (CreatedOutput createdOutput : outDesc) {
            EObject createdElement = createdOutput.getCreatedElement();
            outputToItem.put(createdElement, createdOutput);
            if (!(createdElement instanceof DTreeItem)) continue;
            subMappings.add((Object)((DTreeItem)createdElement).getActualMapping());
        }
        int startIndex = 0;
        final HashMap startIndexes = Maps.newHashMap();
        for (TreeItemMapping itemMapping : subMappings) {
            startIndexes.put(itemMapping, startIndex);
            startIndex += subMappings.count((Object)itemMapping);
        }
        Function<DTreeItem, Integer> getNewIndex = new Function<DTreeItem, Integer>(){

            public Integer apply(DTreeItem from) {
                CreatedOutput createdOutput;
                int index = outputToItem.size();
                TreeItemMapping itemMapping = from.getActualMapping();
                if (itemMapping != null && startIndexes.containsKey(itemMapping)) {
                    index = (Integer)startIndexes.get(itemMapping);
                }
                if ((createdOutput = (CreatedOutput)outputToItem.get(from)) != null) {
                    return index + createdOutput.getNewIndex();
                }
                return -1;
            }
        };
        ECollections.sort(this.container.getOwnedTreeItems(), (Comparator)Ordering.natural().onResultOf((Function)getNewIndex));
    }

    public void deleteChild(CreatedOutput outDesc) {
        EcoreUtil.delete((EObject)outDesc.getCreatedElement());
    }

    public CreatedOutput createChild(OutputDescriptor outDesc) {
        OutputTreeItemDescriptor descriptor = (OutputTreeItemDescriptor)outDesc;
        DTreeItem line = TreeFactory.eINSTANCE.createDTreeItem();
        line.setActualMapping(descriptor.getMapping().getDescription());
        line.setTarget(outDesc.getSourceElement());
        this.container.getOwnedTreeItems().add((Object)line);
        CreatedTreeItem newOne = new CreatedTreeItem(this.ctx, line, descriptor);
        return newOne;
    }
}

