/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.internal.dialect.editor;

import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.internal.dialect.editor.DialectEditorCloserFilter;
import org.eclipse.swt.widgets.Display;

public class DialectEditorCloser
extends ResourceSetListenerImpl
implements ResourceSetListener {
    private IEditingSession editingSession;
    private DialectEditor dialectEditor;
    private NotificationFilter notificationFilter;

    public DialectEditorCloser(IEditingSession editingSession, DialectEditor dialectEditor) {
        this.dialectEditor = dialectEditor;
        this.editingSession = editingSession;
        this.notificationFilter = new DialectEditorCloserFilter(dialectEditor.getRepresentation());
        TransactionalEditingDomain domain = editingSession.getSession().getTransactionalEditingDomain();
        domain.addResourceSetListener((ResourceSetListener)this);
    }

    public NotificationFilter getFilter() {
        return this.notificationFilter;
    }

    public boolean isPostcommitOnly() {
        return true;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DialectEditorCloser.this.dialectEditor != null) {
                    if (DialectEditorCloser.this.dialectEditor.getSite() != null && DialectEditorCloser.this.dialectEditor.getSite().getShell() != null) {
                        DialectEditorCloser.this.dialectEditor.getDialogFactory().editorWillBeClosedInformationDialog(DialectEditorCloser.this.dialectEditor.getSite().getShell());
                    }
                    DialectUIManager.INSTANCE.closeEditor(DialectEditorCloser.this.dialectEditor, false);
                    DialectEditorCloser.this.editingSession.detachEditor(DialectEditorCloser.this.dialectEditor);
                }
            }
        });
    }

    public void dispose() {
        this.getTarget().removeResourceSetListener((ResourceSetListener)this);
    }
}

