/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.api.views.modelexplorerview.resourcelistener;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.query.FileQuery;
import org.eclipse.sirius.business.api.resource.LoadEMFResource;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.modelingproject.manager.AttachSemanticResourcesJob;
import org.eclipse.sirius.business.internal.modelingproject.manager.DetachSemanticResourcesJob;
import org.eclipse.sirius.business.internal.modelingproject.manager.InitializeModelingProjectJob;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetFactory;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ui.tools.api.views.modelexplorerview.resourcelistener.IModelingProjectResourceListener;
import org.eclipse.sirius.ui.tools.api.views.modelexplorerview.resourcelistener.ResourceDeltaVisitor;
import org.eclipse.sirius.ui.tools.internal.views.common.modelingproject.ModelingProjectFileQuery;
import org.eclipse.sirius.ui.tools.internal.views.common.modelingproject.OpenRepresentationsFileJob;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;

public class DefaultModelingProjectResourceListener
implements IModelingProjectResourceListener {
    @Override
    public void init() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this);
    }

    @Override
    public void dispose() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                ResourceDeltaVisitor visitor = this.getResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                for (IProject projectToInitialize : visitor.projectsToInitialize) {
                    InitializeModelingProjectJob job = new InitializeModelingProjectJob((List)Lists.newArrayList((Object[])new IProject[]{projectToInitialize}));
                    job.setForceInit(true);
                    job.setPriority(20);
                    job.setRule((ISchedulingRule)projectToInitialize);
                    job.schedule();
                }
                if (!visitor.projectsToInitializeAndLoad.isEmpty()) {
                    OpenRepresentationsFileJob.scheduleNewWhenPossible(new ArrayList<ModelingProject>(visitor.projectsToInitializeAndLoad), false);
                }
                if (!visitor.semanticResourcesURIsToAttachPerSession.isEmpty()) {
                    AttachSemanticResourcesJob attachSemanticResourcesJob = new AttachSemanticResourcesJob(new LinkedHashMap<Session, Set<URI>>(visitor.semanticResourcesURIsToAttachPerSession));
                    attachSemanticResourcesJob.schedule();
                    visitor.semanticResourcesURIsToAttachPerSession.clear();
                }
                if (!visitor.semanticResourcesURIsToDetachPerSession.isEmpty()) {
                    DetachSemanticResourcesJob detachSemanticResourcesJob = new DetachSemanticResourcesJob(new LinkedHashMap<Session, Set<URI>>(visitor.semanticResourcesURIsToDetachPerSession));
                    detachSemanticResourcesJob.schedule();
                    visitor.semanticResourcesURIsToDetachPerSession.clear();
                }
            }
            catch (Exception e) {
                SiriusEditPlugin.getPlugin().log(e);
            }
        } else if (2 == event.getType() && event.getResource() instanceof IProject) {
            Option optionalModelingProject = ModelingProject.asModelingProject((IProject)((IProject)event.getResource()));
            optionalModelingProject.some();
        }
    }

    protected ResourceDeltaVisitor getResourceDeltaVisitor() {
        return new ResourceDeltaVisitor(this);
    }

    protected boolean isRepresentationsModel(IFile file) {
        return new FileQuery(file).isSessionResourceFile();
    }

    protected boolean isVsmModel(IFile file) {
        return new FileQuery(file).isVSMFile();
    }

    protected boolean isLoadableModel(IFile file, Session session) {
        if (file == null) {
            return false;
        }
        ResourceSet set = ResourceSetFactory.createFactory().createResourceSet(session.getSessionResource().getURI());
        LoadEMFResource runnable = new LoadEMFResource(set, file);
        runnable.run();
        return runnable.getLoadedResource() != null;
    }

    protected boolean isPotentialSemanticResource(IFile file) {
        return file != null && new ModelingProjectFileQuery(file).isPotentialSemanticResource();
    }
}

