/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.interpreterview;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.CompoundInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IVariableStatusListener;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.common.ui.tools.api.contentassist.ContentInstanceProposalProvider;
import org.eclipse.sirius.ui.tools.api.views.interpreterview.InterpreterView;
import org.eclipse.sirius.ui.tools.internal.views.common.navigator.adapters.ModelDragTargetAdapter;
import org.eclipse.sirius.ui.tools.internal.views.interpreterview.VariableContentProvider;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.part.ViewPart;

public class DesignerInterpreterView
extends ViewPart
implements InterpreterView {
    private static final Transfer TRANSFER = LocalSelectionTransfer.getTransfer();
    ITreeContentProvider contentProvider;
    private String contentAssistBinding = "org.eclipse.ui.edit.text.contentAssist.proposals";
    private String variableTag = "$";
    private Composite top;
    private FormToolkit formToolkit;
    private Section intepreterSection;
    private Section variablesSection;
    private Form interpreterForm;
    private Text acceleoExpression;
    private Tree valuesTree;
    private TreeViewer valuesViewer;
    private Form variablesForm;
    private Button setVariableButton;
    private Button unSetVariableButton;
    private Tree variablesTree;
    private TreeViewer variablesViewer;
    private ILabelProvider labelProvider;
    private Action addDependencyAction;
    private EObject current;
    private final IInterpreter interpreter = CompoundInterpreter.createGenericInterpreter();
    private ContentInstanceProposalProvider contentInstanceProposalProvider;
    private final IVariableStatusListener variableListener = new IVariableStatusListener(){

        public void notifyChanged(Map<?, ?> variables) {
            DesignerInterpreterView.this.refreshVariables(variables);
        }
    };
    private final ISelectionListener listener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                for (Object obj : (IStructuredSelection)selection) {
                    EObject foundEObject = null;
                    if (obj instanceof EObject) {
                        foundEObject = (EObject)obj;
                    }
                    if (foundEObject == null && obj instanceof IAdaptable) {
                        foundEObject = (EObject)((IAdaptable)obj).getAdapter(EObject.class);
                    }
                    if (foundEObject == null) continue;
                    TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)foundEObject);
                    if (DesignerInterpreterView.this.current == null) {
                        DesignerInterpreterView.this.addContentAssist(transactionalEditingDomain);
                    }
                    DesignerInterpreterView.this.current = foundEObject;
                    DesignerInterpreterView.this.contentInstanceProposalProvider.setCurrentEObject(DesignerInterpreterView.this.current);
                    DesignerInterpreterView.this.handleNewExpression();
                    break;
                }
            }
        }
    };
    private Action copyToClipboardAction;

    ITreeContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = new VariableContentProvider(SiriusEditPlugin.getPlugin().getItemProvidersAdapterFactory());
        }
        return this.contentProvider;
    }

    public void createPartControl(Composite parent) {
        this.getSite().getPage().addSelectionListener(this.listener);
        GridData gridData7 = new GridData();
        gridData7.horizontalAlignment = 4;
        gridData7.grabExcessHorizontalSpace = true;
        gridData7.horizontalSpan = 2;
        gridData7.verticalAlignment = 2;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.top = new Composite(parent, 0);
        this.top.setLayout((Layout)gridLayout);
        this.labelProvider = new AdapterFactoryLabelProvider(SiriusEditPlugin.getPlugin().getItemProvidersAdapterFactory());
        this.createIntepreterSection();
        this.createVariablesSection();
        this.createActions();
        this.createToolbarButtons();
        this.interpreter.addVariableStatusListener(this.variableListener);
    }

    public void setFocus() {
        if (this.top != null) {
            this.top.getParent().setFocus();
        }
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener(this.listener);
        if (this.interpreter != null) {
            this.interpreter.removeVariableStatusListener(this.variableListener);
        }
        this.interpreter.dispose();
        this.top.dispose();
        this.formToolkit.dispose();
        this.intepreterSection.dispose();
        this.variablesSection.dispose();
        this.interpreterForm.dispose();
        this.acceleoExpression.dispose();
        this.valuesTree.dispose();
        this.variablesForm.dispose();
        this.setVariableButton.dispose();
        this.unSetVariableButton.dispose();
        this.variablesTree.dispose();
        this.labelProvider.dispose();
    }

    private void createActions() {
        this.addDependencyAction = new Action("Add Dependency"){

            public void run() {
                String dependency;
                InputDialog inputDependency = new InputDialog(DesignerInterpreterView.this.getSite().getShell(), "Add Dependency", "Enter the new dependency to add", "", null);
                inputDependency.setBlockOnOpen(true);
                int result = inputDependency.open();
                if (result == 0 && (dependency = inputDependency.getValue()) != null && !StringUtil.isEmpty((String)dependency)) {
                    ArrayList<String> filePaths = new ArrayList<String>();
                    for (Viewpoint vp : ViewpointRegistry.getInstance().getViewpoints()) {
                        if (vp.eResource() == null) continue;
                        filePaths.add(vp.eResource().getURI().toPlatformString(true));
                    }
                    DesignerInterpreterView.this.interpreter.setProperty((Object)"files", filePaths);
                    DesignerInterpreterView.this.interpreter.addImport(dependency);
                }
            }
        };
        this.copyToClipboardAction = new Action("Copy to Clipboard"){

            public void run() {
                StringBuilder sb = new StringBuilder();
                sb.append("Result of: ").append(DesignerInterpreterView.this.acceleoExpression.getText()).append(" (").append(DesignerInterpreterView.this.valuesTree.getItemCount()).append(" elements)\n\n");
                TreeItem[] treeItemArray = DesignerInterpreterView.this.valuesTree.getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    sb.append("- ").append(item.getText()).append("\n");
                    ++n2;
                }
                Clipboard cb = new Clipboard(DesignerInterpreterView.this.getSite().getShell().getDisplay());
                TextTransfer textTransfer = TextTransfer.getInstance();
                cb.setContents(new Object[]{sb.toString()}, new Transfer[]{textTransfer});
            }
        };
    }

    private void createToolbarButtons() {
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)this.addDependencyAction);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)this.copyToClipboardAction);
    }

    private FormToolkit getFormToolkit() {
        if (this.formToolkit == null) {
            this.formToolkit = new FormToolkit(Display.getCurrent());
        }
        return this.formToolkit;
    }

    private void createIntepreterSection() {
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = 4;
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.grabExcessVerticalSpace = true;
        gridData1.verticalAlignment = 4;
        this.intepreterSection = this.getFormToolkit().createSection(this.top, 0);
        this.createInterpreterForm();
        this.intepreterSection.setLayoutData((Object)gridData1);
        this.intepreterSection.setClient((Control)this.interpreterForm);
    }

    private void createVariablesSection() {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 4;
        gridData.widthHint = 150;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        this.variablesSection = this.getFormToolkit().createSection(this.top, 0);
        this.variablesSection.setExpanded(true);
        this.variablesSection.setText("Variables");
        this.createVariablesForm();
        this.variablesSection.setLayoutData((Object)gridData);
        this.variablesSection.setClient((Control)this.variablesForm);
    }

    private void createInterpreterForm() {
        GridData gridData3 = new GridData();
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.horizontalAlignment = 4;
        gridData3.verticalAlignment = 4;
        gridData3.grabExcessVerticalSpace = true;
        GridData gridData2 = new GridData();
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.verticalAlignment = 2;
        gridData2.horizontalAlignment = 4;
        this.interpreterForm = this.getFormToolkit().createForm((Composite)this.intepreterSection);
        this.getFormToolkit().decorateFormHeading(this.interpreterForm);
        this.interpreterForm.setText("Requests interpreter");
        this.acceleoExpression = this.getFormToolkit().createText(this.interpreterForm.getBody(), null, 2052);
        this.acceleoExpression.setLayoutData((Object)gridData2);
        this.acceleoExpression.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DesignerInterpreterView.this.handleNewExpression();
            }
        });
        this.valuesTree = new Tree(this.interpreterForm.getBody(), 2050);
        this.valuesTree.setLayoutData((Object)gridData3);
        this.valuesViewer = new TreeViewer(this.valuesTree);
        this.interpreterForm.getBody().setLayout((Layout)new GridLayout());
        this.valuesViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.valuesViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.valuesViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    DesignerInterpreterView.this.addVariable(((IStructuredSelection)event.getSelection()).toList());
                }
            }
        });
        Transfer[] transfers = new Transfer[]{TRANSFER};
        this.valuesViewer.addDragSupport(7, transfers, (DragSourceListener)new ModelDragTargetAdapter((ISelectionProvider)this.valuesViewer));
    }

    private void addVariable(List<?> list) {
        InputDialog askSiriusName;
        if (list.size() > 0 && this.interpreter != null && (askSiriusName = new InputDialog(Display.getDefault().getActiveShell(), "Variable name", "Type variable name", "element", new IInputValidator(){

            public String isValid(String newText) {
                return null;
            }
        })).open() == 0) {
            if (list.size() == 1) {
                if (askSiriusName.getValue().startsWith(this.variableTag)) {
                    this.interpreter.setVariable(askSiriusName.getValue().substring(1), list.get(0));
                } else {
                    this.interpreter.setVariable(askSiriusName.getValue(), list.get(0));
                }
            } else if (askSiriusName.getValue().startsWith(this.variableTag)) {
                this.interpreter.setVariable(askSiriusName.getValue().substring(1), list);
            } else {
                this.interpreter.setVariable(askSiriusName.getValue(), list);
            }
        }
    }

    private void refreshVariables(Map<?, ?> variables) {
        this.variablesViewer.setInput(variables);
    }

    private void handleNewExpression() {
        if (this.interpreter != null && this.current != null) {
            try {
                Resource resource;
                ECrossReferenceAdapter crosser = this.retrieveCrosser(this.current);
                if (crosser != null) {
                    this.interpreter.setCrossReferencer(crosser);
                }
                if ((resource = this.current.eResource()) != null) {
                    String path = resource.getURI().toPlatformString(true);
                    this.interpreter.setProperty((Object)"file", (Object)path);
                }
                long now = new Date().getTime();
                Object result = this.interpreter.evaluate(this.current, this.acceleoExpression.getText());
                long ellapseTime = new Date().getTime() - now;
                int numberOfResults = this.handleExpressionResult(result);
                DecimalFormat decimalFormat = new DecimalFormat("###,###,###.###");
                this.interpreterForm.setMessage("Evaluation successful. Number of returned elements : " + numberOfResults + ". Time to evaluate : " + decimalFormat.format((double)ellapseTime / 1000.0) + " second(s)", 1);
            }
            catch (EvaluationException e) {
                this.interpreterForm.setMessage("Invalid expression. " + e.getMessage(), 3);
            }
        }
    }

    private ECrossReferenceAdapter retrieveCrosser(EObject cur) {
        ECrossReferenceAdapter result = null;
        EObject semantic = cur;
        Session sess = null;
        if (cur instanceof DSemanticDecorator) {
            semantic = ((DSemanticDecorator)cur).getTarget();
        }
        if (semantic != null) {
            sess = SessionManager.INSTANCE.getSession(semantic);
        }
        if (sess != null) {
            result = sess.getSemanticCrossReferencer();
        }
        if (result == null) {
            result = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)cur);
        }
        return result;
    }

    private Integer handleExpressionResult(Object result) {
        if (result != null) {
            ArrayList<Object> input;
            if (result instanceof Collection) {
                input = (ArrayList<Object>)result;
            } else {
                input = new ArrayList<Object>(1);
                input.add(result);
            }
            this.valuesViewer.setInput(input);
            return input.size();
        }
        this.valuesViewer.setInput(null);
        return 0;
    }

    private void createVariablesForm() {
        GridData gridData6 = new GridData();
        gridData6.horizontalAlignment = 4;
        gridData6.grabExcessHorizontalSpace = true;
        gridData6.grabExcessVerticalSpace = true;
        gridData6.horizontalSpan = 2;
        gridData6.verticalAlignment = 4;
        gridData6.widthHint = 150;
        GridData gridData5 = new GridData();
        gridData5.horizontalAlignment = 2;
        gridData5.verticalAlignment = 2;
        GridData gridData4 = new GridData();
        gridData4.horizontalAlignment = 2;
        gridData4.verticalAlignment = 2;
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 2;
        gridLayout1.makeColumnsEqualWidth = true;
        this.variablesForm = this.getFormToolkit().createForm((Composite)this.variablesSection);
        this.variablesForm.getBody().setLayout((Layout)gridLayout1);
        this.variablesForm.setText("Variables");
        this.getFormToolkit().decorateFormHeading(this.variablesForm);
        this.setVariableButton = this.getFormToolkit().createButton(this.variablesForm.getBody(), "Set", 8);
        this.setVariableButton.setLayoutData((Object)gridData4);
        this.setVariableButton.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent arg0) {
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseUp(MouseEvent arg0) {
                ISelection selection = DesignerInterpreterView.this.valuesViewer.getSelection();
                if (!selection.isEmpty() && selection instanceof TreeSelection) {
                    TreeSelection treeSelection = (TreeSelection)selection;
                    DesignerInterpreterView.this.addVariable(treeSelection.toList());
                }
            }
        });
        this.unSetVariableButton = this.getFormToolkit().createButton(this.variablesForm.getBody(), "Unset", 8);
        this.unSetVariableButton.setLayoutData((Object)gridData5);
        this.unSetVariableButton.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent arg0) {
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseUp(MouseEvent arg0) {
                ISelection selection = DesignerInterpreterView.this.variablesViewer.getSelection();
                if (!selection.isEmpty() && selection instanceof TreeSelection) {
                    Object[] selections;
                    TreeSelection treeSelection = (TreeSelection)selection;
                    Object[] objectArray = selections = treeSelection.toArray();
                    int n = selections.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        if (object instanceof Map.Entry) {
                            Map.Entry entry = (Map.Entry)object;
                            if (entry.getKey().toString().startsWith(DesignerInterpreterView.this.variableTag)) {
                                DesignerInterpreterView.this.interpreter.unSetVariable(entry.getKey().toString().substring(1));
                            } else {
                                DesignerInterpreterView.this.interpreter.unSetVariable(entry.getKey().toString());
                            }
                        }
                        ++n2;
                    }
                }
            }
        });
        this.variablesTree = this.getFormToolkit().createTree(this.variablesForm.getBody(), 2048);
        this.variablesTree.setLayoutData((Object)gridData6);
        this.variablesViewer = new TreeViewer(this.variablesTree);
        this.variablesViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.variablesViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
    }

    private void addContentAssist(TransactionalEditingDomain transactionalEditingDomain) {
        this.contentInstanceProposalProvider = new ContentInstanceProposalProvider(this.interpreter);
        this.contentInstanceProposalProvider.setEditingDomain((EditingDomain)transactionalEditingDomain);
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        if (bindingService.getActiveBindingsFor(this.contentAssistBinding) != null && bindingService.getActiveBindingsFor(this.contentAssistBinding).length > 0) {
            TriggerSequence sequence = bindingService.getActiveBindingsFor(this.contentAssistBinding)[0];
            KeyStroke keyStroke = this.getKeyStroke(sequence);
            new ContentProposalAdapter((Control)this.acceleoExpression, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)this.contentInstanceProposalProvider, keyStroke, null);
        }
    }

    private KeyStroke getKeyStroke(TriggerSequence sequence) {
        Trigger[] triggerArray = sequence.getTriggers();
        int n = triggerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Trigger trigger = triggerArray[n2];
            if (trigger instanceof KeyStroke) {
                return (KeyStroke)trigger;
            }
            ++n2;
        }
        return null;
    }
}

