/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.query;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.AnnotationEntry;
import org.eclipse.sirius.viewpoint.description.DAnnotation;

public class DRepresentationQuery {
    private DRepresentation representation;

    public DRepresentationQuery(DRepresentation representation) {
        this.representation = representation;
    }

    public Option<AnnotationEntry> getAnnotation(String source, EObject eObject) {
        for (AnnotationEntry annotation : this.representation.getOwnedAnnotationEntries()) {
            if (!source.equals(annotation.getSource()) || !eObject.equals(annotation.getData())) continue;
            return Options.newSome((Object)annotation);
        }
        return Options.newNone();
    }

    public Collection<AnnotationEntry> getAnnotation(String source) {
        ArrayList annotationEntries = Lists.newArrayList();
        for (AnnotationEntry annotation : this.representation.getOwnedAnnotationEntries()) {
            if (!source.equals(annotation.getSource())) continue;
            annotationEntries.add(annotation);
        }
        return annotationEntries;
    }

    public Option<DAnnotation> getDAnnotation(String source, String detail) {
        DAnnotation annotation = this.representation.getDAnnotation(source);
        if (annotation != null && annotation.getDetails().get((Object)detail) != null) {
            return Options.newSome((Object)annotation);
        }
        return Options.newNone();
    }
}

