/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.internal.command.listener;

import com.google.common.collect.Sets;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.sirius.common.tools.api.util.SmartAdapter;
import org.eclipse.sirius.tools.api.command.listener.IChangeListener;
import org.eclipse.sirius.tools.api.command.listener.TriggerOperation;

public final class ChangeListener
extends SmartAdapter
implements IChangeListener {
    private Collection<Object> deletedElements;
    private Collection<Object> modifiedElements;
    private Collection<Object> createdElements;
    private TriggerOperation triggerOperation;
    private int activateRecursiveCount;

    @Override
    public void activate() {
        ++this.activateRecursiveCount;
        if (this.activateRecursiveCount == 1) {
            this.init();
        }
    }

    @Override
    public void deactivate() {
        --this.activateRecursiveCount;
    }

    @Override
    public void launchTriggerOperation() {
        if (this.triggerOperation != null) {
            this.triggerOperation.run(this.createdElements, this.modifiedElements, this.deletedElements);
        }
        this.dispose();
    }

    @Override
    public void setTriggerOperation(TriggerOperation operation) {
        this.triggerOperation = operation;
    }

    public void unsetTriggerOperation() {
        this.triggerOperation = null;
    }

    private void init() {
        this.deletedElements = Sets.newLinkedHashSet();
        this.createdElements = Sets.newLinkedHashSet();
        this.modifiedElements = Sets.newLinkedHashSet();
    }

    private void dispose() {
        this.deletedElements = null;
        this.createdElements = null;
        this.modifiedElements = null;
    }

    public void notifyChanged(Notification notification) {
        if (this.isActivated()) {
            switch (notification.getEventType()) {
                case 1: 
                case 3: 
                case 5: {
                    if (this.isACreation(notification)) {
                        Object newValue = notification.getNewValue();
                        this.createdElements.add(newValue);
                    }
                    this.modifiedElements.add(notification.getNotifier());
                    break;
                }
                case 7: {
                    this.modifiedElements.add(notification.getNotifier());
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    if (this.isADeletion(notification)) {
                        Object oldValue = notification.getOldValue();
                        this.deletedElements.add(oldValue);
                    }
                    this.modifiedElements.add(notification.getNotifier());
                    break;
                }
            }
        }
        super.notifyChanged(notification);
    }

    private boolean isADeletion(Notification notification) {
        boolean isADeletion = false;
        Object f = notification.getFeature();
        if (f instanceof EReference && !((EReference)f).isContainment()) {
            return isADeletion;
        }
        isADeletion = true;
        return isADeletion;
    }

    private boolean isACreation(Notification notification) {
        boolean isACreation = false;
        Object f = notification.getFeature();
        if (f instanceof EReference && !((EReference)f).isContainment()) {
            return isACreation;
        }
        if (notification.getOldValue() == null) {
            Object newValue = notification.getNewValue();
            if (this.deletedElements.contains(newValue)) {
                this.deletedElements.remove(newValue);
                isACreation = false;
            } else {
                isACreation = true;
            }
        }
        return isACreation;
    }

    @Override
    public boolean isActivated() {
        return this.activateRecursiveCount != 0;
    }
}

