/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.internal.util;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.tools.internal.util.CrossReferenceAdapter;

public final class GMFUtil {
    private GMFUtil() {
    }

    public static void tearDownIncomingReferences(EObject destructee) {
        int size;
        Collection inverseReferences;
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getExistingCrossReferenceAdapter((Notifier)destructee);
        if (crossReferencer != null && (inverseReferences = crossReferencer.getInverseReferences(destructee)) != null && (size = inverseReferences.size()) > 0) {
            EStructuralFeature.Setting[] settings = inverseReferences.toArray(new EStructuralFeature.Setting[size]);
            int i = 0;
            while (i < size) {
                EStructuralFeature.Setting setting = settings[i];
                EReference eRef = (EReference)setting.getEStructuralFeature();
                if (eRef.isChangeable() && !eRef.isDerived() && !eRef.isContainment() && !eRef.isContainer()) {
                    EcoreUtil.remove((EObject)setting.getEObject(), (EStructuralFeature)eRef, (Object)destructee);
                }
                ++i;
            }
        }
    }

    public static void tearDownOutgoingReferences(EObject destructee) {
        for (EReference reference : destructee.eClass().getEAllReferences()) {
            boolean changeable;
            boolean bl = changeable = reference.isChangeable() && !reference.isDerived();
            if (!changeable || reference.isContainer() || reference.isContainment() || reference.getEOpposite() != null || !destructee.eIsSet((EStructuralFeature)reference)) continue;
            destructee.eUnset((EStructuralFeature)reference);
        }
    }
}

