/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.internal.interpreter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterProvider;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterStatus;
import org.eclipse.sirius.common.tools.api.interpreter.InterpreterStatusFactory;
import org.eclipse.sirius.common.tools.internal.interpreter.AbstractInterpreter;

public class FeatureInterpreter
extends AbstractInterpreter
implements IInterpreter,
IInterpreterProvider {
    public static final String PREFIX = "feature:";
    public static final String E_CONTAINER_FEATURE_NAME = "eContainer";
    public static final String E_CONTENTS_FEATURE_NAME = "eContents";
    public static final String E_ALL_CONTENTS_FEATURE_NAME = "eAllContents";
    public static final String E_CLASS_FEATURE_NAME = "eClass";
    public static final String E_CROSS_REFERENCES_FEATURE_NAME = "eCrossReferences";
    public static final String[] DEFAULT_FEATURE_NAMES = new String[]{"eContainer", "eContents", "eAllContents", "eClass", "eCrossReferences"};

    @Override
    public IInterpreter createInterpreter() {
        return new FeatureInterpreter();
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public Object evaluate(EObject target, String expression) throws EvaluationException {
        Object result = null;
        if (target != null && expression != null && expression.startsWith(PREFIX)) {
            String featureName = expression.trim().substring(PREFIX.length());
            EStructuralFeature feature = target.eClass().getEStructuralFeature(featureName);
            if (feature != null) {
                result = target.eGet(feature);
            } else if (E_CONTAINER_FEATURE_NAME.equals(featureName)) {
                result = target.eContainer();
            } else if (E_CONTENTS_FEATURE_NAME.equals(featureName)) {
                result = target.eContents();
            } else if (E_ALL_CONTENTS_FEATURE_NAME.equals(featureName)) {
                result = Lists.newArrayList((Iterator)target.eAllContents());
            } else if (E_CLASS_FEATURE_NAME.equals(featureName)) {
                result = target.eClass();
            } else if (E_CROSS_REFERENCES_FEATURE_NAME.equals(featureName)) {
                result = target.eCrossReferences();
            } else {
                throw new EvaluationException("Unknown feature name " + featureName + ".");
            }
        }
        return result;
    }

    @Override
    public boolean supportsValidation() {
        return true;
    }

    @Override
    public Collection<IInterpreterStatus> validateExpression(IInterpreterContext context, String expression) {
        ArrayList<IInterpreterStatus> interpreterStatus = new ArrayList<IInterpreterStatus>();
        if (expression != null && context != null && expression.startsWith(PREFIX)) {
            String featureName = expression.substring(PREFIX.length());
            EClass currentElementType = this.getCurrentElementType(context);
            if (currentElementType != null && !this.hasFeatureName(currentElementType, featureName) && !this.isDefaultFeatureName(featureName)) {
                interpreterStatus.add(InterpreterStatusFactory.createInterpreterStatus(context, "error", "The current element " + currentElementType.getEPackage().getName() + "::" + currentElementType.getName() + " does not have the feature named : " + featureName));
            }
        }
        return interpreterStatus;
    }

    private boolean hasFeatureName(EClass currentElementType, String featureName) {
        boolean hasFeatureName = currentElementType.getEStructuralFeature(featureName) != null;
        return hasFeatureName;
    }

    private boolean isDefaultFeatureName(String featureName) {
        boolean isDefaultFeatureName = false;
        String[] stringArray = DEFAULT_FEATURE_NAMES;
        int n = DEFAULT_FEATURE_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String defaultFeatureName = stringArray[n2];
            if (defaultFeatureName.equals(featureName)) {
                isDefaultFeatureName = true;
                break;
            }
            ++n2;
        }
        return isDefaultFeatureName;
    }

    public EClass getCurrentElementType(IInterpreterContext interpreterContext) {
        EClass currentElementType;
        block4: {
            currentElementType = null;
            Collection<String> targetTypes = interpreterContext.getTargetTypes();
            if (targetTypes.isEmpty()) break block4;
            String targetType = targetTypes.iterator().next();
            Collection<EPackage> availableEPackages = interpreterContext.getAvailableEPackages();
            if (targetType != null && targetType.contains(".")) {
                for (EPackage availableEPackage : availableEPackages) {
                    String eClassName;
                    EClassifier eClassifier;
                    if (availableEPackage.getName() == null || !targetType.startsWith(String.valueOf(availableEPackage.getName()) + ".") || !((eClassifier = availableEPackage.getEClassifier(eClassName = targetType.substring(targetType.indexOf(".") + 1))) instanceof EClass)) continue;
                    currentElementType = (EClass)eClassifier;
                    break;
                }
            } else {
                for (EPackage availableEPackage : availableEPackages) {
                    EClassifier eClassifier = availableEPackage.getEClassifier(targetType);
                    if (!(eClassifier instanceof EClass)) continue;
                    currentElementType = (EClass)eClassifier;
                    break;
                }
            }
        }
        return currentElementType;
    }
}

