/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.experimental.sync;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.api.util.RefreshIDFactory;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMappingImport;
import org.eclipse.sirius.diagram.description.NodeMappingImport;
import org.eclipse.sirius.viewpoint.description.AbstractMappingImport;

public class AbstractDNodeCandidate {
    private DragAndDropTarget viewContainer;
    private EObject semantic;
    private AbstractNodeMapping mapping;
    private AbstractNodeMapping rootMapping;
    private AbstractDNode element;

    public AbstractDNodeCandidate(AbstractNodeMapping mapping, EObject semanticElement, DragAndDropTarget viewContainer) {
        this.mapping = mapping;
        this.semantic = semanticElement;
        this.viewContainer = viewContainer;
        this.rootMapping = this.getRootMapping(mapping);
    }

    public AbstractDNodeCandidate(AbstractDNode diagElement) {
        this.mapping = (AbstractNodeMapping)diagElement.getMapping();
        this.semantic = diagElement.getTarget();
        this.viewContainer = (DragAndDropTarget)diagElement.eContainer();
        this.element = diagElement;
        this.rootMapping = this.getRootMapping(this.mapping);
    }

    public boolean comesFromDiagramElement() {
        return this.getOriginalElement() != null;
    }

    public AbstractDNode getOriginalElement() {
        return this.element;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.rootMapping == null ? 0 : this.rootMapping.hashCode());
        result = 31 * result + (this.semantic == null ? 0 : this.getSemanticID().hashCode());
        result = 31 * result + (this.viewContainer == null ? 0 : this.getViewContainerID().hashCode());
        return result;
    }

    private Id getViewContainerID() {
        if (this.semantic == null) {
            return Id.invalid();
        }
        return new Id(RefreshIDFactory.getOrCreateID((EObject)this.viewContainer));
    }

    private Id getSemanticID() {
        if (this.semantic == null) {
            return Id.invalid();
        }
        return new Id(RefreshIDFactory.getOrCreateID((EObject)this.semantic));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractDNodeCandidate)) {
            return false;
        }
        AbstractDNodeCandidate other = (AbstractDNodeCandidate)obj;
        if (this.rootMapping == null ? other.rootMapping != null : !this.rootMapping.equals(other.rootMapping)) {
            return false;
        }
        if (this.semantic == null ? other.semantic != null : !this.getSemanticID().equals(other.getSemanticID())) {
            return false;
        }
        return !(this.viewContainer == null ? other.viewContainer != null : !this.getViewContainerID().equals(other.getViewContainerID()));
    }

    public AbstractNodeMapping getMapping() {
        return this.mapping;
    }

    public EObject getSemantic() {
        return this.semantic;
    }

    public DragAndDropTarget getViewContainer() {
        return this.viewContainer;
    }

    private AbstractNodeMapping getRootMapping(AbstractNodeMapping mappingImport) {
        if (mappingImport == null) {
            return null;
        }
        AbstractNodeMapping result = mappingImport;
        while (result instanceof AbstractMappingImport) {
            if (result instanceof ContainerMappingImport) {
                result = ((ContainerMappingImport)result).getImportedMapping();
                continue;
            }
            if (!(result instanceof NodeMappingImport)) continue;
            result = ((NodeMappingImport)result).getImportedMapping();
        }
        return result;
    }

    private static final class Id {
        private Integer value;

        public Id(Integer value) {
            this.value = value;
        }

        private static Id invalid() {
            return new Id(-1);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Id)) {
                return false;
            }
            Id other = (Id)obj;
            return this.value.equals(other.value);
        }
    }
}

