/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.api.tools;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.tests.support.api.TestsUtil;
import org.eclipse.sirius.tests.unit.common.TreeCommonTest;
import org.eclipse.sirius.tests.unit.common.TreeEcoreModeler;
import org.eclipse.sirius.tests.unit.diagram.modeler.ecore.EcoreModeler;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.DTreeElement;
import org.eclipse.sirius.tree.description.DescriptionFactory;
import org.eclipse.sirius.tree.description.TreeDescription;
import org.eclipse.sirius.tree.description.TreeItemDeletionTool;
import org.eclipse.sirius.tree.description.TreeItemMapping;
import org.eclipse.sirius.tree.ui.business.api.helper.TreeUIHelper;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTreeEditor;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorPart;
import org.junit.Assert;

public class TreeItemDeletionToolsTest
extends TreeCommonTest
implements EcoreModeler,
TreeEcoreModeler {
    private static final String REQUEST = "<%getRootContainer().eAllContents(\"EClass\")[name==\"EClass1\"].nSize()%>";
    private AbstractDTreeEditor treeEditor;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.initViewpoint("Design");
        TestsUtil.synchronizationWithUIThread();
    }

    public void testCreateDeletionTools() throws Exception {
        TreeDescription treeDescription = this.find("Tree");
        Assert.assertNotNull((String)"The unit test data seems incorrect", (Object)treeDescription);
        Assert.assertEquals((String)"The unit test data seems incorrect", (long)3L, (long)treeDescription.getSubItemMappings().size());
        final TreeItemMapping treeItemMapping = (TreeItemMapping)treeDescription.getSubItemMappings().get(0);
        Assert.assertTrue((boolean)treeItemMapping.getName().equals("Package"));
        Assert.assertNull((String)"The unit test data seems incorrect", (Object)treeItemMapping.getDelete());
        final TreeItemDeletionTool treeItemDeletionTool = DescriptionFactory.eINSTANCE.createTreeItemDeletionTool();
        this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(this.session.getTransactionalEditingDomain()){

            protected void doExecute() {
                treeItemMapping.setDelete(treeItemDeletionTool);
            }
        });
        Assert.assertNotNull((String)"The setting of the delete tool failed.", (Object)treeItemMapping.getDelete());
    }

    public void testDeleteUndo() {
        DTree newTree = (DTree)this.getRepresentations("Tree").toArray()[0];
        TreeDescription desc = newTree.getDescription();
        DTreeElement treeElement = (DTreeElement)newTree.getOwnedTreeItems().get(3);
        IEditorPart openedEditor = DialectUIManager.INSTANCE.openEditor(this.session, (DRepresentation)newTree, (IProgressMonitor)new NullProgressMonitor());
        TestsUtil.synchronizationWithUIThread();
        this.treeEditor = (AbstractDTreeEditor)openedEditor;
        Tree tree = this.treeEditor.getTableViewer().getTreeViewer().getTree();
        String currentHtml = TreeUIHelper.toContentHTMl((Tree)tree);
        Assert.assertEquals((String)"The editor has not the good number element", (Object)TreeItemDeletionToolsTest.getModelHtml(), (Object)currentHtml);
        int instanceCount = -1;
        Assert.assertNotNull((String)"Unit test data is not correct", (Object)desc);
        Assert.assertEquals((String)"We have 9 elements in ecore model, so we should have 9 elements in tree.", (long)8L, (long)newTree.getOwnedTreeItems().size());
        try {
            instanceCount = this.interpreter.evaluateInteger(this.semanticModel, REQUEST);
            Assert.assertEquals((String)"Wrong count of element having the wanted value.", (long)1L, (long)instanceCount);
            this.applyDeletionTool(treeElement);
            TestsUtil.synchronizationWithUIThread();
            instanceCount = this.interpreter.evaluateInteger(this.semanticModel, REQUEST);
            Assert.assertEquals((String)"Wrong count of elementhaving the wanted value.", (long)0L, (long)instanceCount);
            Assert.assertEquals((String)"We have 8 elements in ecore model, so we should have 8 elements in tree.", (long)7L, (long)newTree.getOwnedTreeItems().size());
            currentHtml = TreeUIHelper.toContentHTMl((Tree)tree);
            Assert.assertEquals((String)"The delete is not effetive in editor", (Object)TreeItemDeletionToolsTest.getModelHtmlAfterDelete(), (Object)currentHtml);
            this.applyUndo();
            TestsUtil.synchronizationWithUIThread();
            Assert.assertEquals((String)"We have 9 elements in ecore model, so we should have 9 elements in tree.", (long)8L, (long)newTree.getOwnedTreeItems().size());
            instanceCount = this.interpreter.evaluateInteger(this.semanticModel, REQUEST);
            Assert.assertEquals((String)"Wrong count of element having the wanted value.", (long)1L, (long)instanceCount);
            currentHtml = TreeUIHelper.toContentHTMl((Tree)tree);
            Assert.assertEquals((String)"The undo is not effetive visually", (Object)TreeItemDeletionToolsTest.getModelHtml(), (Object)currentHtml);
            this.applyRedo();
            TestsUtil.synchronizationWithUIThread();
            instanceCount = this.interpreter.evaluateInteger(this.semanticModel, REQUEST);
            Assert.assertEquals((String)"Wrong count of elementhaving the wanted value.", (long)0L, (long)instanceCount);
            Assert.assertEquals((String)"We have 8 elements in ecore model, so we should have 8 elements in tree.", (long)7L, (long)newTree.getOwnedTreeItems().size());
            currentHtml = TreeUIHelper.toContentHTMl((Tree)tree);
            Assert.assertEquals((String)"The delete is not effetive in editor", (Object)TreeItemDeletionToolsTest.getModelHtmlAfterDelete(), (Object)currentHtml);
        }
        catch (EvaluationException e) {
            e.printStackTrace();
        }
    }

    private static String getModelHtml() {
        ArrayList expected = new ArrayList();
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("Package 1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 1 P1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 1 P1 Categorie"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 2 P2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 2 P2 Categorie"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("sous package 1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 1 P11"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 2 P12"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("Package 2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 1 P2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 1 P2 Categorie"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("Package 3"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 1 P3"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 1 P3 Categorie"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass1 Categorie"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("myAttribute"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("myAttribute2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass2 Categorie"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 3"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 3 Categorie"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("Enum"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("Enum2"));
        return TreeUIHelper.toHTML(expected);
    }

    private static String getModelHtmlAfterDelete() {
        ArrayList expected = new ArrayList();
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("Package 1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 1 P1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 1 P1 Categorie"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 2 P2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 2 P2 Categorie"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("sous package 1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 1 P11"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 2 P12"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("Package 2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 1 P2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 1 P2 Categorie"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("Package 3"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 1 P3"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 1 P3 Categorie"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass2 Categorie"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 3"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("EClass 3 Categorie"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("Enum"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("Enum2"));
        return TreeUIHelper.toHTML(expected);
    }

    @Override
    protected void tearDown() throws Exception {
        DialectUIManager.INSTANCE.closeEditor((IEditorPart)this.treeEditor, false);
        TestsUtil.synchronizationWithUIThread();
        this.treeEditor = null;
        super.tearDown();
    }
}

