/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.api.tools;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.tests.support.api.TestsUtil;
import org.eclipse.sirius.tests.support.api.TreeTestCase;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.DTreeElement;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.description.TreeDescription;
import org.eclipse.sirius.tree.description.TreeItemMapping;
import org.eclipse.sirius.tree.description.TreePopupMenu;
import org.eclipse.sirius.tree.ui.business.api.helper.TreeUIHelper;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTreeEditor;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.tool.OperationAction;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorPart;
import org.junit.Assert;

public class TreeItemRefreshWithToolsTest
extends TreeTestCase {
    protected static final int ELEMENTS_NUMBER_IN_TREE = 3;
    private static final String SEMANTIC_MODEL_PATH = "/org.eclipse.sirius.tests.junit/data/tree/unit/refreshtools/test.ecore";
    private static final String MODELER_PATH = "/org.eclipse.sirius.tests.junit/data/tree/unit/refreshtools/test.odesign";
    private static final String SESSION_PATH = "/org.eclipse.sirius.tests.junit/data/tree/unit/refreshtools/representations.aird";
    private static final String REQUEST = "<%getRootContainer().eAllContents(\"EClass\")[name==\"NewEClass1\"].nSize()%>";
    private static final String REPRESENTATION_NAME = "tree";
    private static Tree tree;
    private AbstractDTreeEditor treeEditor;
    private DTree dTree;
    private TreeDescription desc;
    private DTreeElement treeElement;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.genericSetUp(SEMANTIC_MODEL_PATH, MODELER_PATH, SESSION_PATH);
        this.dTree = (DTree)this.getRepresentations(REPRESENTATION_NAME).toArray()[0];
        this.desc = this.dTree.getDescription();
        this.treeElement = (DTreeElement)this.dTree.getOwnedTreeItems().get(0);
        IEditorPart openedEditor = DialectUIManager.INSTANCE.openEditor(this.session, (DRepresentation)this.dTree, (IProgressMonitor)new NullProgressMonitor());
        TestsUtil.synchronizationWithUIThread();
        this.treeEditor = (AbstractDTreeEditor)openedEditor;
        tree = this.treeEditor.getTableViewer().getTreeViewer().getTree();
    }

    public void testDeleteFromTool() {
        this.checkInitialization();
        try {
            this.applyDeletionTool(this.treeElement);
            TestsUtil.synchronizationWithUIThread();
            int instanceCount = this.interpreter.evaluateInteger(this.semanticModel, REQUEST);
            Assert.assertEquals((String)"Wrong count of element having the wanted value.", (long)0L, (long)instanceCount);
            int expected = 2;
            Assert.assertEquals((String)("We have " + expected + " elements in ecore model, so we should have " + expected + " elements in tree."), (long)expected, (long)this.dTree.getOwnedTreeItems().size());
            Assert.assertEquals((String)"The delete is not effetive in editor", (Object)TreeItemRefreshWithToolsTest.getModelHtmlAfterDelete(), (Object)TreeItemRefreshWithToolsTest.getCurrentHtml());
        }
        catch (EvaluationException evaluationException) {
            TreeItemRefreshWithToolsTest.fail((String)"Error in the request <%getRootContainer().eAllContents(\"EClass\")[name==\"NewEClass1\"].nSize()%>");
        }
    }

    public void testEditTool() {
        this.checkInitialization();
        EClass class1 = (EClass)((EPackage)this.dTree.getTarget()).getEClassifier("NewEClass1");
        DTreeItem treeItem = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.dTree, (EObject)class1);
        this.applyDirectEditTool(this.dTree, treeItem, "NewEClass1Rename");
        TestsUtil.synchronizationWithUIThread();
        Assert.assertEquals((String)"The rename is not effetive in editor", (Object)TreeItemRefreshWithToolsTest.getModelHtmlAfterRename(), (Object)TreeItemRefreshWithToolsTest.getCurrentHtml());
    }

    public void testToolCreateSiblingClass() {
        this.checkInitialization();
        Assert.assertEquals((String)"No creation tool named Create Sibling Class is defined on the tree representation.", (Object)"Create Sibling Class", (Object)((OperationAction)((TreePopupMenu)((TreeItemMapping)this.desc.getSubItemMappings().get(0)).getPopupMenus().get(0)).getMenuItemDescriptions().get(0)).getName());
        OperationAction operationAction = (OperationAction)((TreePopupMenu)((TreeItemMapping)this.desc.getSubItemMappings().get(0)).getPopupMenus().get(0)).getMenuItemDescriptions().get(0);
        EClass class1 = (EClass)((EPackage)this.dTree.getTarget()).getEClassifier("NewEClass1");
        DTreeItem treeItem = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.dTree, (EObject)class1);
        this.applyOperationAction(operationAction, treeItem);
        TestsUtil.synchronizationWithUIThread();
        int expected = 4;
        Assert.assertEquals((String)("We have " + expected + " elements in ecore model, so we should have " + expected + " elements in tree."), (long)expected, (long)this.dTree.getOwnedTreeItems().size());
        Assert.assertEquals((String)"The creation is not effetive in editor", (Object)TreeItemRefreshWithToolsTest.getModelHtmlAfterOperationAction(), (Object)TreeItemRefreshWithToolsTest.getCurrentHtml());
    }

    private void checkInitialization() {
        try {
            String currentHtml = TreeUIHelper.toContentHTMl((Tree)tree);
            Assert.assertEquals((String)"The editor has not the good number element", (Object)TreeItemRefreshWithToolsTest.getModelHtml(), (Object)currentHtml);
            Assert.assertNotNull((String)"Unit test data is not correct", (Object)this.desc);
            Assert.assertEquals((String)"We have 3 elements in ecore model, so we should have 3 elements in tree.", (long)3L, (long)this.dTree.getOwnedTreeItems().size());
            int instanceCount = this.interpreter.evaluateInteger(this.semanticModel, REQUEST);
            Assert.assertEquals((String)"Wrong count of element having the wanted value.", (long)1L, (long)instanceCount);
        }
        catch (EvaluationException evaluationException) {
            TreeItemRefreshWithToolsTest.fail((String)"Error in the request <%getRootContainer().eAllContents(\"EClass\")[name==\"NewEClass1\"].nSize()%>");
        }
    }

    private static String getCurrentHtml() {
        return TreeUIHelper.toContentHTMl((Tree)tree);
    }

    private static String getModelHtml() {
        ArrayList expected = new ArrayList();
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("NewEClass1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("NewEClass2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("NewEClass3"));
        return TreeUIHelper.toHTML(expected);
    }

    private static String getModelHtmlAfterDelete() {
        ArrayList expected = new ArrayList();
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("NewEClass2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("NewEClass3"));
        return TreeUIHelper.toHTML(expected);
    }

    private static String getModelHtmlAfterRename() {
        ArrayList expected = new ArrayList();
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("NewEClass1Rename"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("NewEClass2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("NewEClass3"));
        return TreeUIHelper.toHTML(expected);
    }

    private static String getModelHtmlAfterOperationAction() {
        ArrayList expected = new ArrayList();
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("NewEClass1"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("NewEClass2"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf("NewEClass3"));
        TreeUIHelper.addLineToTree(expected, (String)String.valueOf(""));
        return TreeUIHelper.toHTML(expected);
    }

    @Override
    protected void tearDown() throws Exception {
        DialectUIManager.INSTANCE.closeEditor((IEditorPart)this.treeEditor, false);
        TestsUtil.synchronizationWithUIThread();
        this.treeEditor = null;
        super.tearDown();
    }
}

