/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.resource;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.sirius.common.tools.DslCommonPlugin;

public class ResourceSetFactory {
    private static final String FACTORY_EXTENSION_POINT = "org.eclipse.sirius.common.resourceSetFactory";
    private static final String CLASS_ATTRIBUTE = "class";

    protected ResourceSetFactory() {
    }

    public static ResourceSetFactory createFactory() {
        ResourceSetFactory result = null;
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = Platform.getExtensionRegistry().getExtensionPoint(FACTORY_EXTENSION_POINT).getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    try {
                        ResourceSetFactory contributed = (ResourceSetFactory)configElement.createExecutableExtension(CLASS_ATTRIBUTE);
                        if (result == null) {
                            result = contributed;
                        } else {
                            Status status = new Status(2, "org.eclipse.sirius.common", "Several overrides are contributed for the resource factory,  " + configElement.getAttribute(CLASS_ATTRIBUTE) + " will be ignored");
                            DslCommonPlugin.getDefault().getLog().log((IStatus)status);
                        }
                    }
                    catch (CoreException e) {
                        DslCommonPlugin.getDefault().error("Impossible to create the resource factory " + configElement.getAttribute(CLASS_ATTRIBUTE), e);
                    }
                    catch (ClassCastException e) {
                        DslCommonPlugin.getDefault().error("Impossible to create the resource factory " + configElement.getAttribute(CLASS_ATTRIBUTE), e);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        if (result == null) {
            result = new ResourceSetFactory();
        }
        return result;
    }

    public ResourceSet createResourceSet(URI resourceURI) {
        return new ResourceSetImpl();
    }
}

