/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.internal.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterProvider;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterStatus;
import org.eclipse.sirius.common.tools.api.interpreter.InterpreterStatusFactory;
import org.eclipse.sirius.common.tools.api.interpreter.VariableManager;
import org.eclipse.sirius.common.tools.internal.interpreter.AbstractInterpreter;

public class VariableInterpreter
extends AbstractInterpreter
implements IInterpreter,
IInterpreterProvider {
    public static final String PREFIX = "var:";
    public static final String SELF_VARIABLE_NAME = "self";
    private final VariableManager variablesManager = new VariableManager();

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public void setVariable(String name, Object value) {
        this.variablesManager.setVariable(name, value);
    }

    @Override
    public void unSetVariable(String name) {
        this.variablesManager.unSetVariable(name);
    }

    @Override
    public Object getVariable(String name) {
        return this.variablesManager.getVariable(name);
    }

    @Override
    public void clearVariables() {
        this.variablesManager.clearVariables();
    }

    public Map<String, Object> getVariables() {
        return this.variablesManager.getVariables();
    }

    @Override
    public Object evaluate(EObject target, String expression) throws EvaluationException {
        Object result = null;
        if (target != null && expression != null && expression.startsWith(PREFIX)) {
            String variableName = expression.trim().substring(PREFIX.length());
            result = this.evaluateVariable(target, variableName);
        }
        return result;
    }

    protected Object evaluateVariable(EObject target, String variableName) throws EvaluationException {
        Object result = null;
        if (target != null && variableName != null) {
            if (SELF_VARIABLE_NAME.equals(variableName)) {
                result = target;
            } else if (this.variablesManager.getVariables().containsKey(variableName)) {
                result = this.variablesManager.getVariable(variableName);
            } else {
                throw new EvaluationException("Unknown variable \"" + variableName + "\".");
            }
        }
        return result;
    }

    @Override
    public IInterpreter createInterpreter() {
        return new VariableInterpreter();
    }

    @Override
    public boolean supportsValidation() {
        return true;
    }

    @Override
    public Collection<IInterpreterStatus> validateExpression(IInterpreterContext context, String expression) {
        ArrayList<IInterpreterStatus> interpreterStatus = new ArrayList<IInterpreterStatus>();
        if (expression != null && context != null && expression.startsWith(PREFIX)) {
            String variableName = expression.substring(PREFIX.length());
            if (!context.getVariables().containsKey(variableName) && !SELF_VARIABLE_NAME.equals(variableName)) {
                interpreterStatus.add(InterpreterStatusFactory.createInterpreterStatus(context, "error", "The current context does not contains variable named : " + variableName));
            }
        }
        return interpreterStatus;
    }
}

