/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.refresh;

import com.google.common.base.Predicate;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.EndOfLife;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.util.BendpointsHelper;
import org.eclipse.sirius.diagram.ui.tools.internal.util.NotificationQuery;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class RefreshLayoutScope
implements Predicate<Notification> {
    private final Predicate<Notification> isLayoutConstraintNotationChange = new Predicate<Notification>(){
        Object[] features = new Object[]{NotationPackage.eINSTANCE.getRelativeBendpoints_Points(), NotationPackage.eINSTANCE.getLocation_Y(), NotationPackage.eINSTANCE.getLocation_X(), NotationPackage.eINSTANCE.getSize_Width(), NotationPackage.eINSTANCE.getSize_Height()};

        public boolean apply(Notification input) {
            NotificationQuery nq = new NotificationQuery(input);
            return nq.isNotationChange() && this.isLayout(input.getFeature()) && !input.isTouch();
        }

        private boolean isLayout(Object feature) {
            Object[] objectArray = this.features;
            int n = this.features.length;
            int n2 = 0;
            while (n2 < n) {
                Object feature2 = objectArray[n2];
                if (feature == feature2) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    };
    private final Predicate<Notification> isSructuralNotationChange = new Predicate<Notification>(){
        int[] types = new int[]{3, 5, 7, 4, 6};

        public boolean apply(Notification input) {
            NotificationQuery nq = new NotificationQuery(input);
            return nq.isNotationChange() && this.isStructural(input.getEventType());
        }

        private boolean isStructural(int eventType) {
            int[] nArray = this.types;
            int n = this.types.length;
            int n2 = 0;
            while (n2 < n) {
                int type = nArray[n2];
                if (eventType == type) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    };

    public boolean apply(Notification input) {
        return this.needsLayout(input);
    }

    private boolean needsLayout(Notification notification) {
        return !this.isLayoutTouch(notification) && (this.containsStructuralNotationChanges(notification) || this.containsLayoutConstraintNotationChanges(notification) || this.containsSetWkpImgApplication(notification));
    }

    private boolean containsLayoutConstraintNotationChanges(Notification notification) {
        return this.isLayoutConstraintNotationChange.apply((Object)notification);
    }

    private boolean containsStructuralNotationChanges(Notification notification) {
        return this.isSructuralNotationChange.apply((Object)notification);
    }

    private boolean isLayoutTouch(Notification notification) {
        boolean result = true;
        boolean isTouch = notification.isTouch();
        if (!isTouch && NotationPackage.eINSTANCE.getRelativeBendpoints_Points().equals(notification.getFeature())) {
            isTouch = BendpointsHelper.areSameBendpoints(notification.getOldValue(), notification.getNewValue());
        }
        if (!isTouch) {
            result = false;
        }
        return result;
    }

    private boolean containsSetWkpImgApplication(Notification notification) {
        boolean newStyle = false;
        boolean wkpImageCustomization = false;
        boolean wkpImageDeCustomization = false;
        if (notification.getEventType() == 1 && DiagramPackage.eINSTANCE.getDNode_OwnedStyle().equals(notification.getFeature()) && this.hasSequenceMapping(notification.getNotifier())) {
            newStyle = true;
        } else if (ViewpointPackage.eINSTANCE.getCustomizable_CustomFeatures().equals(notification.getFeature()) && notification.getNotifier() instanceof WorkspaceImage) {
            WorkspaceImage workspaceImage = (WorkspaceImage)notification.getNotifier();
            wkpImageCustomization = !workspaceImage.getCustomFeatures().isEmpty();
            boolean bl = wkpImageDeCustomization = !wkpImageCustomization;
        }
        return newStyle && (wkpImageCustomization || wkpImageDeCustomization);
    }

    private boolean hasSequenceMapping(Object notifier) {
        if (notifier instanceof DDiagramElement) {
            DDiagramElement dde = (DDiagramElement)notifier;
            return AbstractNodeEvent.viewpointElementPredicate().apply((Object)dde) || EndOfLife.viewpointElementPredicate().apply((Object)dde) || InstanceRole.viewpointElementPredicate().apply((Object)dde);
        }
        return false;
    }
}

