/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.operation;

import java.util.List;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;

public class ShiftDirectBorderedNodesOperation
extends AbstractModelChangeOperation<Void> {
    private final int direction;
    private final int delta;
    private final List<Node> children;

    public ShiftDirectBorderedNodesOperation(List<Node> children, int delta, int direction) {
        super("Shift bordered nodes' positions by " + delta);
        this.children = children;
        this.delta = delta;
        this.direction = direction;
    }

    @Override
    public Void execute() {
        for (Node child : this.children) {
            LayoutConstraint layoutConstraint = child.getLayoutConstraint();
            if (!(layoutConstraint instanceof Location) || this.delta == 0) continue;
            Location location = (Location)layoutConstraint;
            if (64 == this.direction) {
                location.setX(location.getX() + this.delta);
                continue;
            }
            location.setY(location.getY() + this.delta);
        }
        return null;
    }
}

