/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.api.part;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.util.Proxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.diagram.ui.internal.tools.RubberbandDragTracker;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.FlatContainerStyle;
import org.eclipse.sirius.diagram.ShapeContainerStyle;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.business.internal.query.DNodeContainerExperimentalQuery;
import org.eclipse.sirius.diagram.description.style.FlatContainerStyleDescription;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.business.internal.query.DNodeContainerQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramElementContainerEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramContainerEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.CommonEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramContainerEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.PortLayoutHelper;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.ResetOriginEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.DNodeContainerItemSemanticEditPolicy;
import org.eclipse.sirius.diagram.ui.tools.api.figure.GradientRoundedRectangle;
import org.eclipse.sirius.diagram.ui.tools.api.figure.InvisibleResizableCompartmentFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SiriusWrapLabel;
import org.eclipse.sirius.diagram.ui.tools.api.figure.ViewNodeContainerFigureDesc;
import org.eclipse.sirius.diagram.ui.tools.api.figure.ViewNodeContainerParallelogram;
import org.eclipse.sirius.diagram.ui.tools.api.figure.ViewNodeContainerRectangleFigureDesc;
import org.eclipse.sirius.diagram.ui.tools.api.layout.LayoutUtils;
import org.eclipse.sirius.diagram.ui.tools.api.policy.CompoundEditPolicy;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.ContainerWithTitleBlockFigure;
import org.eclipse.sirius.diagram.ui.tools.internal.ui.NoCopyDragEditPartsTrackerEx;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.DStylizable;
import org.eclipse.sirius.viewpoint.description.style.LabelBorderStyleDescription;

public abstract class AbstractDiagramContainerEditPart
extends AbstractDiagramElementContainerEditPart
implements IDiagramContainerEditPart {
    public AbstractDiagramContainerEditPart(View view) {
        super(view);
    }

    @Override
    public Class<?> getMetamodelType() {
        return DNodeContainer.class;
    }

    protected void refreshForegroundColor() {
        super.refreshForegroundColor();
        DiagramContainerEditPartOperation.refreshForegroundColor(this);
    }

    protected void refreshBackgroundColor() {
        super.refreshBackgroundColor();
        DiagramContainerEditPartOperation.refreshBackgroundColor(this);
    }

    protected void refreshFont() {
        super.refreshFont();
        DiagramContainerEditPartOperation.refreshFont(this);
    }

    public boolean isRegionContainer() {
        DDiagramElement ddiagramElement = this.resolveDiagramElement();
        if (ddiagramElement instanceof DNodeContainer) {
            DNodeContainer ddec = (DNodeContainer)ddiagramElement;
            return new DNodeContainerExperimentalQuery(ddec).isRegionContainer();
        }
        return false;
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        DiagramContainerEditPartOperation.refreshVisuals(this);
    }

    public Command getCommand(Request request) {
        Command result = null;
        if (request.getType() != null && "paste".equals(request.getType())) {
            Iterable shapeCompartmentChildren = Iterables.filter((Iterable)this.children, ShapeCompartmentEditPart.class);
            if (shapeCompartmentChildren.iterator().hasNext()) {
                ShapeCompartmentEditPart lastShapeCompartmentEditPart = (ShapeCompartmentEditPart)Iterables.getLast((Iterable)shapeCompartmentChildren);
                result = lastShapeCompartmentEditPart.getCommand(request);
            }
            if (result == null) {
                result = super.getCommand(request);
            }
        } else {
            Command cmd = super.getCommand(request);
            result = CommonEditPartOperation.handleAutoPinOnInteractiveMove(this, request, cmd);
        }
        return result;
    }

    protected Command getPortCreationCommand(Command originalCommand, CreateViewRequest request) {
        CompositeCommand compositeCommand = new CompositeCommand("Create View");
        compositeCommand.compose((IUndoableOperation)new CommandProxy(originalCommand));
        Iterator iterDescriptor = request.getViewDescriptors().iterator();
        LayoutUtils.prepareFigureForDummyAdds(this.getBorderedFigure().getBorderItemContainer());
        while (iterDescriptor.hasNext()) {
            EObject containerSemanticElement;
            Object createdElement;
            CreateViewRequest.ViewDescriptor viewDescriptor = (CreateViewRequest.ViewDescriptor)iterDescriptor.next();
            IAdaptable adapt = viewDescriptor.getElementAdapter();
            if (!(adapt instanceof Proxy) || !((createdElement = ((Proxy)adapt).getRealObject()) instanceof DNode) || !((DDiagramElementContainer)(containerSemanticElement = this.resolveSemanticElement())).getActualMapping().getAllBorderedNodeMappings().contains((Object)((DNode)createdElement).getActualMapping())) continue;
            Rectangle bounds = PortLayoutHelper.getBounds(this, (DNode)createdElement, viewDescriptor, (DDiagramElement)containerSemanticElement);
            viewDescriptor.setPersisted(true);
            compositeCommand.compose((IUndoableOperation)new SetBoundsCommand(this.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)viewDescriptor, bounds));
            compositeCommand.compose((IUndoableOperation)SiriusLayoutDataManager.INSTANCE.getAddAdapterMakerCommand(this.getEditingDomain(), (IAdaptable)viewDescriptor));
        }
        LayoutUtils.releaseDummys(this.getBorderedFigure().getBorderItemContainer());
        return new ICommandProxy(compositeCommand.reduce());
    }

    public void reInitFigure() {
        IFigure mainFigure = ((BorderedNodeFigure)this.getFigure()).getMainFigure();
        ArrayList prevChildren = new ArrayList(mainFigure.getChildren());
        InvisibleResizableCompartmentFigure compartment = null;
        SiriusWrapLabel wrapLabel = null;
        NodeFigure tmpFigure = this.createMainFigure();
        for (IFigure object : prevChildren) {
            if (object instanceof InvisibleResizableCompartmentFigure) {
                compartment = (InvisibleResizableCompartmentFigure)object;
            } else if (object instanceof ViewNodeContainerFigureDesc) {
                for (Object object2 : ((ViewNodeContainerFigureDesc)object).getChildren()) {
                    if (!(object2 instanceof SiriusWrapLabel)) continue;
                    wrapLabel = (SiriusWrapLabel)((Object)object2);
                }
            }
            mainFigure.remove(object);
        }
        Object[] tmpChildren = tmpFigure.getChildren().toArray();
        int i = 0;
        while (i < tmpChildren.length) {
            if (tmpChildren[i] instanceof ViewNodeContainerFigureDesc) {
                ViewNodeContainerFigureDesc figure = (ViewNodeContainerFigureDesc)tmpChildren[i];
                if (wrapLabel != null) {
                    for (IFigure child : new ArrayList(figure.getChildren())) {
                        if (!(child instanceof SiriusWrapLabel)) continue;
                        figure.remove(child);
                    }
                    figure.add((IFigure)wrapLabel);
                }
            }
            mainFigure.add((IFigure)tmpChildren[i], i);
            ++i;
        }
        if (compartment != null) {
            mainFigure.add((IFigure)compartment);
        }
    }

    public DragTracker getDragTracker(Request request) {
        if (request instanceof SelectionRequest && ((SelectionRequest)request).isAltKeyPressed()) {
            return new RubberbandDragTracker();
        }
        return new NoCopyDragEditPartsTrackerEx((EditPart)this);
    }

    protected void performDirectEditRequest(Request request) {
        if (request instanceof DirectEditRequest) {
            Request req = new Request();
            req.setType((Object)"direct edit");
            super.performDirectEditRequest(req);
        } else if ("direct edit".equals(request.getType())) {
            super.performDirectEditRequest(request);
        }
    }

    private Option<LabelBorderStyleDescription> hasLabelBorderStyle(DStylizable viewNode) {
        FlatContainerStyleDescription fcsd;
        if (viewNode.getStyle() instanceof FlatContainerStyle && ((FlatContainerStyle)viewNode.getStyle()).getDescription() instanceof FlatContainerStyleDescription && (fcsd = (FlatContainerStyleDescription)((FlatContainerStyle)viewNode.getStyle()).getDescription()).getLabelBorderStyle() != null) {
            return Options.newSome((Object)fcsd.getLabelBorderStyle());
        }
        return Options.newNone();
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new DNodeContainerItemSemanticEditPolicy());
        this.removeEditPolicy("ConnectionHandlesPolicy");
        EditPolicy currentComponentEditPolicy = this.getEditPolicy("ComponentEditPolicy");
        if (currentComponentEditPolicy instanceof CompoundEditPolicy) {
            ResetOriginEditPolicy resetOriginEditPolicy = new ResetOriginEditPolicy();
            resetOriginEditPolicy.setHost((EditPart)this);
            ((CompoundEditPolicy)currentComponentEditPolicy).addEditPolicy((EditPolicy)resetOriginEditPolicy);
        } else {
            CompoundEditPolicy compoundEditPolicy = new CompoundEditPolicy();
            compoundEditPolicy.addEditPolicy(currentComponentEditPolicy);
            compoundEditPolicy.addEditPolicy((EditPolicy)new ResetOriginEditPolicy());
            this.installEditPolicy("ComponentEditPolicy", compoundEditPolicy);
        }
    }

    @Override
    public ViewNodeContainerFigureDesc getPrimaryShape() {
        return (ViewNodeContainerFigureDesc)this.primaryShape;
    }

    @Override
    protected IFigure createNodeShape() {
        EObject eObj = this.resolveSemanticElement();
        ViewNodeContainerFigureDesc shapeFigure = null;
        if (eObj instanceof DDiagramElementContainer) {
            DDiagramElementContainer container = (DDiagramElementContainer)eObj;
            if (container.getOwnedStyle() != null) {
                if (container.getOwnedStyle() instanceof ShapeContainerStyle) {
                    shapeFigure = new ViewNodeContainerParallelogram();
                } else if (container.getOwnedStyle() instanceof WorkspaceImage) {
                    shapeFigure = new ViewNodeContainerRectangleFigureDesc();
                }
            }
        } else {
            this.deactivate();
        }
        if (shapeFigure == null) {
            shapeFigure = new GradientRoundedRectangle(DiagramContainerEditPartOperation.getCornerDimension(this), DiagramContainerEditPartOperation.getBackgroundStyle(this));
        }
        return shapeFigure;
    }

    @Override
    protected NodeFigure createNodePlate() {
        DStylizable viewNode;
        Option<LabelBorderStyleDescription> hasLabelBorderStyle;
        Dimension defaultSize = LayoutUtils.NEW_DEFAULT_CONTAINER_DIMENSION;
        EObject eObj = this.resolveSemanticElement();
        if (eObj instanceof DNodeContainer) {
            defaultSize = new DNodeContainerQuery((DNodeContainer)eObj).getDefaultDimension();
        }
        DefaultSizeNodeFigure result = eObj instanceof DStylizable && eObj instanceof DDiagramElement ? ((hasLabelBorderStyle = this.hasLabelBorderStyle(viewNode = (DStylizable)eObj)).some() ? new ContainerWithTitleBlockFigure(this.getMapMode().DPtoLP(defaultSize.width), this.getMapMode().DPtoLP(defaultSize.height), viewNode, (LabelBorderStyleDescription)hasLabelBorderStyle.get()) : new DefaultSizeNodeFigure(this.getMapMode().DPtoLP(defaultSize.width), this.getMapMode().DPtoLP(defaultSize.height))) : new DefaultSizeNodeFigure(this.getMapMode().DPtoLP(defaultSize.width), this.getMapMode().DPtoLP(defaultSize.height));
        return result;
    }
}

