/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.SetConnectionBendpointsCommand;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.sirius.diagram.ui.business.api.query.ConnectionEditPartQuery;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;

public class SetConnectionBendpointsAccordingToExtremityMoveCommmand
extends SetConnectionBendpointsCommand {
    private boolean sourceMove;
    private PrecisionPoint moveDelta;

    public SetConnectionBendpointsAccordingToExtremityMoveCommmand(TransactionalEditingDomain editingDomain) {
        super(editingDomain);
    }

    protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.getEdgeAdaptor() instanceof ConnectionEditPart) {
            ConnectionEditPart connectionEditPart = (ConnectionEditPart)this.getEdgeAdaptor();
            GraphicalHelper.appliedZoomOnRelativePoint((IGraphicalEditPart)connectionEditPart, (Point)this.moveDelta);
            Connection connection = connectionEditPart.getConnectionFigure();
            Point tempSourceRefPoint = connection.getSourceAnchor().getReferencePoint();
            connection.translateToRelative((Translatable)tempSourceRefPoint);
            Point tempTargetRefPoint = connection.getTargetAnchor().getReferencePoint();
            connection.translateToRelative((Translatable)tempTargetRefPoint);
            PointList connectionPointList = connection.getPoints().getCopy();
            SetConnectionBendpointsAccordingToExtremityMoveCommmand.adaptPointListAndRefPoints(this.sourceMove, (Point)this.moveDelta, (org.eclipse.gef.ConnectionEditPart)connectionEditPart, tempSourceRefPoint, tempTargetRefPoint, connectionPointList);
            this.setNewPointList(connectionPointList, tempSourceRefPoint, tempTargetRefPoint);
            return super.doExecute(monitor, info);
        }
        return Status.OK_STATUS;
    }

    public static void adaptPointListAndRefPoints(boolean sourceMove, Point moveDelta, org.eclipse.gef.ConnectionEditPart connectionEditPart, Point sourceRefPoint, Point targetRefPoint, PointList connectionPointList) {
        Rectangle bounds = sourceMove ? GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)((IGraphicalEditPart)connectionEditPart.getSource())) : GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)((IGraphicalEditPart)connectionEditPart.getTarget()));
        SetConnectionBendpointsAccordingToExtremityMoveCommmand.adaptPointListAndRefPoints(sourceMove, moveDelta, new ConnectionEditPartQuery(connectionEditPart).isEdgeWithRectilinearRoutingStyle(), bounds, sourceRefPoint, targetRefPoint, connectionPointList);
    }

    public static void adaptPointListAndRefPoints(boolean sourceMove, Point moveDelta, boolean isEdgeWithRectilinearRoutingStyle, Rectangle bounds, Point sourceRefPoint, Point targetRefPoint, PointList connectionPointList) {
        if (sourceMove) {
            Option intersectionPoint;
            sourceRefPoint.performTranslate(moveDelta.x, moveDelta.y);
            if (isEdgeWithRectilinearRoutingStyle) {
                LineSeg firstSegment = new LineSeg(connectionPointList.getPoint(0), connectionPointList.getPoint(1));
                if (firstSegment.isHorizontal()) {
                    connectionPointList.setPoint(connectionPointList.getPoint(1).translate(0, moveDelta.y), 1);
                } else {
                    connectionPointList.setPoint(connectionPointList.getPoint(1).translate(moveDelta.x, 0), 1);
                }
            }
            if ((intersectionPoint = GraphicalHelper.getIntersection((Point)sourceRefPoint, (Point)connectionPointList.getPoint(1), (Rectangle)bounds.getTranslated(moveDelta), (boolean)false)).some()) {
                connectionPointList.setPoint((Point)intersectionPoint.get(), 0);
            } else {
                connectionPointList.setPoint(connectionPointList.getPoint(0).translate(moveDelta), 0);
            }
        } else {
            Option intersectionPoint;
            targetRefPoint.performTranslate(moveDelta.x, moveDelta.y);
            if (isEdgeWithRectilinearRoutingStyle) {
                LineSeg lastSegment = new LineSeg(connectionPointList.getPoint(connectionPointList.size() - 2), connectionPointList.getPoint(connectionPointList.size() - 1));
                if (lastSegment.isHorizontal()) {
                    connectionPointList.setPoint(connectionPointList.getPoint(connectionPointList.size() - 2).translate(0, moveDelta.y), connectionPointList.size() - 2);
                } else {
                    connectionPointList.setPoint(connectionPointList.getPoint(connectionPointList.size() - 2).translate(moveDelta.x, 0), connectionPointList.size() - 2);
                }
            }
            if ((intersectionPoint = GraphicalHelper.getIntersection((Point)targetRefPoint, (Point)connectionPointList.getPoint(connectionPointList.size() - 1), (Rectangle)bounds.getTranslated(moveDelta), (boolean)false)).some()) {
                connectionPointList.setPoint((Point)intersectionPoint.get(), connectionPointList.size() - 1);
            } else {
                connectionPointList.setPoint(connectionPointList.getPoint(connectionPointList.size() - 1).translate(moveDelta), connectionPointList.size() - 1);
            }
        }
    }

    public void setSourceMove(boolean sourceMove) {
        this.sourceMove = sourceMove;
        if (sourceMove) {
            this.setLabel("Move first segment (on source side)");
        } else {
            this.setLabel("Move last segment (on target side)");
        }
    }

    public void setMoveDelta(PrecisionPoint moveDelta) {
        this.moveDelta = new PrecisionPoint((Point)moveDelta);
    }
}

