/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.operation;

import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gmf.runtime.common.ui.services.editor.EditorService;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.ConnectionLayerEx;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.OrthogonalRouterUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.RectilinearRouter;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.description.CenteringStyle;
import org.eclipse.sirius.diagram.ui.business.api.query.EdgeQuery;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeEditPart;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.tools.internal.util.GMFNotationUtilities;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;
import org.eclipse.ui.IEditorPart;

public class CenterEdgeEndModelChangeOperation
extends AbstractModelChangeOperation<Void> {
    private Edge edge;
    private Point existingSourceAnchorAbsoluteLocation;
    private Point existingTargetAnchorAbsoluteLocation;
    private Point newTargetAnchorAbsoluteLocation;
    private Point newSourceAnchorAbsoluteLocation;
    private ConnectionEditPart connectionEditPart;
    private Connection connection;
    private boolean useFigure = true;

    public CenterEdgeEndModelChangeOperation(ConnectionEditPart connectionEditPart, Edge edge) {
        this(edge);
        this.connectionEditPart = connectionEditPart;
        this.connection = (Connection)connectionEditPart.getFigure();
    }

    public CenterEdgeEndModelChangeOperation(Edge edge) {
        this.edge = edge;
    }

    public CenterEdgeEndModelChangeOperation(Edge edge, boolean useFigure) {
        this(edge);
        this.useFigure = useFigure;
    }

    @Override
    public Void execute() {
        Routing routingValue = this.getRoutingValue();
        if (!Routing.TREE_LITERAL.equals(routingValue.getLiteral())) {
            if (this.isEdgeSourceCentered() && this.isEdgeTargetCentered()) {
                this.centerEdgeEnds(CenteringStyle.BOTH, routingValue);
            } else if (this.isEdgeSourceCentered()) {
                this.centerEdgeEnds(CenteringStyle.SOURCE, routingValue);
            } else if (this.isEdgeTargetCentered()) {
                this.centerEdgeEnds(CenteringStyle.TARGET, routingValue);
            }
        }
        return null;
    }

    private Routing getRoutingValue() {
        Routing routingValue = Routing.MANUAL_LITERAL;
        EdgeQuery edgeQuery = new EdgeQuery(this.edge);
        if (edgeQuery.isEdgeWithTreeRoutingStyle()) {
            routingValue = Routing.TREE_LITERAL;
        } else if (edgeQuery.isEdgeWithRectilinearRoutingStyle()) {
            routingValue = Routing.RECTILINEAR_LITERAL;
        }
        return routingValue;
    }

    private void centerEdgeEnds(CenteringStyle center, Routing routingValue) {
        Bendpoints bendpoints = this.edge.getBendpoints();
        if (bendpoints instanceof RelativeBendpoints) {
            View edgeSourceView = this.edge.getSource();
            View edgeTargetView = this.edge.getTarget();
            if (edgeSourceView instanceof Node && edgeTargetView instanceof Node) {
                this.setConnectionIfNull();
                Option<Rectangle> sourceBounds = this.getAbsoluteSourceBounds(edgeSourceView);
                Option<Rectangle> targetBounds = this.getAbsoluteTargetBounds(edgeTargetView);
                if (sourceBounds.some() && targetBounds.some()) {
                    this.retrieveAndSetExistingAnchorsAbsoluteLocation((Rectangle)sourceBounds.get(), (Rectangle)targetBounds.get());
                    this.computeAndSetNewAnchorsAbsoluteCoordinates((Rectangle)sourceBounds.get(), (Rectangle)targetBounds.get(), center);
                    PointList newPointList = new PointList();
                    newPointList = this.getAbsolutePointList((RelativeBendpoints)bendpoints);
                    if (!Routing.RECTILINEAR_LITERAL.getLiteral().equals(routingValue.getLiteral())) {
                        this.handleStraightCase(center, (Rectangle)sourceBounds.get(), (Rectangle)targetBounds.get(), newPointList);
                    } else {
                        this.handleRectilinearCase(center, (Rectangle)sourceBounds.get(), (Rectangle)targetBounds.get(), newPointList);
                    }
                    GMFNotationUtilities.setGMFBendpoints(this.edge, newPointList, this.newSourceAnchorAbsoluteLocation, this.newTargetAnchorAbsoluteLocation);
                }
            }
        }
    }

    private Option<Rectangle> getAbsoluteBounds(View gmfView, boolean isSource) {
        if (this.connectionEditPart != null) {
            EditPart editPart = null;
            editPart = isSource ? this.connectionEditPart.getSource() : this.connectionEditPart.getTarget();
            if (editPart instanceof GraphicalEditPart) {
                return Options.newSome((Object)GraphicalHelper.getAbsoluteBoundsIn100Percent((GraphicalEditPart)((GraphicalEditPart)editPart)));
            }
        }
        return GMFHelper.getAbsoluteBounds(gmfView, true);
    }

    private Option<Rectangle> getAbsoluteSourceBounds(View edgeSourceView) {
        return this.getAbsoluteBounds(edgeSourceView, true);
    }

    private Option<Rectangle> getAbsoluteTargetBounds(View edgeTargetView) {
        return this.getAbsoluteBounds(edgeTargetView, false);
    }

    private void handleStraightCase(CenteringStyle center, Rectangle sourceBounds, Rectangle targetBounds, PointList existingPointList) {
        Point sourceLineOrigin = this.newTargetAnchorAbsoluteLocation;
        Point targetLineOrigin = this.newSourceAnchorAbsoluteLocation;
        Point sourceLineTerminus = this.newSourceAnchorAbsoluteLocation;
        Point targetLineTerminus = this.newTargetAnchorAbsoluteLocation;
        if (existingPointList.size() > 2) {
            sourceLineOrigin = existingPointList.getPoint(1);
            targetLineOrigin = existingPointList.getPoint(existingPointList.size() - 2);
        } else if (existingPointList.size() < 2) {
            existingPointList = new PointList(new int[4]);
        }
        Option sourceConnectionPoint = Options.newNone();
        Option targetConnectionPoint = Options.newNone();
        if (center == CenteringStyle.BOTH || center == CenteringStyle.SOURCE) {
            sourceConnectionPoint = GraphicalHelper.getIntersection((Point)sourceLineOrigin, (Point)sourceLineTerminus, (Rectangle)sourceBounds, (boolean)false);
        }
        if (center == CenteringStyle.BOTH || center == CenteringStyle.TARGET) {
            targetConnectionPoint = GraphicalHelper.getIntersection((Point)targetLineOrigin, (Point)targetLineTerminus, (Rectangle)targetBounds, (boolean)false);
        }
        if (sourceConnectionPoint.some() || targetConnectionPoint.some()) {
            if (sourceConnectionPoint.some()) {
                existingPointList.setPoint((Point)sourceConnectionPoint.get(), 0);
                this.centerSourceAnchor();
            }
            if (targetConnectionPoint.some()) {
                existingPointList.setPoint((Point)targetConnectionPoint.get(), existingPointList.size() - 1);
                this.centerTargetAnchor();
            }
        }
    }

    private void handleRectilinearCase(CenteringStyle center, Rectangle sourceBounds, Rectangle targetBounds, PointList existingPointList) {
        int sourceAnchorOrientation = 0;
        int targetAnchorOrientation = 0;
        PointList rectilinear = null;
        if (this.connection != null) {
            rectilinear = this.getRectilinearPointListFromConnection();
            sourceAnchorOrientation = this.computeSourceOrientation(rectilinear);
            targetAnchorOrientation = this.computeTargetOrientation(rectilinear);
        } else {
            rectilinear = existingPointList.getCopy();
            if (rectilinear.size() <= 2) {
                this.computePointListByIntersections(rectilinear, sourceBounds, targetBounds);
            }
            int sourceAnchorSide = RectilinearHelper.getAnchorOffRectangleDirection(rectilinear.getFirstPoint(), sourceBounds);
            int targetAnchorSide = RectilinearHelper.getAnchorOffRectangleDirection(rectilinear.getLastPoint(), targetBounds);
            if (!OrthogonalRouterUtilities.isRectilinear((PointList)rectilinear)) {
                RectilinearHelper.transformToRectilinear(rectilinear, sourceAnchorSide, targetAnchorSide);
            }
            sourceAnchorOrientation = this.computeSourceOrientation(rectilinear);
            targetAnchorOrientation = this.computeTargetOrientation(rectilinear);
        }
        if (rectilinear.size() >= 2) {
            if (center == CenteringStyle.BOTH || center == CenteringStyle.SOURCE) {
                this.handleSourceRectilinearRoutingStyle(sourceBounds, rectilinear, sourceAnchorOrientation);
            }
            if (center == CenteringStyle.BOTH || center == CenteringStyle.TARGET) {
                this.handleTargetRectilinearRoutingStyle(targetBounds, rectilinear, targetAnchorOrientation);
            }
            existingPointList.removeAllPoints();
            existingPointList.addAll(rectilinear);
        }
    }

    private int computeSourceOrientation(PointList rectilinear) {
        if (rectilinear.size() >= 2) {
            return rectilinear.getPoint(0).x() == rectilinear.getPoint(1).x() ? 128 : 64;
        }
        return 0;
    }

    private int computeTargetOrientation(PointList rectilinear) {
        if (rectilinear.size() >= 2) {
            return rectilinear.getPoint(rectilinear.size() - 1).x() == rectilinear.getPoint(rectilinear.size() - 2).x() ? 128 : 64;
        }
        return 0;
    }

    private void computePointListByIntersections(PointList rectilinear, Rectangle sourceBounds, Rectangle targetBounds) {
        Option sourceConnectionPoint = GraphicalHelper.getIntersection((Point)this.existingSourceAnchorAbsoluteLocation, (Point)this.existingTargetAnchorAbsoluteLocation, (Rectangle)sourceBounds, (boolean)false);
        Option targetConnectionPoint = GraphicalHelper.getIntersection((Point)this.existingSourceAnchorAbsoluteLocation, (Point)this.existingTargetAnchorAbsoluteLocation, (Rectangle)targetBounds, (boolean)false);
        if (sourceConnectionPoint.some() && targetConnectionPoint.some()) {
            rectilinear.removeAllPoints();
            rectilinear.addPoint((Point)sourceConnectionPoint.get());
            rectilinear.addPoint((Point)targetConnectionPoint.get());
        }
    }

    private void handleSourceRectilinearRoutingStyle(Rectangle figureBounds, PointList rectilinear, int sourceAnchorRelativeLocation) {
        Point newConnectionPoint = rectilinear.getFirstPoint().getCopy();
        Point secondFromSrc = rectilinear.getPoint(1);
        switch (sourceAnchorRelativeLocation) {
            case 64: {
                newConnectionPoint.setY(this.newSourceAnchorAbsoluteLocation.y());
                secondFromSrc.setY(this.newSourceAnchorAbsoluteLocation.y());
                break;
            }
            case 128: {
                newConnectionPoint.setX(this.newSourceAnchorAbsoluteLocation.x());
                secondFromSrc.setX(this.newSourceAnchorAbsoluteLocation.x());
                break;
            }
        }
        rectilinear.setPoint(newConnectionPoint, 0);
        rectilinear.setPoint(secondFromSrc, 1);
        this.centerSourceAnchor();
    }

    private void handleTargetRectilinearRoutingStyle(Rectangle figureBounds, PointList rectilinear, int targetAnchorRelativeLocation) {
        Point newConnectionPoint = rectilinear.getLastPoint().getCopy();
        Point secondFromTgt = rectilinear.getPoint(rectilinear.size() - 2);
        switch (targetAnchorRelativeLocation) {
            case 64: {
                newConnectionPoint.setY(this.newTargetAnchorAbsoluteLocation.y());
                secondFromTgt.setY(this.newTargetAnchorAbsoluteLocation.y());
                break;
            }
            case 128: {
                newConnectionPoint.setX(this.newTargetAnchorAbsoluteLocation.x());
                secondFromTgt.setX(this.newTargetAnchorAbsoluteLocation.x());
                break;
            }
        }
        rectilinear.setPoint(newConnectionPoint, rectilinear.size() - 1);
        rectilinear.setPoint(secondFromTgt, rectilinear.size() - 2);
        this.centerTargetAnchor();
    }

    private void computeAndSetNewAnchorsAbsoluteCoordinates(Rectangle sourceBounds, Rectangle targetBounds, CenteringStyle center) {
        this.newSourceAnchorAbsoluteLocation = this.existingSourceAnchorAbsoluteLocation;
        this.newTargetAnchorAbsoluteLocation = this.existingTargetAnchorAbsoluteLocation;
        if (center == CenteringStyle.BOTH || center == CenteringStyle.SOURCE) {
            PrecisionPoint newSourceAnchor = new PrecisionPoint(0.5, 0.5);
            this.newSourceAnchorAbsoluteLocation = this.getAbsoluteAnchorCoordinates(sourceBounds, newSourceAnchor);
        }
        if (center == CenteringStyle.BOTH || center == CenteringStyle.TARGET) {
            PrecisionPoint newTargetAnchor = new PrecisionPoint(0.5, 0.5);
            this.newTargetAnchorAbsoluteLocation = this.getAbsoluteAnchorCoordinates(targetBounds, newTargetAnchor);
        }
    }

    private PointList getAbsolutePointList(RelativeBendpoints bendpoints) {
        PointList pointList = new PointList();
        Option<PointList> option = this.getAbsolutePointListFromConnection();
        if (option.some()) {
            pointList = (PointList)option.get();
        } else {
            List relativeBendpoints = bendpoints.getPoints();
            int i = 0;
            while (i < relativeBendpoints.size()) {
                float weight = (float)i / ((float)relativeBendpoints.size() - 1.0f);
                Point absoluteLocation = this.getLocation(this.existingSourceAnchorAbsoluteLocation, this.existingTargetAnchorAbsoluteLocation, (RelativeBendpoint)relativeBendpoints.get(i), weight);
                pointList.addPoint(absoluteLocation);
                ++i;
            }
        }
        return pointList;
    }

    private void retrieveAndSetExistingAnchorsAbsoluteLocation(Rectangle sourceBounds, Rectangle targetBounds) {
        PrecisionPoint sourcePrecisionPoint = new PrecisionPoint(0.5, 0.5);
        PrecisionPoint targetPrecisionPoint = new PrecisionPoint(0.5, 0.5);
        Anchor sourceAnchor = this.edge.getSourceAnchor();
        Anchor targetAnchor = this.edge.getTargetAnchor();
        if (sourceAnchor instanceof IdentityAnchor) {
            sourcePrecisionPoint = BaseSlidableAnchor.parseTerminalString((String)((IdentityAnchor)sourceAnchor).getId());
        }
        if (targetAnchor instanceof IdentityAnchor) {
            targetPrecisionPoint = BaseSlidableAnchor.parseTerminalString((String)((IdentityAnchor)targetAnchor).getId());
        }
        this.existingSourceAnchorAbsoluteLocation = this.getAbsoluteAnchorCoordinates(sourceBounds, sourcePrecisionPoint);
        this.existingTargetAnchorAbsoluteLocation = this.getAbsoluteAnchorCoordinates(targetBounds, targetPrecisionPoint);
    }

    private void centerSourceAnchor() {
        IdentityAnchor a = NotationFactory.eINSTANCE.createIdentityAnchor();
        a.setId(GMFNotationUtilities.getTerminalString(0.5, 0.5));
        this.edge.setSourceAnchor((Anchor)a);
    }

    private void centerTargetAnchor() {
        IdentityAnchor a = NotationFactory.eINSTANCE.createIdentityAnchor();
        a.setId(GMFNotationUtilities.getTerminalString(0.5, 0.5));
        this.edge.setTargetAnchor((Anchor)a);
    }

    private Point getAbsoluteAnchorCoordinates(Rectangle absoluteBounds, PrecisionPoint precisionPoint) {
        return new Point((int)((long)absoluteBounds.x() + Math.round((double)absoluteBounds.width() * precisionPoint.preciseX())), (int)((long)absoluteBounds.y() + Math.round((double)absoluteBounds.height() * precisionPoint.preciseY())));
    }

    private boolean isEdgeSourceCentered() {
        return this.isCentered(true);
    }

    private boolean isEdgeTargetCentered() {
        return this.isCentered(false);
    }

    private boolean isCentered(boolean source) {
        boolean centered = false;
        EObject element = this.edge.getElement();
        if (element instanceof DEdge) {
            EdgeStyle edgeStyle = ((DEdge)element).getOwnedStyle();
            CenteringStyle centeringStyle = edgeStyle.getCentered();
            centered = source ? centeringStyle == CenteringStyle.BOTH || centeringStyle == CenteringStyle.SOURCE : centeringStyle == CenteringStyle.BOTH || centeringStyle == CenteringStyle.TARGET;
        }
        return centered;
    }

    private Point getLocation(Point sourceAnchor, Point targetAnchor, RelativeBendpoint gmfRelativeBendpoint, float weight) {
        PrecisionPoint a1 = new PrecisionPoint(sourceAnchor);
        PrecisionPoint a2 = new PrecisionPoint(targetAnchor);
        return new PrecisionPoint((a1.preciseX() + (double)gmfRelativeBendpoint.getSourceX()) * (1.0 - (double)weight) + (double)weight * (a2.preciseX() + (double)gmfRelativeBendpoint.getTargetX()), (a1.preciseY() + (double)gmfRelativeBendpoint.getSourceY()) * (1.0 - (double)weight) + (double)weight * (a2.preciseY() + (double)gmfRelativeBendpoint.getTargetY()));
    }

    private Option<PointList> getAbsolutePointListFromConnection() {
        Option pointList = Options.newNone();
        if (this.connection != null) {
            pointList = Options.newSome((Object)this.connection.getPoints().getCopy());
        }
        return pointList;
    }

    private void setConnectionIfNull() {
        GraphicalEditPart editPart;
        if (this.connection != null || !this.useFigure) {
            return;
        }
        Option<GraphicalEditPart> option = Options.newNone();
        IEditorPart editorPart = EclipseUIUtil.getActiveEditor();
        if (editorPart instanceof DiagramEditor) {
            option = GMFHelper.getGraphicalEditPart((View)this.edge, (DiagramEditor)editorPart);
        } else {
            List diagramEditors = EditorService.getInstance().getRegisteredEditorParts();
            for (Object object : diagramEditors) {
                if (object instanceof DiagramEditor) {
                    option = GMFHelper.getGraphicalEditPart((View)this.edge, (DiagramEditor)object);
                }
                if (option.some()) break;
            }
        }
        if (option.some() && (editPart = (GraphicalEditPart)option.get()) instanceof DEdgeEditPart) {
            this.connectionEditPart = (DEdgeEditPart)editPart;
            this.connection = ((DEdgeEditPart)editPart).getConnectionFigure();
        }
    }

    private PointList getRectilinearPointListFromConnection() {
        ConnectionRouter oldConnectionRouter = this.connection.getConnectionRouter();
        boolean needToRetrieveOldRouter = false;
        if (!(oldConnectionRouter instanceof RectilinearRouter)) {
            ConnectionLayer cLayer;
            RectilinearRouter connectionRouter = null;
            LayerManager layerManager = LayerManager.Helper.find((EditPart)this.connectionEditPart);
            if (layerManager != null && (cLayer = (ConnectionLayer)layerManager.getLayer((Object)"Connection Layer")) instanceof ConnectionLayerEx) {
                connectionRouter = ((ConnectionLayerEx)cLayer).getRectilinearRouter();
            }
            if (connectionRouter == null) {
                connectionRouter = new RectilinearRouter();
            }
            this.connection.setConnectionRouter((ConnectionRouter)connectionRouter);
            needToRetrieveOldRouter = true;
        }
        this.connection.getConnectionRouter().route(this.connection);
        PointList pointList = this.connection.getPoints().getCopy();
        if (needToRetrieveOldRouter) {
            this.connection.setConnectionRouter(oldConnectionRouter);
            this.connection.getConnectionRouter().route(this.connection);
        }
        return pointList;
    }

    private static class RectilinearHelper {
        private RectilinearHelper() {
        }

        private static void transformToRectilinear(PointList existingPointList, int sourceAnchorRelativeLocation, int targetAnchorRelativeLocation) {
            if (existingPointList.size() == 2) {
                Point offStart = existingPointList.getFirstPoint();
                Point offEnd = existingPointList.getLastPoint();
                Dimension offsetDim = offStart.getDifference(offEnd).scale(0.5);
                offStart.translate(RectilinearHelper.getTranslationValue(sourceAnchorRelativeLocation, Math.abs(offsetDim.width), Math.abs(offsetDim.height)));
                offEnd.translate(RectilinearHelper.getTranslationValue(targetAnchorRelativeLocation, Math.abs(offsetDim.width), Math.abs(offsetDim.height)));
                existingPointList.insertPoint(offStart, 1);
                existingPointList.insertPoint(offEnd, 2);
            }
            int offSourceDirection = RectilinearHelper.getOffShapeDirection(sourceAnchorRelativeLocation);
            int offTargetDirection = RectilinearHelper.getOffShapeDirection(targetAnchorRelativeLocation);
            OrthogonalRouterUtilities.transformToOrthogonalPointList((PointList)existingPointList, (int)offSourceDirection, (int)offTargetDirection);
            RectilinearHelper.removeRedundantPoints(existingPointList);
        }

        private static Dimension getTranslationValue(int position, int xFactorValue, int yFactorValue) {
            Dimension translationDimension = new Dimension();
            if (position == 16) {
                translationDimension.width = xFactorValue;
            } else if (position == 4) {
                translationDimension.height = yFactorValue;
            } else if (position == 8) {
                translationDimension.width = -xFactorValue;
            } else if (position == 1) {
                translationDimension.height = -yFactorValue;
            }
            return translationDimension;
        }

        private static int getAnchorOffRectangleDirection(Point anchorPoint, Rectangle rect) {
            int position = 1;
            int criteriaValue = Math.abs(anchorPoint.y - rect.y);
            int tempCriteria = Math.abs(anchorPoint.y - rect.y - rect.height);
            if (tempCriteria < criteriaValue) {
                criteriaValue = tempCriteria;
                position = 4;
            }
            if ((tempCriteria = Math.abs(anchorPoint.x - rect.x)) < criteriaValue) {
                criteriaValue = tempCriteria;
                position = 8;
            }
            if ((tempCriteria = Math.abs(anchorPoint.x - rect.x - rect.width)) < criteriaValue) {
                criteriaValue = tempCriteria;
                position = 16;
            }
            return position;
        }

        private static int getOffShapeDirection(int anchorRelativeLocation) {
            if (anchorRelativeLocation == 16 || anchorRelativeLocation == 8) {
                return 64;
            }
            if (anchorRelativeLocation == 1 || anchorRelativeLocation == 4) {
                return 128;
            }
            return 0;
        }

        private static boolean removeRedundantPoints(PointList line) {
            int initialNumberOfPoints = line.size();
            if (line.size() > 2) {
                PointList newLine = new PointList(line.size());
                newLine.addPoint(line.removePoint(0));
                while (line.size() >= 2) {
                    Point p0 = newLine.getLastPoint();
                    Point p1 = line.getPoint(0);
                    Point p2 = line.getPoint(1);
                    if (p0.x == p1.x && p0.x == p2.x) {
                        line.removePoint(0);
                        continue;
                    }
                    if (p0.y == p1.y && p0.y == p2.y) {
                        line.removePoint(0);
                        continue;
                    }
                    newLine.addPoint(line.removePoint(0));
                }
                while (line.size() > 0) {
                    newLine.addPoint(line.removePoint(0));
                }
                line.removeAllPoints();
                line.addAll(newLine);
            }
            return line.size() != initialNumberOfPoints;
        }
    }
}

