/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.views.outlineview;

import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.sirius.common.ui.tools.api.util.IObjectActionDelegateWrapper;
import org.eclipse.sirius.common.ui.tools.api.util.SWTUtil;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.DiagramOutlinePage;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.DiagramOutlinePageListener;
import org.eclipse.sirius.diagram.ui.tools.internal.views.providers.filters.FiltersTableViewer;
import org.eclipse.sirius.diagram.ui.tools.internal.views.providers.layers.LayersTableViewer;
import org.eclipse.sirius.diagram.ui.tools.internal.views.providers.outline.OutlineComparator;
import org.eclipse.sirius.diagram.ui.tools.internal.views.providers.outline.OutlineContentProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.views.providers.outline.OutlineLabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.PageBook;

public class DiagramOutlineWithBookPages
extends DiagramOutlinePage {
    protected static final int ID_LAYERS = 3;
    protected static final int ID_FILTERS = 4;
    private static final String LAYER_TIP_TEXT = "Layers";
    private static final String FILTER_TIP_TEXT = "Filters";
    private static final ImageDescriptor DESC_LAYER = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/layers.gif");
    private static final ImageDescriptor DESC_FILTER = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/filters.gif");
    private IAction showLayersAction;
    private IAction showFiltersAction;
    private Control layers;
    private Control filters;

    public DiagramOutlineWithBookPages(Object input, GraphicalViewer viewer, IObjectActionDelegateWrapper[] menuContributions) {
        super(input, (IBaseLabelProvider)new OutlineLabelProvider(), new OutlineContentProvider(), new OutlineComparator(), viewer, menuContributions);
    }

    @Override
    protected void createControls(PageBook pb) {
        super.createControls(pb);
        this.layers = this.createLayersControl((Composite)pb);
        this.filters = this.createFiltersControl((Composite)pb);
    }

    @Override
    protected void configureControls(IToolBarManager tbm) {
        super.configureControls(tbm);
        this.configureLayers(tbm);
        this.configureFilters(tbm);
    }

    private void configureLayers(IToolBarManager tbm) {
        this.showLayersAction = new Action(){

            public void run() {
                DiagramOutlineWithBookPages.this.showPage(3);
            }
        };
        this.showLayersAction.setImageDescriptor(DESC_LAYER);
        this.showLayersAction.setToolTipText(LAYER_TIP_TEXT);
        tbm.add(this.showLayersAction);
    }

    private void configureFilters(IToolBarManager tbm) {
        this.showFiltersAction = new Action(){

            public void run() {
                DiagramOutlineWithBookPages.this.showPage(4);
            }
        };
        this.showFiltersAction.setImageDescriptor(DESC_FILTER);
        this.showFiltersAction.setToolTipText(FILTER_TIP_TEXT);
        tbm.add(this.showFiltersAction);
    }

    @Override
    protected void showPage(int id) {
        switch (id) {
            case 4: {
                super.uncheckProvidedActions();
                this.showLayersAction.setChecked(false);
                this.showFiltersAction.setChecked(true);
                super.showPage(this.filters);
                break;
            }
            case 3: {
                super.uncheckProvidedActions();
                this.showFiltersAction.setChecked(false);
                this.showLayersAction.setChecked(true);
                super.showPage(this.layers);
                break;
            }
            default: {
                this.showLayersAction.setChecked(false);
                this.showFiltersAction.setChecked(false);
                super.showPage(id);
            }
        }
    }

    @Override
    public void dispose() {
        if (this.contentProvider instanceof DiagramOutlinePageListener) {
            this.removeListener((DiagramOutlinePageListener)this.contentProvider);
        }
        this.filters.dispose();
        this.layers.dispose();
        super.dispose();
    }

    protected Control createLayersControl(Composite parent) {
        Composite control = SWTUtil.createCompositeBothFill((Composite)parent, (int)1, (boolean)false);
        LayersTableViewer.createLayersTableViewer(control, this.diagramWorkbenchPart);
        return control;
    }

    protected Control createFiltersControl(Composite parent) {
        Composite control = SWTUtil.createCompositeBothFill((Composite)parent, (int)1, (boolean)false);
        FiltersTableViewer.createFiltersTableViewer(control, this.diagramWorkbenchPart);
        return control;
    }
}

