/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.condition;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.junit.ComparisonFailure;

public class CheckBoundsCondition
extends DefaultCondition {
    private boolean checkWidth = true;
    private boolean checkHeight = true;
    private final IGraphicalEditPart editPartToWaitForSelection;
    private Class<? extends IGraphicalEditPart> editPartClass;
    private final Rectangle expectedBounds;

    public CheckBoundsCondition(IGraphicalEditPart editPartToWaitForSelection, Rectangle expectedAbsoluteBounds) {
        this.editPartToWaitForSelection = editPartToWaitForSelection;
        this.expectedBounds = expectedAbsoluteBounds;
    }

    public CheckBoundsCondition(IGraphicalEditPart editPartToWaitForSelection, Rectangle expectedAbsoluteBounds, boolean checkWidth, boolean checkHeight) {
        this.editPartToWaitForSelection = editPartToWaitForSelection;
        this.expectedBounds = expectedAbsoluteBounds;
        this.checkWidth = checkWidth;
        this.checkHeight = checkHeight;
    }

    public boolean test() throws Exception {
        boolean result = false;
        if (this.editPartToWaitForSelection != null) {
            if (this.checkHeight && this.checkWidth) {
                result = this.getCurrentAbsoluteBounds().equals((Object)this.expectedBounds);
            } else if (this.checkWidth) {
                result = this.getCurrentAbsoluteBounds().width == this.expectedBounds.width;
            } else if (this.checkHeight) {
                result = this.getCurrentAbsoluteBounds().height == this.expectedBounds.height;
            }
        }
        return result;
    }

    public String getFailureMessage() {
        String result = null;
        if (this.checkHeight && this.checkWidth) {
            result = new ComparisonFailure("The expected bounds is not reached.", this.expectedBounds.toString(), this.getCurrentAbsoluteBounds().toString()).getMessage();
        } else if (this.checkWidth) {
            result = new ComparisonFailure("The expected width is not reached.", Integer.toString(this.expectedBounds.width), Integer.toString(this.getCurrentAbsoluteBounds().width)).getMessage();
        } else if (this.checkHeight) {
            result = new ComparisonFailure("The expected width is not reached.", Integer.toString(this.expectedBounds.height), Integer.toString(this.getCurrentAbsoluteBounds().height)).getMessage();
        }
        return result;
    }

    protected Rectangle getCurrentAbsoluteBounds() {
        Rectangle bounds = this.editPartToWaitForSelection.getFigure().getBounds().getCopy();
        this.editPartToWaitForSelection.getFigure().translateToAbsolute((Translatable)bounds);
        return bounds;
    }
}

