/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.actions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.dialect.command.RefreshRepresentationsCommand;
import org.eclipse.sirius.tools.api.command.SiriusCommand;
import org.eclipse.sirius.tree.DTreeElement;
import org.eclipse.sirius.tree.business.internal.helper.RefreshTreeElementTask;
import org.eclipse.sirius.tree.ui.tools.internal.editor.DTreeEditor;
import org.eclipse.sirius.tree.ui.tools.internal.editor.DTreeViewerManager;
import org.eclipse.sirius.ui.business.api.action.RefreshActionListenerRegistry;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class RefreshAction
extends Action
implements IObjectActionDelegate {
    private static final String DEFAULT_NAME = "Refresh Tree Element";
    DTreeEditor treeEditor;
    private ISelection selection;
    private LinkedList<Object> minimizedSelection;

    public RefreshAction(DTreeEditor treeEditor) {
        super(DEFAULT_NAME, DTreeViewerManager.getImageRegistry().getDescriptor("tree/refresh"));
        this.treeEditor = treeEditor;
        this.minimizedSelection = new LinkedList();
    }

    public void run() {
        this.selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        if (this.selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)this.selection;
            this.minimizedSelection = new LinkedList<Object>(Arrays.asList(structuredSelection.toArray()));
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                SiriusCommand result = new SiriusCommand(RefreshAction.this.treeEditor.getEditingDomain());
                Iterable elements = Iterables.filter((Iterable)RefreshAction.this.minimizedSelection, DTreeElement.class);
                result.getTasks().add(new RefreshTreeElementTask((Collection)Lists.newArrayList((Iterable)elements), RefreshAction.this.treeEditor.getEditingDomain(), monitor));
                RefreshAction.this.treeEditor.getEditingDomain().getCommandStack().execute((Command)result);
            }
        };
        this.run(op);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                TransactionalEditingDomain domain = RefreshAction.this.treeEditor.getEditingDomain();
                domain.getCommandStack().execute((Command)new RefreshRepresentationsCommand(domain, monitor, new DRepresentation[]{RefreshAction.this.treeEditor.getTreeModel()}));
            }
        };
        RefreshActionListenerRegistry.INSTANCE.notifyRepresentationIsAboutToBeRefreshed((DRepresentation)this.treeEditor.getTreeModel());
        this.run(op);
    }

    private void run(IRunnableWithProgress op) {
        Shell activeShell = this.treeEditor.getSite().getShell();
        ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(activeShell);
        try {
            try {
                this.treeEditor.enablePropertiesUpdate(false);
                monitorDialog.run(true, false, op);
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError((Shell)activeShell, (String)"Error", (String)e.getTargetException().getMessage());
                SiriusPlugin.getDefault().error("Error while refreshing tree", (Throwable)e);
                this.treeEditor.enablePropertiesUpdate(true);
            }
            catch (InterruptedException e) {
                MessageDialog.openInformation((Shell)activeShell, (String)"Cancelled", (String)e.getMessage());
                this.treeEditor.enablePropertiesUpdate(true);
            }
        }
        finally {
            this.treeEditor.enablePropertiesUpdate(true);
        }
    }

    public void selectionChanged(IAction action, ISelection sel) {
        this.selection = sel;
    }
}

