/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.business.internal.metamodel.query;

import com.google.common.base.Preconditions;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.DTreeItemContainer;
import org.eclipse.sirius.tree.business.internal.helper.TreeHelper;
import org.eclipse.sirius.tree.description.TreeItemDeletionTool;
import org.eclipse.sirius.tree.description.TreeItemMapping;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public class DTreeItemInternalQuery {
    private final DTreeItem item;

    public DTreeItemInternalQuery(DTreeItem item) {
        Preconditions.checkNotNull((Object)item);
        this.item = item;
    }

    public boolean canBeDeleted() {
        boolean result = true;
        TreeItemMapping originMapping = this.item.getActualMapping();
        if (originMapping == null) {
            result = false;
        } else {
            TreeItemDeletionTool delete = originMapping.getDelete();
            if (delete != null) {
                if (delete.getFirstModelOperation() == null) {
                    result = false;
                } else if (delete.getPrecondition() != null && !StringUtil.isEmpty((String)delete.getPrecondition().trim())) {
                    IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)this.item.getTarget());
                    interpreter.setVariable("root", (Object)TreeHelper.getTree(this.item).getTarget());
                    interpreter.setVariable("element", (Object)this.item.getTarget());
                    interpreter.setVariable("container", (Object)((DTreeItemContainer)this.item.eContainer()).getTarget());
                    try {
                        result = interpreter.evaluateBoolean(this.item.getTarget(), delete.getPrecondition());
                    }
                    catch (EvaluationException e) {
                        RuntimeLoggerManager.INSTANCE.error((EObject)delete, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition(), (Throwable)e);
                    }
                    interpreter.unSetVariable("root");
                    interpreter.unSetVariable("element");
                    interpreter.unSetVariable("container");
                }
            }
        }
        return result;
    }
}

