/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.api.dialogs;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.sirius.common.ui.tools.api.util.SWTUtil;
import org.eclipse.sirius.ext.swt.ImageFileFormat;
import org.eclipse.sirius.ui.tools.api.dialogs.AbstractExportRepresentationsAsImagesDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class ExportOneRepresentationAsImageDialog
extends AbstractExportRepresentationsAsImagesDialog {
    private static final String DIALOG_SETTINGS_FILE = "ExportRepresentationsAsImagesDialog.file";
    private static final String INVALID_PATH_MESSAGE = "Invalid path";
    private static final String INVALID_FILE_PATH_MESSAGE = "Invalid file path";
    private static final String TO_FILE = "To file";
    private static final String EXPORT_TO_IMAGE = "Export to Image";
    private static final String DIALOG_TITLE = "Export representation as image file";
    private String fileName;

    public ExportOneRepresentationAsImageDialog(Shell shell, IPath path, String fileName) {
        super(shell, path);
        this.fileName = fileName;
        this.initDialogSettings(path);
    }

    @Override
    protected void handleBrowseButtonPressed() {
        String selectedFileName;
        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.png;*.jpg;*.svg", "*.*"});
        dialog.setText(EXPORT_TO_IMAGE);
        String currentSourceString = this.folderText.getText();
        File file = new File(this.folderText.getText());
        if (file.isFile()) {
            int lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator);
            if (lastSeparatorIndex != -1) {
                dialog.setFileName(currentSourceString.substring(lastSeparatorIndex + 1, currentSourceString.length()));
            }
        } else {
            dialog.setFileName(currentSourceString);
        }
        if ((selectedFileName = dialog.open()) != null) {
            this.folderText.setText(selectedFileName);
            this.changeComboImageFormat();
        }
    }

    @Override
    protected void createImageFormatGroup(Composite parent) {
        Label imageFormatControl;
        Composite composite = SWTUtil.createCompositeHorizontalFill((Composite)parent, (int)3, (boolean)false);
        SWTUtil.createLabel((Composite)composite, (String)"&Image Format:");
        String[] imageSafeFormatItems = this.getImageSafeFormatItems();
        if (imageSafeFormatItems != null && imageSafeFormatItems.length > 0) {
            if (imageSafeFormatItems.length == 1) {
                imageFormatControl = SWTUtil.createLabel((Composite)composite, (String)imageSafeFormatItems[0]);
            } else {
                this.imageFormatCombo = new Combo(composite, 12);
                this.imageFormatCombo.setItems(imageSafeFormatItems);
                this.imageFormatCombo.setText(this.imageFormat.getName());
                imageFormatControl = this.imageFormatCombo;
            }
        } else {
            imageFormatControl = SWTUtil.createLabel((Composite)composite, (String)DEFAULT_VALUE.getName());
        }
        GridData gridData = new GridData(4, 0x1000000, true, true);
        imageFormatControl.setLayoutData((Object)gridData);
    }

    @Override
    protected void createFolderGroup(Composite parent) {
        Composite composite = SWTUtil.createCompositeHorizontalFill((Composite)parent, (int)4, (boolean)false);
        SWTUtil.createLabel((Composite)composite, (String)TO_FILE);
        this.folderText = new Combo(composite, 2052);
        this.restoreWidgetValues();
        Path path = new Path(this.folder);
        if (this.isExistingFolder((IPath)path) || path.getFileExtension() == null) {
            String newExtensionFilePath;
            path = path.addTrailingSeparator();
            path = path.append(this.fileName.replaceAll("[/\\\\]", "_"));
            String extension = this.imageFormat.getName().toLowerCase();
            path = path.addFileExtension(extension);
            this.folder = newExtensionFilePath = path.toFile().getPath();
        }
        this.folderText.setText(this.folder);
        GridData gridData = new GridData(768);
        gridData.widthHint = 350;
        this.folderText.setLayoutData((Object)gridData);
        Button button = new Button(composite, 8);
        button.setText("&Browse...");
        button.setLayoutData((Object)AbstractExportRepresentationsAsImagesDialog.makeButtonData(button));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportOneRepresentationAsImageDialog.this.handleBrowseButtonPressed();
            }
        });
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
    }

    @Override
    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(DIALOG_SETTINGS_FILE);
            if (directoryNames == null || directoryNames.length == 0) {
                return;
            }
            this.folder = directoryNames[0];
            String[] stringArray = directoryNames;
            int n = directoryNames.length;
            int n2 = 0;
            while (n2 < n) {
                String directoryName = stringArray[n2];
                this.folderText.add(directoryName);
                ++n2;
            }
        }
    }

    @Override
    protected void initDialogSettings(IPath path) {
        String persistentImageFormat;
        IDialogSettings dialogSettings = this.getDialogSettings();
        this.folder = "/";
        if (path == null) {
            String persistentFolder = dialogSettings.get(DIALOG_SETTINGS_FILE);
            if (persistentFolder != null) {
                this.folder = persistentFolder;
            }
        } else {
            this.folder = path.toOSString();
        }
        this.imageFormat = (persistentImageFormat = dialogSettings.get("ExportRepresentationsAsImagesDialog.imageFormat")) == null ? AbstractExportRepresentationsAsImagesDialog.getDefaultImageFormat() : AbstractExportRepresentationsAsImagesDialog.resolveImageFormat(persistentImageFormat);
    }

    @Override
    protected void saveDialogSettings() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null) {
            String[] directoryNames = dialogSettings.getArray(DIALOG_SETTINGS_FILE);
            if (directoryNames == null || directoryNames.length == 0) {
                directoryNames = new String[]{this.folder};
            }
            String folderPathToKeepInHistory = this.folder;
            Path path = new Path(this.folder);
            if (!this.isExistingFolder((IPath)path) && path.getFileExtension() != null) {
                folderPathToKeepInHistory = path.removeLastSegments(1).toOSString();
            }
            directoryNames = this.addToHistory(directoryNames, folderPathToKeepInHistory);
            dialogSettings.put(DIALOG_SETTINGS_FILE, directoryNames);
            dialogSettings.put("ExportRepresentationsAsImagesDialog.imageFormat", this.imageFormat.getName());
        }
    }

    @Override
    protected void validateFolderText() {
        super.validateFolderText();
        File file = new File(this.folderText.getText());
        File directory = file.getParentFile();
        Path path = new Path(this.folderText.getText());
        if (file.isDirectory()) {
            this.setDialogErrorState(INVALID_FILE_PATH_MESSAGE);
        } else if (directory == null) {
            this.setDialogErrorState(INVALID_PATH_MESSAGE);
        } else if (!directory.exists()) {
            this.setDialogErrorState("Folder does not exist");
        } else if (path.toString().endsWith("/") || path.toString().endsWith(".")) {
            this.setDialogErrorState(INVALID_PATH_MESSAGE);
        }
    }

    protected void modifyPathWithDefaultFileName() {
        Path path = new Path(this.folderText.getText());
        if (this.isExistingFolder((IPath)path)) {
            path = path.append(this.fileName);
        }
        if (!path.toString().endsWith(".") && path.getFileExtension() == null) {
            path = path.addFileExtension(this.imageFormatCombo.getText().toLowerCase());
            this.folderText.setText(path.toOSString());
        }
        this.changeComboImageFormat();
    }

    private void changeComboImageFormat() {
        String fileExtension;
        Path path = new Path(this.folderText.getText());
        if (!this.isExistingFolder((IPath)path) && !path.toString().endsWith(".") && (fileExtension = path.getFileExtension()) != null) {
            boolean isPresent = false;
            ImageFileFormat[] imageFileFormatArray = SAFE_VALUES;
            int n = SAFE_VALUES.length;
            int n2 = 0;
            while (n2 < n) {
                ImageFileFormat extension = imageFileFormatArray[n2];
                if (extension.getName().toLowerCase().equals(fileExtension.toLowerCase())) {
                    this.imageFormatCombo.setText(extension.getName());
                    isPresent = true;
                    break;
                }
                if ("jpeg".equals(fileExtension.toLowerCase())) {
                    this.imageFormatCombo.setText(ImageFileFormat.JPG.getName());
                    isPresent = true;
                    break;
                }
                ++n2;
            }
            if (!isPresent) {
                StringBuffer fileWithExtensionForbidden = new StringBuffer(this.folderText.getText()).append(".").append(this.imageFormatCombo.getText().toLowerCase());
                this.folderText.setText(fileWithExtensionForbidden.toString());
            }
        }
    }

    @Override
    protected void initListeners() {
        this.changeComboImageFormat();
        this.folderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportOneRepresentationAsImageDialog.this.validateFolderText();
            }
        });
        this.folderText.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                File file = new File(ExportOneRepresentationAsImageDialog.this.folderText.getText());
                if (file.isDirectory()) {
                    ExportOneRepresentationAsImageDialog.this.modifyPathWithDefaultFileName();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.folderText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                Path path = new Path(ExportOneRepresentationAsImageDialog.this.folderText.getText());
                if (!path.toString().endsWith(".") && path.getFileExtension() == null) {
                    path = path.addFileExtension(ExportOneRepresentationAsImageDialog.this.imageFormatCombo.getText().toLowerCase());
                    ExportOneRepresentationAsImageDialog.this.folderText.setText(path.toOSString());
                }
                ExportOneRepresentationAsImageDialog.this.changeComboImageFormat();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        if (this.imageFormatCombo != null) {
            this.imageFormatCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExportOneRepresentationAsImageDialog.this.imageFormat = AbstractExportRepresentationsAsImagesDialog.resolveImageFormat(ExportOneRepresentationAsImageDialog.this.imageFormatCombo.getSelectionIndex());
                    Path path = new Path(ExportOneRepresentationAsImageDialog.this.folder);
                    if (!ExportOneRepresentationAsImageDialog.this.isExistingFolder((IPath)path) && path.getFileExtension() != null) {
                        String extension = ExportOneRepresentationAsImageDialog.this.imageFormat.getName().toLowerCase();
                        path = path.removeFileExtension();
                        path = path.addFileExtension(extension);
                        String newExtensionFilePath = path.toFile().getPath();
                        ExportOneRepresentationAsImageDialog.this.folderText.setText(newExtensionFilePath);
                    }
                }
            });
        }
    }

    private boolean isExistingFolder(IPath path) {
        boolean isExistingFolder = false;
        File file = new File(path.toOSString());
        if (file.exists() && file.isDirectory()) {
            isExistingFolder = true;
        }
        return isExistingFolder;
    }
}

