/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.sirius.common.ui.tools.api.navigator.GroupingContentProvider;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.featureExtensions.FeatureExtensionsUIManager;
import org.eclipse.sirius.ui.tools.api.views.ViewHelper;
import org.eclipse.sirius.ui.tools.internal.views.common.SessionWrapperContentProvider;
import org.eclipse.sirius.ui.tools.internal.views.modelexplorer.extension.IContextMenuActionProvider;
import org.eclipse.sirius.ui.tools.internal.views.modelexplorer.extension.ISessionViewExtension;

public final class ViewHelperImpl
implements ViewHelper {
    private ITreeContentProvider contentProvider;
    private Collection<ISessionViewExtension> extensions = Lists.newArrayList();

    private ViewHelperImpl() {
    }

    public static ViewHelper init() {
        return new ViewHelperImpl();
    }

    @Override
    public AdapterFactory createAdapterFactory() {
        ArrayList<Object> factories = new ArrayList<Object>();
        ComposedAdapterFactory generic = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        factories.add(DialectUIManager.INSTANCE.createAdapterFactory());
        factories.add(FeatureExtensionsUIManager.INSTANCE.createAdapterFactory());
        factories.add(generic);
        factories.add(new ReflectiveItemProviderAdapterFactory());
        return new ComposedAdapterFactory(factories);
    }

    @Override
    public ITreeContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            SessionWrapperContentProvider sessionWrapperContentProvider = new SessionWrapperContentProvider((ITreeContentProvider)new AdapterFactoryContentProvider(this.createAdapterFactory()));
            this.contentProvider = new GroupingContentProvider((ITreeContentProvider)sessionWrapperContentProvider);
            Collection liveProviders = Collections2.transform(this.extensions, (Function)new Function<ISessionViewExtension, ITreeContentProvider>(){

                public ITreeContentProvider apply(ISessionViewExtension from) {
                    return from.getContentProvider();
                }
            });
            sessionWrapperContentProvider.setExtensions(liveProviders);
        }
        return this.contentProvider;
    }

    public Collection<IContextMenuActionProvider> getContextMenuActionsProviders() {
        Collection liveProviders = Collections2.transform(this.extensions, (Function)new Function<ISessionViewExtension, IContextMenuActionProvider>(){

            public IContextMenuActionProvider apply(ISessionViewExtension from) {
                return from.getContextMenuActionProvider();
            }
        });
        return liveProviders;
    }

    public void addExtension(ISessionViewExtension extension) {
        this.extensions.add(extension);
    }

    public void removeExtension(ISessionViewExtension extension) {
        this.extensions.remove(extension);
    }
}

