/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.color;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.color.RGBValuesProvider;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.ViewpointFactory;
import org.eclipse.sirius.viewpoint.description.ColorDescription;
import org.eclipse.sirius.viewpoint.description.ComputedColor;
import org.eclipse.sirius.viewpoint.description.FixedColor;
import org.eclipse.sirius.viewpoint.description.InterpolatedColor;

public class AbstractColorUpdater {
    public static final int DEFAULT_RED_VALUE = 209;
    public static final int DEFAULT_GREEN_VALUE = 209;
    public static final int DEFAULT_BLUE_VALUE = 209;

    protected RGBValues getRGBValueForInterpolatedColor(EObject context, InterpolatedColor descValue) {
        IInterpreter interpreter;
        if (context != null && (interpreter = InterpreterUtil.getInterpreter(context)) != null) {
            return new RGBValuesProvider().getRGBValues(descValue, context, interpreter);
        }
        return ViewpointFactory.eINSTANCE.createRGBValues();
    }

    protected RGBValues getRGBValueForComputedColor(EObject context, ComputedColor descValue) {
        IInterpreter interpreter;
        if (context != null && (interpreter = InterpreterUtil.getInterpreter(context)) != null) {
            return new RGBValuesProvider().getRGBValues(descValue, context, interpreter);
        }
        return ViewpointFactory.eINSTANCE.createRGBValues();
    }

    protected RGBValues getRGBValueForFixedColor(FixedColor descValue) {
        RGBValues newValues = new RGBValuesProvider().getRGBValues(descValue);
        return newValues;
    }

    protected RGBValues createDefaultRGBValue() {
        RGBValues newValues = ViewpointFactory.eINSTANCE.createRGBValues();
        newValues.setRed(209);
        newValues.setGreen(209);
        newValues.setBlue(209);
        return newValues;
    }

    public RGBValues getRGBValuesFromColorDescription(EObject context, ColorDescription descValue) {
        RGBValues newValues = descValue instanceof FixedColor ? this.getRGBValueForFixedColor((FixedColor)descValue) : (descValue instanceof InterpolatedColor ? this.getRGBValueForInterpolatedColor(context, (InterpolatedColor)descValue) : (descValue instanceof ComputedColor ? this.getRGBValueForComputedColor(context, (ComputedColor)descValue) : this.createDefaultRGBValue()));
        return newValues;
    }

    public static boolean areEquals(RGBValues originalValue, RGBValues newValues) {
        if (originalValue != null && newValues != null) {
            return originalValue.getBlue() == newValues.getBlue() && originalValue.getRed() == newValues.getRed() && originalValue.getGreen() == newValues.getGreen();
        }
        return false;
    }
}

