/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.modelingproject;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.api.modelingproject.IModelingElement;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.internal.query.ModelingProjectQuery;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class ModelingProject
implements IProjectNature,
IModelingElement {
    public static final String NATURE_ID = "org.eclipse.sirius.nature.modelingproject";
    public static final String DEFAULT_REPRESENTATIONS_FILE_NAME = "representations.aird";
    private IProject project;
    private URI mainRepresentationsFileURI;
    private boolean valid = true;

    public void configure() throws CoreException {
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public static boolean hasModelingProjectNature(IProject project) {
        try {
            return project.exists() && project.hasNature(NATURE_ID);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static Option<ModelingProject> asModelingProject(IProject project) {
        IProjectNature nature = null;
        if (project != null) {
            try {
                nature = project.getNature(NATURE_ID);
            }
            catch (CoreException coreException) {}
        }
        if (nature instanceof ModelingProject) {
            return Options.newSome((Object)((ModelingProject)nature));
        }
        return Options.newNone();
    }

    public Session getSession() {
        Option<URI> optionalUri = this.getMainRepresentationsFileURI((IProgressMonitor)new NullProgressMonitor());
        if (optionalUri.some()) {
            for (Session session : SessionManager.INSTANCE.getSessions()) {
                if (!((URI)optionalUri.get()).equals(session.getSessionResource().getURI())) continue;
                return session;
            }
        }
        return null;
    }

    public Option<URI> getMainRepresentationsFileURI(IProgressMonitor monitor) throws IllegalArgumentException {
        return this.getMainRepresentationsFileURI(monitor, false, false);
    }

    public Option<URI> getMainRepresentationsFileURI(IProgressMonitor monitor, boolean force, boolean throwException) throws IllegalArgumentException {
        Option mainRepresentationsFileURIOption;
        block12: {
            mainRepresentationsFileURIOption = Options.newNone();
            try {
                monitor.beginTask("Get main representations resource URI", 1);
                if (force) {
                    this.setValid(true);
                    this.mainRepresentationsFileURI = null;
                }
                if (!this.valid || this.mainRepresentationsFileURI != null) break block12;
                try {
                    this.mainRepresentationsFileURI = new ModelingProjectQuery(this).computeMainRepresentationsFileURI((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (IllegalArgumentException e) {
                    try {
                        this.getProject().deleteMarkers("org.eclipse.sirius.modelingMarker", false, 0);
                    }
                    catch (CoreException ce) {
                        SiriusPlugin.getDefault().getLog().log(ce.getStatus());
                    }
                    try {
                        IMarker marker = this.getProject().createMarker("org.eclipse.sirius.modelingMarker");
                        marker.setAttribute("severity", 2);
                        marker.setAttribute("message", (Object)e.getMessage());
                    }
                    catch (CoreException ce) {
                        SiriusPlugin.getDefault().getLog().log(ce.getStatus());
                    }
                    this.setValid(false);
                    if (throwException) {
                        throw e;
                    }
                }
            }
            finally {
                monitor.done();
            }
        }
        if (this.mainRepresentationsFileURI != null) {
            mainRepresentationsFileURIOption = Options.newSome((Object)this.mainRepresentationsFileURI);
        }
        return mainRepresentationsFileURIOption;
    }

    public boolean isMainRepresentationsFile(IFile representationsFile) {
        boolean result = false;
        Option<URI> optionalMainRepresentationsFile = this.getMainRepresentationsFileURI((IProgressMonitor)new NullProgressMonitor());
        if (optionalMainRepresentationsFile.some()) {
            result = ((URI)optionalMainRepresentationsFile.get()).equals(URI.createPlatformResourceURI((String)representationsFile.getFullPath().toString(), (boolean)true));
        }
        return result;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }
}

