/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.logger;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class RuntimeLoggerInterpreterImpl
implements RuntimeLoggerInterpreter {
    private static final String EVALUATION_CONDITION_ERROR = "Evaluation condition error";
    private IInterpreter interpreter;

    protected RuntimeLoggerInterpreterImpl(IInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    @Override
    public Object evaluate(EObject context, EObject descriptionObject, EStructuralFeature descriptionFeature) {
        String expression = (String)descriptionObject.eGet(descriptionFeature);
        try {
            Object result = this.interpreter.evaluate(context, expression);
            return result;
        }
        catch (EvaluationException e) {
            RuntimeLoggerManager.INSTANCE.error(descriptionObject, descriptionFeature, e);
            return null;
        }
    }

    @Override
    public boolean evaluateBoolean(EObject context, EObject descriptionObject, EStructuralFeature descriptionFeature) {
        return this.evaluateBoolean(context, descriptionObject, descriptionFeature, false);
    }

    @Override
    public boolean evaluateBoolean(EObject context, EObject descriptionObject, EStructuralFeature descriptionFeature, boolean flagCondition) {
        String expression = (String)descriptionObject.eGet(descriptionFeature);
        try {
            boolean result = this.interpreter.evaluateBoolean(context, expression);
            return result;
        }
        catch (EvaluationException e) {
            RuntimeLoggerManager.INSTANCE.error(descriptionObject, descriptionFeature, e);
            if (flagCondition) {
                SiriusPlugin.getDefault().error(EVALUATION_CONDITION_ERROR, e);
            }
            return false;
        }
    }

    @Override
    public Integer evaluateInteger(EObject context, EObject descriptionObject, EStructuralFeature descriptionFeature) {
        String expression = (String)descriptionObject.eGet(descriptionFeature);
        try {
            Integer result = this.interpreter.evaluateInteger(context, expression);
            return result;
        }
        catch (EvaluationException e) {
            RuntimeLoggerManager.INSTANCE.error(descriptionObject, descriptionFeature, e);
            return null;
        }
    }

    @Override
    public String evaluateString(EObject context, EObject descriptionObject, EStructuralFeature descriptionFeature) {
        String expression = (String)descriptionObject.eGet(descriptionFeature);
        try {
            String result = this.interpreter.evaluateString(context, expression);
            return result;
        }
        catch (EvaluationException e) {
            RuntimeLoggerManager.INSTANCE.error(descriptionObject, descriptionFeature, e);
            return null;
        }
    }

    @Override
    public EObject evaluateEObject(EObject context, EObject descriptionObject, EStructuralFeature descriptionFeature) {
        String expression = (String)descriptionObject.eGet(descriptionFeature);
        try {
            EObject result = this.interpreter.evaluateEObject(context, expression);
            return result;
        }
        catch (EvaluationException e) {
            RuntimeLoggerManager.INSTANCE.error(descriptionObject, descriptionFeature, e);
            return null;
        }
    }

    @Override
    public Collection<EObject> evaluateCollection(EObject context, EObject descriptionObject, EStructuralFeature descriptionFeature) {
        String expression = (String)descriptionObject.eGet(descriptionFeature);
        try {
            Collection result = this.interpreter.evaluateCollection(context, expression);
            return result;
        }
        catch (EvaluationException e) {
            RuntimeLoggerManager.INSTANCE.error(descriptionObject, descriptionFeature, e);
            return Collections.emptySet();
        }
    }
}

