/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui.tools.api.selection;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.WorkspaceEditingDomainFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ModelElementChooserDialog
extends Dialog {
    private TreeViewer myTreeViewer;
    private EObject mySelectedModelElement;
    private String modelElementType;
    private AdapterFactoryLabelProvider myAdapterFactoryLabelProvider;
    private AdapterFactoryContentProvider myAdapterFactoryContentProvider;
    private TransactionalEditingDomain myEditingDomain;
    private Collection<String> fileExtensions;

    public ModelElementChooserDialog(Shell parentShell, AdapterFactory factory, String modelElementType) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.myAdapterFactoryContentProvider = new AdapterFactoryContentProvider(factory);
        this.myAdapterFactoryLabelProvider = new AdapterFactoryLabelProvider(factory);
        this.modelElementType = modelElementType;
        this.myEditingDomain = WorkspaceEditingDomainFactory.INSTANCE.createEditingDomain();
    }

    public ModelElementChooserDialog(Shell parentShell, AdapterFactory factory, String modelElementType, Collection<String> extensions) {
        this(parentShell, factory, modelElementType);
        this.fileExtensions = extensions;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.getShell().setText("Select a model element");
        this.createModelBrowser(composite);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.setOkButtonEnabled(false);
        return buttonBar;
    }

    public boolean close() {
        this.myEditingDomain.dispose();
        return super.close();
    }

    private void createModelBrowser(Composite composite) {
        this.myTreeViewer = new TreeViewer(composite, 2820);
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 300;
        layoutData.widthHint = 300;
        this.myTreeViewer.getTree().setLayoutData((Object)layoutData);
        this.myTreeViewer.setContentProvider((IContentProvider)new ModelElementsTreeContentProvider());
        this.myTreeViewer.setLabelProvider((IBaseLabelProvider)new ModelElementsTreeLabelProvider());
        this.myTreeViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.myTreeViewer.addFilter((ViewerFilter)new ModelFilesFilter());
        this.myTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new OkButtonEnabler());
    }

    private void setOkButtonEnabled(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
    }

    private boolean isValidModelFile(IFile file) {
        if (this.fileExtensions == null || this.fileExtensions.size() == 0) {
            return true;
        }
        boolean isValid = false;
        String fileExtension = file.getFullPath().getFileExtension();
        for (String extension : this.fileExtensions) {
            if (fileExtension == null || !fileExtension.equals(extension)) continue;
            isValid = true;
            break;
        }
        return isValid;
    }

    public URI getSelectedModelElementURI() {
        Resource resource = this.mySelectedModelElement.eResource();
        return resource.getURI().appendFragment(resource.getURIFragment(this.mySelectedModelElement));
    }

    private static List<String> types(EObject eObject) {
        LinkedList<String> types = new LinkedList<String>();
        types.add(eObject.eClass().getName());
        for (EClass eClass : eObject.eClass().getEAllSuperTypes()) {
            types.add(eClass.getName());
        }
        return types;
    }

    private class ModelElementsTreeContentProvider
    implements ITreeContentProvider {
        private ITreeContentProvider myWorkbenchContentProvider = new WorkbenchContentProvider();

        private ModelElementsTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            Object[] result = this.myWorkbenchContentProvider.getChildren(parentElement);
            if (result == null || result.length <= 0) {
                if (parentElement instanceof IFile) {
                    IFile modelFile = (IFile)parentElement;
                    IPath resourcePath = modelFile.getFullPath();
                    ResourceSet resourceSet = ModelElementChooserDialog.this.myEditingDomain.getResourceSet();
                    Resource modelResource = resourceSet.getResource(URI.createPlatformResourceURI((String)resourcePath.toString(), (boolean)true), true);
                    result = ModelElementChooserDialog.this.myAdapterFactoryContentProvider.getChildren((Object)modelResource);
                } else {
                    result = ModelElementChooserDialog.this.myAdapterFactoryContentProvider.getChildren(parentElement);
                }
            }
            return result;
        }

        public Object getParent(Object element) {
            Object parent = this.myWorkbenchContentProvider.getParent(element);
            if (parent == null && element instanceof EObject) {
                URI eObjectResourceURI;
                EObject eObject = (EObject)element;
                if (eObject.eContainer() == null && (eObjectResourceURI = eObject.eResource().getURI()).isFile()) {
                    String path = eObjectResourceURI.path();
                    parent = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(path));
                }
                if (parent == null) {
                    parent = ModelElementChooserDialog.this.myAdapterFactoryContentProvider.getParent((Object)eObject);
                }
            }
            return parent;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IFile) {
                return ModelElementChooserDialog.this.isValidModelFile((IFile)element);
            }
            return this.myWorkbenchContentProvider.hasChildren(element) || ModelElementChooserDialog.this.myAdapterFactoryContentProvider.hasChildren(element);
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = this.myWorkbenchContentProvider.getElements(inputElement);
            return elements;
        }

        public void dispose() {
            this.myWorkbenchContentProvider.dispose();
            ModelElementChooserDialog.this.myAdapterFactoryContentProvider.dispose();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.myWorkbenchContentProvider.inputChanged(viewer, oldInput, newInput);
            ModelElementChooserDialog.this.myAdapterFactoryContentProvider.inputChanged(viewer, oldInput, newInput);
        }
    }

    private class ModelElementsTreeLabelProvider
    implements ILabelProvider {
        private WorkbenchLabelProvider myWorkbenchLabelProvider = new WorkbenchLabelProvider();

        private ModelElementsTreeLabelProvider() {
        }

        public Image getImage(Object element) {
            Image result = this.myWorkbenchLabelProvider.getImage(element);
            return result != null ? result : ModelElementChooserDialog.this.myAdapterFactoryLabelProvider.getImage(element);
        }

        public String getText(Object element) {
            String result = this.myWorkbenchLabelProvider.getText(element);
            return result != null && result.length() > 0 ? result : ModelElementChooserDialog.this.myAdapterFactoryLabelProvider.getText(element);
        }

        public void addListener(ILabelProviderListener listener) {
            this.myWorkbenchLabelProvider.addListener(listener);
            ModelElementChooserDialog.this.myAdapterFactoryLabelProvider.addListener(listener);
        }

        public void dispose() {
            this.myWorkbenchLabelProvider.dispose();
            ModelElementChooserDialog.this.myAdapterFactoryLabelProvider.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.myWorkbenchLabelProvider.isLabelProperty(element, property) || ModelElementChooserDialog.this.myAdapterFactoryLabelProvider.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.myWorkbenchLabelProvider.removeListener(listener);
            ModelElementChooserDialog.this.myAdapterFactoryLabelProvider.removeListener(listener);
        }
    }

    private class ModelFilesFilter
    extends ViewerFilter {
        private ModelFilesFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean isSelected = true;
            if (element instanceof IContainer) {
                isSelected = true;
            } else if (element instanceof IFile) {
                IFile file = (IFile)element;
                isSelected = ModelElementChooserDialog.this.isValidModelFile(file);
            }
            return isSelected;
        }
    }

    private class OkButtonEnabler
    implements ISelectionChangedListener {
        private OkButtonEnabler() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection;
            if (event.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)event.getSelection()).size() == 1) {
                Object selectedElement = selection.getFirstElement();
                if (selectedElement instanceof IWrapperItemProvider) {
                    selectedElement = ((IWrapperItemProvider)selectedElement).getValue();
                }
                if (selectedElement instanceof FeatureMap.Entry) {
                    selectedElement = ((FeatureMap.Entry)selectedElement).getValue();
                }
                if (selectedElement instanceof EObject) {
                    ModelElementChooserDialog.this.mySelectedModelElement = (EObject)selectedElement;
                    ModelElementChooserDialog.this.setOkButtonEnabled(ModelElementChooserDialog.types(ModelElementChooserDialog.this.mySelectedModelElement).contains(ModelElementChooserDialog.this.modelElementType));
                    return;
                }
            }
            ModelElementChooserDialog.this.mySelectedModelElement = null;
            ModelElementChooserDialog.this.setOkButtonEnabled(false);
        }
    }
}

