/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.command;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionAnchorsCommand;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.description.tool.ReconnectionKind;
import org.eclipse.sirius.diagram.ui.business.api.query.EdgeQuery;
import org.eclipse.sirius.diagram.ui.business.internal.edit.helpers.EdgeReconnectionHelper;
import org.eclipse.sirius.diagram.ui.internal.operation.CenterEdgeEndModelChangeOperation;
import org.eclipse.sirius.ext.base.Option;

public class SiriusSetConnectionAnchorsCommand
extends SetConnectionAnchorsCommand {
    private EdgeReconnectionHelper reconnectingEdgeHelper;

    public SiriusSetConnectionAnchorsCommand(TransactionalEditingDomain editingDomain, String label, View reconnectionTarget, List<Edge> reconnectionTargetEdges, ReconnectionKind reconnectionKind) {
        super(editingDomain, label);
        this.reconnectingEdgeHelper = new EdgeReconnectionHelper(reconnectionTarget, reconnectionTargetEdges, reconnectionKind);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CommandResult commandResult = CommandResult.newOKCommandResult();
        if (this.getEdgeAdaptor() != null) {
            commandResult = super.doExecuteWithResult(progressMonitor, info);
        } else {
            Edge edge = this.reconnectingEdgeHelper.getReconnectedEdge();
            assert (edge != null) : "Null edge in SetConnectionAnchorsCommand";
            if (edge == null) {
                String message = "The semantic model was not correctly updated by the reconnect tool, the diagram part of the reconnect cannot be done";
                commandResult = CommandResult.newErrorCommandResult((String)message);
                DiagramPlugin.getDefault().logWarning(message);
            } else {
                Option<IdentityAnchor> optionalSourceBortherAnchor = new EdgeQuery(edge).getSourceAnchorOfFirstBrotherWithSameSource();
                if (optionalSourceBortherAnchor.some()) {
                    this.setNewSourceTerminal(((IdentityAnchor)optionalSourceBortherAnchor.get()).getId());
                }
                this.updateSourceAnchor(edge);
                Option<IdentityAnchor> optionalTargetBortherAnchor = new EdgeQuery(edge).getTargetAnchorOfFirstBrotherWithSameTarget();
                if (optionalTargetBortherAnchor.some()) {
                    this.setNewTargetTerminal(((IdentityAnchor)optionalTargetBortherAnchor.get()).getId());
                }
                this.updateTargetAnchor(edge);
                CenterEdgeEndModelChangeOperation centerEdgeEndModelChangeOperation = new CenterEdgeEndModelChangeOperation(edge);
                centerEdgeEndModelChangeOperation.execute();
            }
        }
        return commandResult;
    }

    private void updateSourceAnchor(Edge edge) {
        if (this.getNewSourceTerminal() != null) {
            if (this.getNewSourceTerminal().length() == 0) {
                edge.setSourceAnchor(null);
            } else {
                IdentityAnchor a = (IdentityAnchor)edge.getSourceAnchor();
                if (a == null) {
                    a = NotationFactory.eINSTANCE.createIdentityAnchor();
                }
                a.setId(this.getNewSourceTerminal());
                edge.setSourceAnchor((Anchor)a);
            }
        }
    }

    private void updateTargetAnchor(Edge edge) {
        if (this.getNewTargetTerminal() != null) {
            if (this.getNewTargetTerminal().length() == 0) {
                edge.setTargetAnchor(null);
            } else {
                IdentityAnchor a = (IdentityAnchor)edge.getTargetAnchor();
                if (a == null) {
                    a = NotationFactory.eINSTANCE.createIdentityAnchor();
                }
                a.setId(this.getNewTargetTerminal());
                edge.setTargetAnchor((Anchor)a);
            }
        }
    }
}

